<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:l="http://www.w3.org/1999/xlink"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:fb3b="http://www.fictionbook.org/FictionBook3/body"
    xmlns:epub="http://www.idpf.org/2007/ops">
	<xsl:output method="xml" encoding="UTF-8"/>

  <xsl:strip-space elements="fb3b:title"/>

	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="fb3b:fb3-body">
		<html>
      <head>
        <title>Unknown</title>
        <link rel="stylesheet" href="stylesheet.css" type="text/css" />
      </head>
			<body>
				<xsl:apply-templates select="fb3b:title"/>
				<xsl:apply-templates select="fb3b:epigraph"/>
				<xsl:apply-templates select="fb3b:preamble"/>
        <xsl:apply-templates select="." mode="toc"/>
				<xsl:apply-templates select="fb3b:section"/>
			<xsl:choose>
				<xsl:when test="count(fb3b:notes) &gt; 1">
					<div name="notes">
						<xsl:apply-templates select="fb3b:notes" mode="many_notes">
							<xsl:sort data-type="number" case-order="upper-first" select="@show" order="descending"/>
						</xsl:apply-templates>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="fb3b:notes"/>
				</xsl:otherwise>
			</xsl:choose>
			</body>
		</html>
	</xsl:template>

  <!-- TABLE OF CONTENTS-->
  <xsl:template match="fb3b:fb3-body" mode="toc">
    <div class="auto_toc">
      <h1>Table of Contents</h1>
      <ul class="toc">
        <xsl:apply-templates select="fb3b:section" mode="toc" />
      </ul>
    </div>
  </xsl:template>

  <xsl:template match="fb3b:section" mode="toc">
    <xsl:if test="fb3b:title|fb3b:section">
      <li>
        <xsl:if test="fb3b:title">
          <p>
            <a href="#u{@id}"><xsl:apply-templates select="./fb3b:title" mode="toc"/></a>
          </p>
        </xsl:if>
        <xsl:if test="./fb3b:section">
          <ul>
            <xsl:apply-templates select="fb3b:section" mode="toc" />
          </ul>
        </xsl:if>
      </li>
    </xsl:if>
  </xsl:template>

  <xsl:template match="fb3b:p" mode="toc">
    <xsl:if test="position() &gt; 1">
      <xsl:text> </xsl:text>
    </xsl:if>
    <!--<xsl:value-of select="text()"/>-->
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="fb3b:title" mode="notes">
		<sup><xsl:apply-templates/></sup>
	</xsl:template>
  
	<xsl:template match="fb3b:notebody/fb3b:title" mode="note_title">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="fb3b:notebody/fb3b:title"/>

	<xsl:template match="fb3b:notebody/fb3b:p">
    <p><xsl:if test="count(preceding-sibling::fb3b:p)=0">
      <xsl:if test="../@id"><a href="#ret_{../@id}">[^]</a><xsl:text> </xsl:text></xsl:if>
      <xsl:if test="../fb3b:title"><sup><xsl:apply-templates select="../fb3b:title" mode="note_title"/></sup><xsl:text> </xsl:text></xsl:if>
    </xsl:if><xsl:apply-templates/></p>
	</xsl:template>

  <xsl:template match="fb3b:section/fb3b:title">
    <xsl:variable name="depth" select="count(ancestor-or-self::fb3b:section)"/>
    <xsl:choose>
      <xsl:when test="$depth &gt; 3">
    <h5>
      <xsl:attribute name="id">h<xsl:value-of select="../@id"/></xsl:attribute>
      <xsl:apply-templates/>
    </h5>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="hlevel" select="$depth +1"/>
        <xsl:element name="h{$hlevel}">
          <xsl:attribute name="id">h<xsl:value-of select="../@id"/></xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="fb3b:title">
		<h1><xsl:apply-templates/></h1>
	</xsl:template>

	<xsl:template match="fb3b:subtitle">
		<h6><xsl:if test="@id"><xsl:attribute name="id">u<xsl:value-of select="@id"/></xsl:attribute></xsl:if>
			<xsl:apply-templates/>
		</h6>
	</xsl:template>

  <xsl:template match="fb3b:title/fb3b:p">
    <xsl:apply-templates/><xsl:if test="not(position()=last())"><br/></xsl:if>
  </xsl:template>

  <xsl:template match="fb3b:p">
		<xsl:variable name="notimgtags_inside"><xsl:value-of select="count(*[name() != 'img'])"/></xsl:variable>
		<xsl:variable name="images_inside"><xsl:value-of select="count(fb3b:img)"/></xsl:variable>
		<xsl:variable name="p_text"><xsl:value-of select="normalize-space(.)"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="$images_inside = 1 and $notimgtags_inside = 0 and string-length($p_text) = 0">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<p>
					<xsl:if test="@id"><xsl:attribute name="id">u<xsl:value-of select="@id"/></xsl:attribute></xsl:if>
					<xsl:apply-templates/>
				</p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="fb3b:subscription">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="fb3b:preamble">
			<div class="preamble">
				<xsl:apply-templates/>
			</div>
	</xsl:template>

	<xsl:template match="fb3b:section">
		<div>
			<xsl:if test="@id"><xsl:attribute name="id">u<xsl:value-of select="@id"/></xsl:attribute></xsl:if>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<xsl:template match="fb3b:epigraph">
		<div class="epigraph"><xsl:apply-templates/></div>
	</xsl:template>
  <xsl:template match="fb3b:annotation">
    <div class="annotation"><xsl:apply-templates/></div>
  </xsl:template>
  <xsl:template match="fb3b:br">
		<p><br/></p>
	</xsl:template>

	<xsl:template match="fb3b:pre">
		<pre>
			<xsl:apply-templates/>
		</pre>
	</xsl:template>

	<xsl:template match="fb3b:blockquote">
		<blockquote>
			<xsl:if test="@id"><xsl:attribute name="id">u<xsl:value-of select="@id"/></xsl:attribute></xsl:if>
			<xsl:apply-templates/>
		</blockquote>
	</xsl:template>

	<xsl:template match="fb3b:div">
		<xsl:variable name="notptags_inside"><xsl:value-of select="count(*[name() != 'p'])"/></xsl:variable>
		<xsl:variable name="p_inside"><xsl:value-of select="count(fb3b:p)"/></xsl:variable>
		<xsl:variable name="p_text"><xsl:value-of select="normalize-space(.)"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="$p_inside = 1 and $notptags_inside = 0 and string-length($p_text) = 0">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<xsl:if test="@id"><xsl:attribute name="id">u<xsl:value-of select="@id"/></xsl:attribute></xsl:if>
          <xsl:if test="@on-one-page = 'true'"><xsl:attribute name="class">nobreak</xsl:attribute></xsl:if>
          <xsl:copy-of select="@width|@min-width|@max-width"/>
					<xsl:apply-templates/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="fb3b:img">
		<img src="{@src}">
			<xsl:if test="@alt"><xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute></xsl:if>
			<xsl:if test="@id"><xsl:attribute name="id">u<xsl:value-of select="@id"/></xsl:attribute></xsl:if>
		</img>
	</xsl:template>

	<xsl:template match="fb3b:em|fb3b:strong|fb3b:sub|fb3b:sup">
		<xsl:element name="{local-name()}"><xsl:apply-templates/></xsl:element>
	</xsl:template>
	<xsl:template match="fb3b:strikethrough">
		<strike><xsl:apply-templates/></strike>
	</xsl:template>
	<xsl:template match="fb3b:underline">
		<u><xsl:apply-templates/></u>
	</xsl:template>
  <xsl:template match="fb3b:spacing">
    <span class="expanded"><xsl:apply-templates/></span>
  </xsl:template>
  <xsl:template match="fb3b:smallcaps">
    <span class="smallcap"><xsl:apply-templates/></span>
  </xsl:template>

	<xsl:template match="fb3b:paper-page-break">
    <xsl:variable name="pgbefore" select="@page-before"/>
    <xsl:choose>
      <xsl:when test="@page-after">
        <a><xsl:attribute name="id">page<xsl:value-of select="@page-after"/></xsl:attribute></a>
      </xsl:when>
      <xsl:otherwise>
        <a><xsl:attribute name="id">page<xsl:value-of select="@page-before +1"/></xsl:attribute></a>
      </xsl:otherwise>
    </xsl:choose>
		<xsl:apply-templates/>
	</xsl:template>

  <xsl:template match="fb3b:marker|fb3b:span">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="fb3b:a">
		<a href="{@l:href}"><xsl:apply-templates/></a>
	</xsl:template>

	<xsl:template match="fb3b:note">
		<sup><a href="#u{@href}" id="ret_{@href}" epub:type="noteref">[<xsl:apply-templates/>]</a></sup>
	</xsl:template>


	<xsl:template match="fb3b:code">
		<xsl:choose>
			<xsl:when test="ancestor::fb3b:stanza">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<pre><xsl:apply-templates/></pre>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="fb3b:poem">
		<blockquote class="poem">
			<xsl:apply-templates mode="poem"/>
		</blockquote>
	</xsl:template>
	<xsl:template match="*" mode="poem">
		<xsl:apply-templates select="."/>
	</xsl:template>
	<xsl:template match="fb3b:subscription" mode="poem">
		<p class="author">
			<xsl:apply-templates mode="poem_subscription"/>
		</p>
	</xsl:template>
	<xsl:template match="fb3b:p|fb3b:ul/fb3b:li|fb3b:ol/fb3b:li" mode="poem_subscription">
		<xsl:if test="position() != 1"><xsl:text>  </xsl:text></xsl:if>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="fb3b:br" mode="poem_subscription"/>

	<xsl:template match="fb3b:stanza">
		<p class="stanza">
			<xsl:apply-templates mode="stanza"/>
		</p>
	</xsl:template>
	<xsl:template match="fb3b:p" mode="stanza">
		<xsl:apply-templates/><br/>
	</xsl:template>
	<xsl:template match="fb3b:br" mode="stanza"/>

	<xsl:template match="fb3b:table|fb3b:tr|fb3b:th|fb3b:td">
		<xsl:element name="{local-name()}"><xsl:apply-templates/></xsl:element>
	</xsl:template>

	<xsl:template match="fb3b:ul">
		<ul>
      <xsl:if test="@type"><xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute></xsl:if>
      <xsl:apply-templates/>
		</ul>
	</xsl:template>
	<xsl:template match="fb3b:ol">
		<ol>
			<xsl:apply-templates/>
		</ol>
	</xsl:template>
	<xsl:template match="fb3b:li">
		<li><p><xsl:apply-templates/></p></li>
	</xsl:template>

	<xsl:template match="fb3b:notes">
		<xsl:apply-templates mode="notes"/>
	</xsl:template>
	<xsl:template match="fb3b:notes" mode="many_notes">
		<xsl:apply-templates mode="notes"/>
	</xsl:template>
	<xsl:template match="fb3b:notebody" mode="notes">
		<div class="footnote" id="u{@id}" epub:type="footnote"><xsl:apply-templates/></div>
	</xsl:template>

  <xsl:template match="*">
    <xsl:comment>TODO: <xsl:value-of select="name()"/></xsl:comment><xsl:apply-templates/>
  </xsl:template>
</xsl:stylesheet>
