#!/bin/sh

file="/mnt/onboard/.kobo/Kobo/Kobo eReader.conf"

locale="sk"
searchstr="ExtraLocales="
section="ApplicationPreferences"

ret=`grep $searchstr "$file" | sed 's/^.*=//'`
if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$locale" "$file"
else
    if [ "${ret#*$locale}" = "$ret" ]; then
        sed -i "s/\($searchstr.*\)/\1, $locale/" "$file"
    fi
fi

curlocale="sk_SK"
searchstr="CurrentLocale="
section="ApplicationPreferences"

ret=`grep $section "$file"`
if [ -z "$ret" ]; then
    echo "" >> "$file"
    echo "[$section]" >> "$file"
fi

ret=`grep $searchstr "$file" | sed 's/^.*=//'`

if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$curlocale" "$file"
else
    if [ "${ret%$curlocale}" = "$ret" ]; then
        sed -i "s/\($searchstr\)\(.*\)/\1$curlocale/" "$file"
    fi
fi

state="false"
searchstr="FullScreenReading="
section="FeatureSettings"

ret=`grep $section "$file"`
if [ -z "$ret" ]; then
    echo "" >> "$file"
    echo "[$section]" >> "$file"
fi

ret=`grep $searchstr "$file" | sed 's/^.*=//'`

if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$state" "$file"
else
    if [ "${ret%$state}" = "$ret" ]; then
        sed -i "s/\($searchstr\)\(.*\)/\1$state/" "$file"
    fi
fi

rm /etc/udev/rules.d/update_conf.rules
rm /root/update_conf.sh
