# -!- coding:utf-8 -!-

from calibre.customize import MetadataReaderPlugin
import calibre.ebooks.metadata.book.base
from calibre.ebooks.metadata import check_isbn
from calibre.utils.zipfile import ZipFile

from lxml import etree

load_translations()

def _xml_get_member(zipfile, member):
   for k in zipfile.NameToInfo:
      if k.upper()==member.upper():
         member=k
         break
   if member in zipfile.NameToInfo:
      zi=zipfile.NameToInfo[member]
      fd=zipfile.open(zi)
      res=etree.parse(fd)
      root=res.getroot()
      fd.close()
   else:
      raise Exception("Member not found!")
   return root

_valid_ext=frozenset(['jpg','jpeg','png','svg'])

def _get_cover(zipfile, member):
   for k in zipfile.NameToInfo:
      if k.upper()==member.upper():
         member=k
         break
   if member in zipfile.NameToInfo:
      zi=zipfile.NameToInfo[member]
      ext=member.rsplit('.')[-1].lower()
      if ext in _valid_ext:
         if ext=='jpg': ext='jpeg'
         fd=zipfile.open(zi)
         img=fd.read()
         fd.close()
         return (ext, img)
   return None

def _NS(ns, tag):
   return "{%s}%s"%(ns, tag)

REL="http://schemas.openxmlformats.org/package/2006/relationships"
FBD="http://www.fictionbook.org/FictionBook3/description"

REL_ROOT=_NS(REL,"Relationships")
REL_REL=_NS(REL,"Relationship")
REL_BOOK="http://www.fictionbook.org/FictionBook3/relationships/Book"
REL_THUMB="http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail"

DESC_ROOT=_NS(FBD,"fb3-description")
DESC_TITLE=_NS(FBD,"title")
DESC_MAIN=_NS(FBD,"main")
DESC_LANG=_NS(FBD,"lang")
DESC_ANNOT=_NS(FBD,"annotation")
DESC_RELS=_NS(FBD,"fb3-relations")
DESC_CLASS=_NS(FBD,"fb3-classification")
DESC_SUBJ=_NS(FBD,"subject")
DESC_DI=_NS(FBD,"document-info")
DESC_PAPER=_NS(FBD,"paper-publish-info")
DESC_ISBN=_NS(FBD,"isbn")

DESC_MAINTITLE=DESC_TITLE+'/'+DESC_MAIN

def _get_author_name(relnode):
   title=relnode.find(DESC_MAINTITLE)
   if title is not None:
      return title.text
   else:
     print "A?:", list(relnode)
   return None

class FB3File:
   def __init__(self, stream):
      try:
         self.title=None
         self.authors=None
         self.language=None
         self.translators=None
         self.publisher=None
         self.cover=None
         self.annotation=None
         self.isbn=None
         self.genres=None
         description=None
         cover=None
         zf=ZipFile(stream)
         root=_xml_get_member(zf, "_rels/.rels")
         if root.tag==REL_ROOT:
            rels=root.findall(REL_REL)
            for e in rels:
               if e.get('Type')==REL_BOOK:
                  description=e.get('Target')
               elif e.get('Type')==REL_THUMB:
                  cover=e.get('Target')
         if description:
            root=_xml_get_member(zf, description)
            if root.tag==DESC_ROOT:
               title=root.find(DESC_MAINTITLE)
               if title is not None:
                  self.title=title.text
               lang=root.find(DESC_LANG)
               if lang is not None:
                  self.language=lang.text
               self._get_contrib(root)
               isbn=root.find(DESC_DI+'/'+DESC_ISBN)
               if isbn is None:
                  isbn=root.find(DESC_PAPER+'/'+DESC_ISBN)
               if isbn is not None:
                  self.isbn=isbn.text.strip()
               glist=[]
               genres=root.findall(DESC_CLASS+'/'+DESC_SUBJ)
               for e in genres:
                  if e.text:
                     glist.append(e.text.lower())
               if glist:
                  self.genres=glist
               self._get_annot(root)
         if cover:
            self.cover=_get_cover(zf, cover)
         zf.close()
      except Exception as e:
         print "Exception:", e
         raise Exception("Not a ZIP file!")
         raise e

   def _get_annot(self, root):
      annroot=root.find(DESC_ANNOT)
      alines=[]
      if annroot is not None:
         for e in annroot:
            itx=e.itertext()
            txt=' '.join([z for z in itx])
            alines.append(txt.strip())
      if alines:
         self.annotation='\n'.join(alines)

   def _get_contrib(self, root):
      autlist=[]
      trlist=[]
      rels=root.findall(DESC_RELS+'/'+DESC_SUBJ)
      for e in rels:
         if e.get('link')=='author':
            aname=_get_author_name(e)
            if aname:
               autlist.append(aname)
         elif e.get('link')=='translator':
            aname=_get_author_name(e)
            if aname:
               trlist.append(aname)
         elif e.get('link')=='publisher':
            title=e.find(DESC_MAINTITLE)
            if title is not None:
               self.publisher=title.text
      if autlist: self.authors=autlist
      if trlist: self.translators=trlist


class FB3ReadMetadata(MetadataReaderPlugin):
   name = "Read FB3 Metadata"
   author = "Sarmat89"
   description = _("Reads the metadata from FB3 files")
   version = (0, 2, 0)
   minimum_calibre_version = (0, 7, 0)
   file_types=set(['fb3'])

   def __init__(self, *args, **kwargs):
      self.plugin_path=args[0]

   def get_metadata(self, stream, type):
      try:
         fb3=FB3File(stream)
         md=calibre.ebooks.metadata.book.base.Metadata(fb3.title)
         if fb3.authors:
            md.authors=fb3.authors
         if fb3.language:
            md.language=fb3.language
         if fb3.publisher:
            md.publisher=fb3.publisher
         if fb3.annotation:
            md.comments=fb3.annotation
         if fb3.cover:
            md.cover_data=fb3.cover
         if fb3.isbn:
            md.isbn=check_isbn(fb3.isbn)
         if fb3.genres:
            md.tags=[t.capitalize() for t in fb3.genres]
         return md
      except Exception as e:
         print "Exception:", e
         raise e
