#!/usr/bin/perl 

#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;
use Tk;
use Tk::HList;
use Tk::NoteBook;
use File::Find;
use File::Basename;
use File::Spec::Functions qw(curdir rel2abs catfile);
use FindBin qw($RealBin);

### Globals ###
my $VERSION = "0.3.1";
my @SearchPaths = (rel2abs(curdir() ) );
my $CurSearchPath = (rel2abs(curdir() ) );
my %noteTabs;
my %book_info_for;
my %Config;
my @Imps;
my $RCFILE = catfile($RealBin,"impfindGUI.rc"); 
my $searchType;
my $KeyWordSearch;
my $SearchEntry;
my $SearchFor;

# create window
my $mw = MainWindow->new( 	-title => "Imp find GUI");
#$mw->geometry("500x200+100+120");
# create menubar
my $menu = $mw->Menu();
my $file_menu = $menu->cascade
    ( -label => 'File' );
$file_menu->command
    ( -label => 'Exit', -command => \&_End);
my $help_menu = $menu->cascade
    ( -label => 'Help' );
$help_menu->command
    ( -label => 'Help', -command => \&_Help );
$mw->configure( -menu => $menu );

my $book = $mw->NoteBook()->pack(-fill=>'both', -expand=>1);

$noteTabs{'Search'} = $book->add( "Sheet 1", -label=>"Search");
#$noteTabs{'Convert'} = $book->add( "Sheet 2", -label=>"Convert");
#$noteTabs{'Transfer'} = $book->add( "Sheet 3", -label=>"Transfer");
$noteTabs{'Configure'} = $book->add( "Sheet 4", -label=>"Configure");

#################################
# Widgets in tabs 
#################################

##### Search Tab #####
my $sFrame = $noteTabs{'Search'}->Frame(-relief => 'raised',-borderwidth => 3,)->
	pack( -fill=>'both', -expand=>0, -side=>'top');
$sFrame->Label( -text=>"Path")->grid( -column => 0,-row => 0,);
$sFrame->Entry(	-textvariable	=> \$CurSearchPath,
				-background 	=> 'white',
				)-> grid (	-column => 1,
							-row 	=> 0,
							-stick 	=> 'ew',
							);
$sFrame->Button(	-text 		=> "Browse",
				-command 	=> sub {$CurSearchPath = $noteTabs{'Search'}->chooseDirectory(-title=>"Choose Search Dir");},
				)-> grid (-column => 2, -row => 0, );
my $reCurse;
my $reCursechk = $sFrame->Checkbutton(	-text => "Recursive",
										-variable => \$reCurse,
									  )-> grid(-column => 0,-row => 1,);
$reCursechk -> deselect();
$sFrame->Button( 	-text => "Search",
					-command => \&LoadBookList,
				)-> grid (-column => 1, -row => 1);
$sFrame->Label(-text=>"Books Found")->grid(-column => 2, -row => 1);
my $TotalBooks = $sFrame->Label(-text => "0")->grid(-column => 3, -row => 1);
my $KeyWordChk = $sFrame->Checkbutton(	-text => "Keyword Search",
										-variable => \$KeyWordSearch,
										-command	=> sub {if($KeyWordSearch){
															$SearchEntry->configure(-state => 'normal');}
															else {
																$SearchEntry->configure(-state => 'disabled');}
															}
									  )->grid(-column => 1, -row => 2);
my $sTypeFrm = $sFrame->Frame()->grid(-column => 1, -row =>3);
$sTypeFrm->Radiobutton(	-text => "All",
						-value => "All",
						-variable => \$searchType,
						)->grid(-column=>0,-row =>0)->select;
$sTypeFrm->Radiobutton(	-text	=> "Title",
						-value	=> "Title",
						-variable 	=> \$searchType,
						)->grid(-column=>1,-row=>0);
$sTypeFrm->Radiobutton(	-text		=> "Author",
						-value		=> "Author",
						-variable	=> \$searchType,
						)->grid(-column=>2,-row=>0);
$sTypeFrm->Radiobutton(	-text		=> "Category",
						-value		=> "Category",
						-variable	=> \$searchType,
						)->grid(-column=>3, -row=>0);
$SearchEntry = $sFrame->Entry(	-state 			=> 'disabled',
									-background 	=> 'white',
									-textvariable 	=> \$SearchFor,
								)->grid(-column => 1, -row => 4);
$SearchEntry->bind('<Return>',\&LoadBookList);

my $lFrame = $noteTabs{'Search'}->Frame(-relief => 'raised',-borderwidth => 3,)->
	pack(-fill=>'both',-expand=>1, -side=>'bottom');

my $bookList = $lFrame->Scrolled("HList",
							-header => 1,
							-columns => 4,
							-scrollbars => 'osoe',
							-width => 70,
							-background => 'white',	
							-selectbackground => 'SeaGreen3',
		       				)-> pack (-expand => 1, -fill => 'both',);
								#grid(  -column => 0, -row => 0, -sticky => 'nsew',);
$bookList->header('create',0,-text => "Category");
$bookList->header('create',1,-text => "Title");
$bookList->header('create',2,-text => "Author");
$bookList->header('create',3,-text => "Path");


##### Configure Tab #####

$noteTabs{'Configure'}->Label(-text => "Default Path to Search for Books"
							)->grid(-column => 0, -row => 0);
$noteTabs{'Configure'}->Entry(-background => 'white',
							  -textvariable => \$Config{'DefaultPath'},
							)->grid(-column=>1,-row=>0);


# Main Window key bindings applies no matter what
# widget has focus
$mw->bind
    ( "<Alt-F4>" => sub { exit } );

&_LoadRCFile;
#print "Config Setting RC File " . $RCFILE . "\n";
# event loop
MainLoop();

&_End;
exit;
##############################
# callbacks
##############################
sub LoadBookList {
	my @imps;  
	my @info;
	my @fields = ("id","Category","sub_category","Title","author_last","author_mid","Author");
	my @search_fields = ("Category","Title","Author");
	my $field;
	my $col_num;
	my $row_name = 0;

	@Imps = ();
	%book_info_for = ();
	$bookList->delete('all');
	&FindBooks($CurSearchPath);
	@imps = @Imps; #need to fix this and get rid of the global @Imps
				   #@imps = &FindBooks($CurSearchPath);
	foreach $book (@imps) { 
		#print "$book\n";
		@info = get_book_info($book);
		# handle selective search for books
		if ($KeyWordSearch){
			my $found_it = 0;
			my $search_term = lc($SearchFor);
			if($searchType eq "All"){
				foreach (@info){
					my $f = lc($_);
					$found_it = 1 if $f =~ /$search_term/;
				}
			}
			if($searchType eq "Title"){
				$found_it = 1 if lc($info[3]) =~ /$search_term/; 
			}
			if($searchType eq "Author"){
				$found_it = 1 if lc($info[6]) =~ /$search_term/;
			}
			if($searchType eq "Category"){
				$found_it = 1 if lc($info[1]) =~ /$search_term/;
			}
			next if ! $found_it;
		}

		foreach $field (@fields){
			$book_info_for{$book}->{$field} = shift @info ;
		}
	}
	foreach $book (keys %book_info_for){
		#$row_name = $book_info_for{$book}->{'id'} ;
		$bookList->add($row_name);
		for( $col_num = 0; $col_num <= $#search_fields; $col_num++) {
			$bookList->itemCreate($row_name,$col_num,
						-text => $book_info_for{$book}->{$search_fields[$col_num]} );
			#print "Creating $row_name Column $col_num " . $book_info_for{$book}->{$search_fields[$col_num]} . "\n";
		}
		$bookList->itemCreate($row_name,$col_num,-text=>$book);
		$row_name++;
	}
	#Set Label to show total books
	$TotalBooks->configure(-text=>$row_name);
}


##########################
# Subs
##########################

sub _LoadRCFile
{
	
	if (-e "$RCFILE")
	{
		# Get the list of directories that we using from the webprefs file in the top directory
		
		open RC, "$RCFILE" or die "Cant open $RCFILE for reading:$!\n";
		
		while (<RC>)
		{
			chomp;
			s/#.*//;
			s/^\s+//;
			s/\s+$//;
			next unless length;
			my ($var, $value) = split(/\s*=\s*/,$_,2);
			$Config{$var} = $value;
		}
		close RC;
		$CurSearchPath = $Config{'DefaultPath'} if defined $Config{'DefaultPath'};
	}
}

sub _WriteRCFile {
	my $k;

	open RC, ">$RCFILE" or die "Cant open $RCFILE for writing:$!\n";
	foreach $k (keys %Config){
		print RC $k . " = " . $Config{$k} . "\n";
	}
	close RC;
}

sub get_imp {
	
    if ( -d ) {
        # for directories, only print path
      	# print "$File::Find::name\n";
        return;
    }

    -f            or return;  # if not a file
    /\.imp$/ or return;  # if not the right extension

    push @Imps,catfile($File::Find::dir, $_);
    @Imps or return;
}

sub get_book_info {
	my ($impfilename) = @_;
	my $start_address = 48;
	my $next_address = 0;
	my @info;
	my $s;

	open IMPFILE, "<$impfilename";
	my $old_rs = $/;
	$/="\0";
	$next_address = $start_address;
	for (my $i = 0; $i < 7; $i++){
		seek IMPFILE, $next_address, 0;
		$s = <IMPFILE>;
		chomp $s;
		push @info,$s;
		$next_address += length($s) + 1;
	}
	close IMPFILE;
	$/ = $old_rs;
	return @info;
}

sub FindBooks {
	my $dir = shift;
	my @keywords;
	my @info;
	my $field;
	my $keyword;
	my $book;
	my $tot;

	if ($reCurse){
		print "Searching through sub directories.\n";
		find( \&get_imp,$dir);
	}
	else {
		opendir DIR, $dir or die "Cant open $CurSearchPath for read: $!\n";
		while(my $name = readdir DIR)
		{
			next if $name eq '.' || $name eq '..';
			next if -d $name;
			push @Imps,catfile($dir,$name) if $name =~ /\.imp$/ ;
		}
		close DIR;
	}
}

# Clean up the loose ends
sub _End {
	_WriteRCFile;
	Tk::exit;
}

sub _Help {

	my $message_text = "The impfindGUI script works by itself without " .
					"relying on the impfind script.  The operation " .
					"is fairly straight forward.\n\n" .
					"Use the Browse button to select a directory or " .
					"you can type a directory into the field.  Then " .
					"click the Search button and impfindGUI will find ".
					"all of the imp files in the directory and display ".
					"Category, Title, Author and path information about ".
					"all of the books that were found.\n\n".
					"Ticking the Recursive check box will cause the ".
					"Search to move through all of the directories below ".
					"the selected directory.\n\n".
					"Ticking the Keyword Search check box will allow ".
					"you to enter a search term that will matched ".
					"against the information for each book and only ".
					"those that contain the term will be displayed.\n";

	if ($^O eq "MSWin32"){
		$mw->messageBox(-title 	=> "Help",
						-type 	=> 'ok', 
						-message => $message_text);
	}
	else {
		$mw->messageBox(-title 	=> "Help",
						-type 	=> 'ok', 
						-font	=> "ansi 10",
						-message => $message_text);

	}
}
