#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

# target script

import sys
import os
from cficonvert import CFIConvertException, cfi_convert

PY3 = sys.version_info[0] == 3

if PY3:
    import tkinter
    import tkinter.ttk as tkinter_ttk
    import tkinter.constants as tkinter_constants
    import tkinter.filedialog as tkinter_filedialog

_USER_HOME = os.path.expanduser("~")

def run(bk):
    epubversion = "2.0"
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()

    localRoot = tkinter.Tk()
    localRoot.withdraw()
 
    if sys.platform.startswith('darwin'):
        # localRoot is is an empty topmost root window that is hidden by withdrawing it
        # but localRoot needs to be centred, and lifted and focus_force used
        # so that its child dialog will inherit focus upon launch
        localRoot.overrideredirect(True)
        # center on screen but make size 0 to hide the empty localRoot
        w = localRoot.winfo_screenwidth()
        h = localRoot.winfo_screenheight()
        x = int(w/2)
        y = int(h/2)
        localRoot.geometry('%dx%d+%d+%d' % (0, 0, x, y))
        localRoot.deiconify()
        localRoot.lift()
        localRoot.focus_force()

    file_types = [('Text', ('.txt'))]
    file_opt = {}
    file_opt['parent'] = localRoot
    file_opt['title']= 'Select Text File eith epubcfis (one per line)'
    file_opt['defaultextension'] = ".txt"
    file_opt['initialdir'] = _USER_HOME
    file_opt['multiple'] = False
    file_opt['filetypes'] = file_types
    fpath = tkinter_filedialog.askopenfilename(**file_opt) 
    # localRoot.destroy()
    localRoot.quit()
    if not fpath:
        print("cfitest plugin cancelled by user")
        return 0
 
    data = ""
    with open(fpath, 'rb') as f:
        data = f.read()
        data = data.decode('utf-8')
        data = data.strip()

    cfis = data.split('\n')
    for cfi in cfis:
        cfi = cfi.strip()
        print("Testing: ", cfi)
        try: 
            res = cfi_convert(bk, cfi)
        except Exception as e:
            print(str(e))
            
        href, nline, ncol, foffset, time_offset, space_offset, text_offset = res
        print("Target href:", href, "line:", nline, "col:", ncol)
        print("File Offset (utf-8 encoded):", foffset)
        print("Additional CFI Offsets", time_offset, space_offset, text_offset)
        print("\n\n")

    return 0
 
def main():
    print("I reached main when I should not have\n")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())
