#!/usr/bin/env python2
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2018, Alex Shaw <alex.shaw.as@gmail.com>'
__docformat__ = 'restructuredtext en'
__my_version__ = "1.0.0"

from calibre.customize import InterfaceActionBase

class VirtualLibrarySwitcher(InterfaceActionBase):
    '''
    This is the base class that gives Calibre all it's important info.
    '''
    name                    = 'Virtual Library Switcher'
    description             = 'Quickly switch between virtual libraries'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'Alex Shaw'
    version                 = (1, 0, 1)
    minimum_calibre_version = (0, 7, 53)

    actual_plugin           = 'calibre_plugins.virtual_library_switcher.ui:VirtualLibrariesPlugin'

    gui_name                = 'Virtual Libraries'

    def initialize(self):
        pass
    
    def is_customizable(self):
        return False
