#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys

# return safe id
def safe_id(href):
    string_list = list(href)
    for letter in range(1, len(href)): 
        if not href[letter].isalnum() and href[letter] not in ['-', '_', '.']:
             string_list[letter] = '_'
    href = "".join(string_list)
    if not href[0].isalpha():
        href = 'x' + href 
    return href

def run(bk):
    resource_dir = os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'resources')
    prefs = bk.getPrefs()
    if 'resource_dir' in prefs and os.path.isdir(prefs['resource_dir']):
        resource_dir = prefs['resource_dir']
    else:
        prefs['resource_dir'] = resource_dir
        bk.savePrefs(prefs)
    
    # add files from resources folder
    if os.path.isdir(resource_dir):
        resource_files = os.listdir(resource_dir)
        for resource_file in resource_files:
            file_name = os.path.join(resource_dir, resource_file)
            with open(file_name, 'rb') as file:  
                data = file.read()
            basename =  os.path. basename (file_name)
            try:
                bk.addfile(safe_id(resource_file), resource_file, data)
                if resource_file.endswith('html'):
                    bk._w.spine.append((safe_id(resource_file), None, None))
                print(file_name, 'added.')
            except:
                print(file_name, 'skipped.')
                pass
                
        return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
