#!/usr/bin/env python2
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2018, Alex Shaw <alex.shaw.as@gmail.com>'
__docformat__ = 'restructuredtext en'

import weakref
try:
    from PyQt5.Qt import (QToolButton, QMenu, QAction)
except ImportError as e:
    from PyQt4.Qt import (QToolButton, QMenu, QAction)
from calibre.gui2.actions import InterfaceAction
from calibre import prints
from functools import partial

class VirtualLibrariesPlugin(InterfaceAction):

    name = 'Virtual Library Switcher'
    action_spec = ('Virtual Libraries', None, None, None)
    popup_type = QToolButton.InstantPopup
    action_type = 'current'

    def genesis(self):
        icon = get_icons('images/icon.png')
        
        self.menu = QMenu(self.gui)
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(icon)
        self.menu.aboutToShow.connect(self.about_to_show_menu)
        
    def about_to_show_menu(self):
        menu = self.menu
        menu.clear()
        
        libraries = self.gui.current_db.new_api.pref('virtual_libraries', {})
        
        if len(libraries) == 0:
            msg = QAction('No Virtual Libraries')
            menu.addAction(msg)
        else:
            for name, query in libraries.iteritems():
                lib = QAction(name, menu)
                lib.triggered.connect(partial(self.switch, name, query))
                menu.addAction(lib)
            
            clear = QAction('All Books', menu)
            clear.triggered.connect(partial(self.switch, name, ''))
            menu.addAction(clear)

    def switch(self, name, query):
        self.gui.search.setEditText(query)
        self.gui.search.do_search()
        