#!/bin/sh
# Change these if necessary
UTELNETD=/mnt/ext1/system/bin/utelnetd
PORT=10000
LOGIN=/mnt/ext1/system/bin/bash

# If you want a pop-up message with the IP address and port for utelnetd
# displayed at startup, then uncomment the following line, and install
# sh_ivtool.app at that location.
#SH_IVTOOL=/mnt/ext1/system/bin/sh_ivtool.app


# The rest should not require editing.

# Connect to the net first if necessary.
ifconfig eth0 1> /dev/null 2> /dev/null
if [ $? -ne 0 ]; then
  touch /tmp/utelnetd-connected-to-net
  /ebrmain/bin/netagent connect
fi

$UTELNETD -p $PORT -l $LOGIN -d

if [ -x "$SH_IVTOOL" ]; then
  IP=`ifconfig eth0 | grep "inet addr" | cut -d ':' -f 2 | cut -d ' ' -f 1`
  $SH_IVTOOL -s "utelnetd is listening at  ${IP}:${PORT}"
fi

