#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 


def populate(self):
        # pre-populate checkboxes and flags
        prefs = self.bk.getPrefs() 
        self.removeif.set(prefs['remove_italics'])
        self.removehf.set(prefs['remove_hyperlink_format'])
        self.deletehl.set(prefs['delete_hyperlinks'])        
        self.usetj.set(prefs['use_text_justify'])
        self.usefont.set(prefs['use_small_font'] )
        self.addnum.set(prefs['add_numbering'] )
        self.supnum.set(prefs['add_super_numbering'])
        self.supnumb.set(prefs['add_super_with_brackets'] ) 
        
        options.REMOVE_ITALICS = prefs['remove_italics']
        options.REMOVE_HYPERLINK_FORMAT = prefs['remove_hyperlink_format']
        options.DELETE_HYPERLINKS = prefs['delete_hyperlinks']
        options.USE_TEXT_JUSTIFY = prefs['use_text_justify']
        options.USE_SMALL_FONT = prefs['use_small_font']
        options.ADD_NUMBERING = prefs['add_numbering']
        options.ADD_SUPER_NUMBERING = prefs['add_super_numbering']
        options.ADD_SUPER_WITH_BRACKETS = prefs['add_super_with_brackets']        
        return(0)    

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserDialog(tk.Frame):

    def __init__(self, parent, bk):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        self.bk = bk
        centeredWindow(self.parent, 390, 370)
        parent.minsize(150, 150)
        parent.maxsize(600, 500)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = LabelFrame(self, text='Formatting Options', 
                        bg     = '#E0E0E0',  
                        font   = ('Helvetica', 10),                         
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        """
        self.InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#000000',                         
                        bg     = '#E0E0E0', 
                        anchor = E
                        )
        self.InfoLabel.grid(columnspan=2, sticky=E, row=0, padx=10)       
        """
        
        self.save = BooleanVar() 
        self.save.set(False)
        self.chkbSave = Checkbutton(self.labelf1, 
                        text     = '  Save Settings',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.save                     
                        )
        self.chkbSave.grid(column=1, sticky=E, row=0, pady=0, padx=40)      
        
        clearButton = Button(self.labelf1, 
                        text    = "Clear All", 
                        font    = ('Helvetica', 10),
                        bg      = '#F0F0F0', 
                        relief  = GROOVE, 
                        command = self.onClear
                        ).grid(row=1, sticky=W, column=1, pady=10, padx=60)           
        
        self.removeif = BooleanVar() 
        self.removeif.set(False)
        self.chkbRemoveIF = Checkbutton(self.labelf1, 
                        text     = '  Remove all italic formatting',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removeif,
                        command = self.onRemoveIF                         
                        )
        self.chkbRemoveIF.grid(column=1, sticky=W, row=2, padx=60)      
         
        self.removehf = BooleanVar() 
        self.removehf.set(False)
        self.chkbRemoveHF = Checkbutton(self.labelf1, 
                        text     = '  Remove all hyperlink formatting',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removehf,
                        command = self.onRemoveHF                         
                        )
        self.chkbRemoveHF.grid(column=1, sticky=W, row=3, padx=60)      

        self.deletehl = BooleanVar() 
        self.deletehl.set(False)
        self.chkbDeleteHL = Checkbutton(self.labelf1, 
                        text     = '  Delete all hyperlinks',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.deletehl,
                        command = self.onDeleteHL                    
                        )
        self.chkbDeleteHL.grid(column=1, sticky=W, row=4, padx=60)     
        
        self.usefont = BooleanVar() 
        self.usefont.set(False)
        self.chkbUseFont = Checkbutton(self.labelf1, 
                        text     = '  Use smaller font size for all entries.',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.usefont,
                        command = self.onUseFont                    
                        )
        self.chkbUseFont.grid(column=1, sticky=W, row=5, padx=60)      
        
        self.usetj = BooleanVar() 
        self.usetj.set(False)
        self.chkbUseTJ = Checkbutton(self.labelf1, 
                        text     = '  Add text justification for all entries',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.usetj,
                        command = self.onUseTJ                    
                        )
        self.chkbUseTJ.grid(column=1, sticky=W, row=6, padx=60)     

        self.addnum = BooleanVar() 
        self.addnum.set(False)
        self.chkbAddNum = Checkbutton(self.labelf1, 
                        text     = '  Add consecutive numbering',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.addnum,
                        command = self.onAddNum                    
                        )
        self.chkbAddNum.grid(column=1, sticky=W, row=7, padx=60)        

        self.supnum = BooleanVar() 
        self.supnum.set(False)
        self.chkbSupNum = Checkbutton(self.labelf1, 
                        text     = '  Add superscript numbering',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.supnum,
                        command = self.onSupNum                    
                        )
        self.chkbSupNum.grid(column=1, sticky=W, row=8, padx=60)           

        self.supnumb = BooleanVar() 
        self.supnumb.set(False)
        self.chkbSupNumB = Checkbutton(self.labelf1, 
                        text     = '  Add supercript numbering with brackets',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.supnumb,
                        command = self.onSupNumB                    
                        )
        self.chkbSupNumB.grid(column=1, sticky=W, row=9, padx=60)       
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', '10'), background='#E0E0E0', width=14, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=10, column=1, pady=20)     

        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font   = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=11, columnspan=2, sticky=W, padx=5) 
        
        # show new plugin version msg if available
        #if options.NEW_PLUGIN_VERSION: 
        #    centeredWindow(self.parent, 350, 400)   
        #    self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)
            
        populate(self)   
        self.grab_set()
              
        
    def onClear(self):
        self.removeif.set(False)
        self.removehf.set(False)
        self.deletehl.set(False)        
        self.usetj.set(False)
        self.usefont.set(False)
        self.addnum.set(False)
        self.supnum.set(False)
        self.supnumb.set(False)
        
        options.REMOVE_ITALICS = False
        options.REMOVE_HYPERLINK_FORMAT = False
        options.DELETE_HYPERLINKS = False
        options.USE_TEXT_JUSTIFY = False
        options.USE_SMALL_FONT = False
        options.ADD_NUMBERING = False
        optins.ADD_SUPER_NUMBERING = False
        options.ADD_SUPER_WITH_BRACKETS = False            
        return(0)
        
    def onRemoveIF(self):
        print('\n>>> In on Remove Italics...' + str(self.removeif.get()))
        
        if self.removeif.get() == True:
            options.REMOVE_ITALICS = True
        else:
            options.REMOVE_ITALICS = False
        
        print('>>> options.REMOVE_ITALICS = ' + str(options.REMOVE_ITALICS))               
        return(0)
        
    def onRemoveHF(self):
        print('\n>>> In on Remove hyperlink formatting...' + str(self.removehf.get()))
        
        if self.removehf.get() == True:
            options.REMOVE_HYPERLINK_FORMAT = True
            self.deletehl.set(False)
            self.options.DELETE_HYPERLINKS = False
        else: 
            options.REMOVE_HYPERLINK_FORMAT = False
        
        print('>>> options.REMOVE_HYPERLINK_FORMAT = ' + str(options.REMOVE_HYPERLINK_FORMAT))        
        return(0)
        
    def onDeleteHL(self):
        print('\n>>> In on Delete hyperlinks...' + str(self.deletehl.get()))
        
        if self.deletehl.get() == True:
            options.DELETE_HYPERLINKS = True
            self.removehf.set(False)
            options.REMOVE_HYPERLINK_FORMAT = False
        else:
            options.DELETE_HYPERLINKS = False
        
        print('>>> options.DELETE_HYPERLINKS = ' + str(options.DELETE_HYPERLINKS)) 

    def onUseTJ(self):
        print('\n>>> In on use text justify...' + str(self.usetj.get()))
        
        if self.usetj.get() == True:
            options.USE_TEXT_JUSTIFY = True
        else:
            options.USE_TEXT_JUSTIFY = False
        
        print('>>> options.REMOVE_HANGING_INDENT = ' + str(options.USE_TEXT_JUSTIFY))               
        return(0)           
        
    def onUseFont(self):
        print('\n>>> In on use text justify...' + str(self.usefont.get()))        
        if self.usefont.get() == True:
            options.USE_SMALL_FONT = True
        else:
            options.USE_SMALL_FONT = False
            
    def onAddNum(self):
        print('\n>>> In on add numbering...' + str(self.addnum.get()))        
        if self.addnum.get() == True:
            options.ADD_NUMBERING = True
            self.supnum.set(False)
            options.ADD_SUPER_NUMBERING = False
            self.supnumb.set(False)
            options.ADD_SUPER_WITH_BRACKETS = False
        else:
            options.ADD_NUMBERING = False    
            
    def onSupNum(self):
        print('\n>>> In on add numbering...' + str(self.supnum.get()))        
        if self.supnum.get() == True:
            options.ADD_SUPER_NUMBERING = True
            self.addnum.set(False)
            options.ADD_NUMBERING = False
            self.supnumb.set(False)
            options.ADD_SUPER_WITH_BRACKETS = False
        else:
            options.ADD_SUPER_NUMBERING = False       

    def onSupNumB(self):
        print('\n>>> In on add numbering...' + str(self.supnum.get()))        
        if self.supnumb.get() == True:
            options.ADD_SUPER_WITH_BRACKETS = True
            self.addnum.set(False)
            options.ADD_NUMBERING = False
            self.supnum.set(False)
            options.ADD_SUPER_NUMBERING = False
        else:
            options.ADD_SUPER_NUMBERING = False                       
                
    def onOK(self):
    
        # save all settings
        if self.save.get() == True:
            prefs = self.bk.getPrefs()
            prefs['remove_italics'] = self.removeif.get()
            prefs['remove_hyperlink_format'] = self.removehf.get()
            prefs['delete_hyperlinks'] = self.deletehl.get()
            prefs['use_text_justify'] = self.usetj.get()
            prefs['use_small_font'] = self.usefont.get()
            prefs['add_numbering'] = self.addnum.get()
            prefs['add_super_numbering'] = self.supnum.get()
            prefs['add_super_with_brackets'] = self.supnumb.get()     
            self.bk.savePrefs(prefs)      
        
        self.parent.destroy() 
        self.quit()
            
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()  
       
class CMOSStyleDialog(tk.Frame):
    def __init__(self, parent):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        centeredWindow(self.parent, 410, 200)
        parent.minsize(150, 150)
        parent.maxsize(600, 600)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()        
  
    def setup_UI(self):
 
        self.labelf1 = LabelFrame(self, text='CMOS Styling Options', 
                        bg     = '#E0E0E0', 
                        font   = ('Helvetica', 10),                             
                        #width  = 300, height=210, 
                        relief = RIDGE
                        )
        self.labelf1.pack(fill=BOTH, expand=1, ipady=27, pady=3, padx=3)
        
        InfoLabel2 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel2.grid(row=0, columnspan=2, sticky=E)     
		
        self.radioVar = IntVar()
        self.radioVar.set(1)
        self.radioAuthorDate = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
						text=" Create a new ref section in author-date format.",
                        font= ('Helvetica', 10), 
                        variable=self.radioVar, 
                        value=1
                        )
        self.radioAuthorDate.grid(column=1, sticky=W, row=1, padx=60, pady=2)
   
        self.radioFullNote = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
                        text=" Append fullnotes to the end of a chapter/ref section", 
                        font= ('Helvetica', 10),                         
                        variable=self.radioVar, 
                        value=2
                        )
        self.radioFullNote.grid(column=1, sticky=W, row=2, padx=60, pady=2)
        
        self.radioNote = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
                        text=" Append concise notes to the end of a chapter", 
                        font= ('Helvetica', 10),                         
                        variable=self.radioVar, 
                        value=3
                        )
        self.radioNote.grid(column=1, sticky=W, row=3, padx=60, pady=2)
        
        InfoLabel3 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel3.grid(row=3, columnspan=3, sticky=E)     

        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=12, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=4, column=1, sticky=W, padx=155, pady=20)
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=5, column=1, sticky=W, pady=0, padx=2) 
        
        # show new plugin version msg if available
        #if options.NEW_PLUGIN_VERSION: 
        #    centeredWindow(self.parent, 410, 230)   
        #    self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)
        
        self.grab_set()       
                     
    def onOK(self):
        if self.radioVar.get() == 1:
            options.AUTHOR_DATE_STYLE = True    			
        if self.radioVar.get() == 2:
            options.FULLNOTE_STYLE = True
        if self.radioVar.get() == 3:
            options.NOTE_STYLE = True
        self.parent.destroy()  
      
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()   
       
            