#!/bin/sh
LIMIT=`cat /sys/class/backlight/max77696-bl/max_brightness`
LIMIT=`expr 81 \* $LIMIT / 100`
if [ $# -eq 1 ] ; then
  LEVEL=$1
else
  ACTUAL=`cat /sys/class/backlight/max77696-bl/actual_brightness`
  LEVEL=`expr $1 \* $ACTUAL / $2`
fi
if [ $LEVEL -lt 0 ] ; then LEVEL=0 ; fi
if [ $LEVEL -gt $LIMIT ] ; then LEVEL=$LIMIT ; fi
echo $LEVEL > /sys/class/backlight/max77696-bl/brightness
if [ $# -gt 1 ] ; then
  YRES=`eips -i | grep yres: | awk '{print $4}'`
  NROWS=`expr $YRES / 24`
  ROW=`expr $NROWS - 4`
  eips 12 $ROW "Brightness: $LEVEL    "
fi
