#!/usr/bin/env python
 # -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function

try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup

import sys, os, os.path, re

from xml.sax.saxutils import escape


# get the line number
def getlinenumber(html, text):
    lines = html.splitlines()
    linums = []
    for index, line in enumerate(lines):
        if text in line:
            linums.append(index +1)
    return linums


# main routine
def run(bk):
    ErrorPack = []

    # get all files in the spine
    for (html_id, linear) in bk.getspine():
        mime = bk.id_to_mime(html_id)

        # process only html files
        if mime == 'application/xhtml+xml':
            filename = os.path.basename(bk.id_to_href(html_id))
            print('\nProcessing ' + filename + '...\n')
            html = bk.readfile(html_id)
            # load html code into BeautifulSoup
            soup = BeautifulSoup(html, 'html.parser')


            for paragraph in soup.find_all('p'):

                #Sample error
                error01 = u"- -"
                msg01 = "Hyphen space hyphen"

                scope = "([^<^>^/]{10})" + error01 + "([^<^>^/]{10})"

                searcher = re.search(scope, str(paragraph))

                if searcher:
                    if searcher.group(0) not in ErrorPack:
                        linenumbers = getlinenumber(html, searcher.group(0))
                        for linenumber in linenumbers:
                            #I need precise offset (third argument -- None now)
                            bk.add_extended_result("error",escape(filename), linenumber, None, 'Becky Error #01: ' + msg)

                        ErrorPack.append(searcher.group(0))

                if not ErrorPack:
                    bk.add_result(None, None, None, None)

        print('\nDone.\n\nPress OK to close window.')
    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
