#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}

if [ $( lsof | grep -c [[:space:]]/mnt/onboard/ ) -gt 0 ]; then
  $ksmroot/kbmessage.sh "/mnt/onboard/ is busy"
  exit
fi

if [ $( lsof | grep -c [[:space:]]/mnt/sd/ ) -gt 0 ]; then
  $ksmroot/kbmessage.sh "/mnt/sd/ is busy"
  exit
fi

versionfilename=/mnt/onboard/.kobo/version
#PRODUCT_ID is already exported by ksmhome.sh
PRODUCT_ID=${PRODUCT_ID:-"0x4163"}
VERSION=$(awk -F"," '{print $3}' $versionfilename)
SN=$(awk -F"," '{print $1}' $versionfilename)
VENDOR_ID=0x2237

# just in case one of the variables is empty
PRODUCT_ID=${PRODUCT_ID:-"0x4163"}
VERSION=${VERSION:-"0.0.0"}
SN=${SN:-"N000000000000"}

MODULE_LOADED=`lsmod | grep -c g_file_storage`

DEV="/dev/mmcblk1p1"
if [ -e /dev/mmcblk1p1 ]; then
  LUNS=/dev/mmcblk0p3,/dev/mmcblk1p1
else
  LUNS=/dev/mmcblk0p3
fi

PARAMS="vendor=$VENDOR_ID product=$PRODUCT_ID vendor_id=Kobo product_id=eReader-$VERSION SN=$SN"
sync
echo 3 > /proc/sys/vm/drop_caches
umount -l /mnt/onboard
umount -l /mnt/sd

/sbin/insmod /drivers/$PLATFORM/usb/gadget/arcotg_udc.ko
sleep 2

/sbin/insmod /drivers/$PLATFORM/usb/gadget/g_file_storage.ko file=$LUNS stall=1 removable=1 $PARAMS
sleep 1
