# v0.3 - Initial plugin idea by ashkulz; modifications by nrapallo (Sept 2008)
# Uses Mobi2IMP (dos command) to convert .prc to .imp (EBW1150) 'on the fly'...
# Must have Mobi2IMP 9.4 fully installed (to C: drive preferrably) or must edit .bat used.
# See thread http://www.mobileread.com/forums/showthread.php?t=22178 for how to install.
# TODO: use attachment filename for final .imp filename!

import impserve
import os, subprocess, shutil
from os.path import getsize

class PrcConverter1150(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #print headers       #debug statement

        #Content-Type used by Mobileread.com to deliver the .prc, if not return.
        if not 'application/octet-stream' in headers['Content-Type']:
            return headers, data

        #filename should end with .prc" (last quote part of string), if not return.
        m = headers['Content-Disposition']       
        print m
        if not m or (not m.lower().endswith('.prc"') and not m.lower().endswith('.mobi"') and not m.lower().endswith('.pdb"')):
             return headers, data
      
        open('input.prc', 'wb').write(data)

        #uses local copy of .bat file to call Mobi2IMP from install directory and passes up to 9 parameters.
        #Double quotes are a problem so .bat must be fixed to make them work; otherwise no spaces allowed!
        #Currently using 1 parameter below (not including the command).  
        if subprocess.call(['mobi2imp-cmd.bat', '--verbose --cover --out output input.prc']) or not os.path.isfile('output.imp'):
            return headers, data

        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize('output.imp'))
        data = open('output.imp', 'rb').read()
        # TODO: copy 'output.imp' to local 'shelf' directory and rename filename in m above
        
        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove('input.prc')
        shutil.rmtree('input', True)
        os.remove('output.imp')
        os.remove('output.opf')

        return headers, data
