# v0.1 - Initial plugin by nrapallo (Sept 2008)
# Uses PDFRead (dos command) to convert .pdf to .imp (EBW1150) 'on the fly'...
# Must have PDFRead 1.8 fully installed (to C: drive perferrably) or must edit .bat used.
# See thread http://www.mobileread.com/forums/showthread.php?t=21906 for how to install.
# TODO: use attachment filename as title; better choice for author and category defaults!

import impserve
import os, subprocess, shutil
from os.path import getsize

class PdfConverter1150portrait(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #print headers       #debug statement

        #Content-Type used by Mobileread.com to deliver the .prc, if not return.
        if not 'application/pdf' in headers['Content-Type']:
            return headers, data

        #filename should end with .pdf" (last quote part of string), if not return.
        m = headers['Content-Disposition']       
        print m
        if not m or not m.lower().endswith('.pdf"'):
            return headers, data
      
        open('input.pdf', 'wb').write(data)

        #uses local copy of .bat file to call PDFRead from install directory and passes up to 9 parameters.
        #Double quotes are a problem so are reversed for parameters 2, 4, 6; otherwise no spaces allowed!
        #Currently using 7 parameters below (not including the command).  
        if subprocess.call(['pdfread-cmd.bat', '-t', 'My PDF', '-a', 'Impserve PDFRead plugin', '-c', 'Converted PDF', '-p ebw1150 -i pdf -f imp1 -m portrait-full -o output input.pdf']) or not os.path.isfile('output.imp'):
            return headers, data

        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize('output.imp'))
        data = open('output.imp', 'rb').read()
        # TODO: copy 'output.imp' to 'shelf' directory and rename filename in m above
        
        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove('input.pdf')
        os.remove('output.imp')

        return headers, data
