#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserDialog(tk.Frame):
    def __init__(self, parent):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        centeredWindow(self.parent, 410, 285)
        parent.minsize(150, 150)
        parent.maxsize(500, 500)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()        
  
    def setup_UI(self):
 
        self.labelf1 = LabelFrame(self, text='User Options', 
                        bg     = '#E0E0E0', 
                        font   = ('Helvetica', 10),                             
                        width  = 300, height=210, 
                        relief = RIDGE
                        )
        self.labelf1.pack(fill=BOTH, expand=1, ipady=27, pady=3, padx=3)
        
        self.reset = BooleanVar()
        self.reset.set(False)
        chkbResetPrefs = Checkbutton(self.labelf1, 
                        text     = ' Default prefs reset',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.reset,
                        command = self.onResetPrefs               
                        )
        chkbResetPrefs.grid(column=1, row=1, pady=2, padx=205)       
        
        InfoLabel2 = Label(self.labelf1, 
                        text   = 'Choose your preferred styling for the Logical\n' + \
                                 'TOC headings in the toc.ncx:',    
                        font   = ('Helvetica', 10),
                        justify= LEFT,                        
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel2.grid(row=2, column=1, sticky=W, padx=40, pady=2)     
        
        self.radioVar = IntVar()
        self.radioVar.set(1)
        
        self.radioTitleCase = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
                        text=" Convert all headings to titlecase", 
                        font    = ('Helvetica', 10), 
                        variable=self.radioVar, 
                        value=1
                        )
        self.radioTitleCase.grid(column=1, sticky=W, row=3, padx=60, pady=2)
   
        self.radioUpperCase = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
                        text=" Convert all headings to uppercase",
                        font    = ('Helvetica', 10),                         
                        variable=self.radioVar, 
                        value=2
                        )
        self.radioUpperCase.grid(column=1, sticky=W, row=4, padx=60, pady=2)
        
        self.radioChapUpper = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
                        text=" Convert only chapter headings to uppercase",
                        font    = ('Helvetica', 10),                         
                        variable=self.radioVar, 
                        value=3
                        )
        self.radioChapUpper.grid(column=1, sticky=W, row=5, padx=60, pady=2)

        self.radioBookUpper = Radiobutton(self.labelf1, 
                        bg='#E0E0E0', 
                        text=" Convert user defined headings to uppercase",
                        font    = ('Helvetica', 10),                         
                        variable=self.radioVar, 
                        value=4
                        )
        self.radioBookUpper.grid(column=1, sticky=W, row=6, padx=60, pady=2)  
        
        InfoLabel3 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel3.grid(row=7, columnspan=2, sticky=E)     

        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=12, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=8, column=1, sticky=W, padx=155)
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=9, column=1, sticky=W, pady=20, padx=2) 
        
        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION: 
            centeredWindow(self.parent, 410, 310)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)
        
        self.grab_set()       
       
    def onResetPrefs(self):
        if self.reset.get() == True:
            options.RESET_PREFS = True
                     
    def onOK(self):
        
        if self.radioVar.get() == 1:
            options.CONVERT_TO_TITLECASE = True
            
        elif self.radioVar.get() == 2:
            options.CONVERT_TO_UPPERCASE = True
            
        elif self.radioVar.get() == 3:
            options.CONVERT_CHAPHEADS_TO_UPPERCASE = True

        elif self.radioVar.get() == 4:
            options.CONVERT_USER_DEF_HEADINGS_TO_UPPERCASE = True
        
        self.parent.destroy()  
      
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()   
        

        