#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, shutil
import options
import tkinter as tk
import tkinter.messagebox as mbox

try:
    from sigil_bs4 import BeautifulSoup, Comment, Tag
except:
    from bs4 import BeautifulSoup, Comment, Tag
    
    
__all__=["processAllTasks", "copyNCXFile2Dir", "writeNCXFile2Epub", "show_msgbox", "changeNCXHeadingCase", "cleanExit"]

def processAllTasks(bk, wdir):
    print('\n -- Processing automatic tasks...')
    
    # copy the epub toc.ncx to the work dir
    copyNCXFile2Dir(bk, wdir)
    
    # change the displayed heading case 
    changeNCXHeadingCase(bk, wdir)
    
    # write files back to the epub
    writeNCXFile2Epub(bk, wdir)
    
    return(0)    
    
def copyNCXFile2Dir(bk, wdir):    
    ncx_id = 'ncx'
    ncx_file = 'toc.ncx'
    
    file = os.path.join(wdir, ncx_file)
    print(' -- Write NCX file to work dir...' + file)
    with open(file, 'wt', encoding='utf-8') as outfp: 
        data = bk.readfile(ncx_id)
        outfp.writelines(data)           
    return(ncx_id)
    
def writeNCXFile2Epub(bk, wdir):
    ncx_id = 'ncx'
    file = os.path.join(wdir, 'toc.ncx')
    print(' -- Write NCX file to Epub...' + file)
    with open(file, 'rt', encoding='utf-8') as fp:
        data = fp.read()           
        bk.writefile(ncx_id, data)
    return(0)        

def show_msgbox(title, msg, msgtype='info'):
    """ Dialogs for general information, 
	    warnings and errors.
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))
            
def changeNCXHeadingCase(bk, wdir):
    prefs = bk.getPrefs()
    file = os.path.join(wdir, 'toc.ncx')
    output = os.path.join(wdir, 'ncx.ncx')
    outfp = open(output, 'wt', encoding='utf-8')
    html = open(file, 'rt', encoding='utf8').read()
    
    soup = BeautifulSoup(html, 'xml')
    
    # initially set toc.ncx heading default to titlecase
    for head in soup.find_all('text'):
        head.string = head.get_text().title()    
        head.string = convertApostrophe(head.string)
		
    # apply user options
    for index, heading in enumerate(soup.find_all('text')):
	    
        # do not restyle the <docTitle> text header
        if index == 0:
            continue
        
        # convert all toc.ncx headings to titlecase 
        if options.CONVERT_TO_TITLECASE == True:     
            heading.string = heading.get_text().title()    
            heading.string = convertApostrophe(heading.string)
			
        # convert all headings to uppercase    
        elif options.CONVERT_TO_UPPERCASE == True:  
            heading.string = heading.get_text().upper()    

        # convert chapter headings only to uppercase    
        elif options.CONVERT_CHAPHEADS_TO_UPPERCASE == True:        
                if 'chapter' in heading.get_text().lower():
                    heading.string = heading.get_text().upper()                   
  
        # convert user-defined headings to uppercase
        elif options.CONVERT_USER_DEF_HEADINGS_TO_UPPERCASE == True:        
            for user_heading in prefs['user_defined_search_list']:
                if user_heading in heading.get_text().lower():
                    heading.string = heading.get_text().upper()
					
        # reformat all titlecase headings properly
        if heading.string.istitle() and not heading.string.isupper():
            heading.string = convert2ProperTitlecase(bk, heading.string)	
            heading.string = convertApostrophe(heading.string)
			
    outfp.writelines(str(soup.prettify()))    
    outfp.close()    
    os.remove(file)
    os.rename(output, file)
    return(0)                         
    
def cleanExit(wdir):
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)    
    
def convert2ProperTitlecase(bk, heading):
    new_word = []
    heading = heading.lower()
    word_list = heading.split()
    for idx, word in enumerate(word_list):
        if idx != 0:
            prefs = bk.getPrefs()
            if word.lower() in prefs['titlecase_exclude_list']:
                new_word.append(word.lower())
            else:   
                new_word.append(word.title())
                continue	
        else:
            new_word.append(word.title())
			
    header = " ".join(new_word)
    return(header)	
    
def convertApostrophe(header):
    if "'S " in header or "'T " in header:
        header = header.replace("'S ", "'s ")
        header = header.replace("'T ", "'t ")
    return(header)		    
			
			