#!/bin/sh

####
# Uncomment one of the following depending on storage device
export MINUTES_PATH=/media/cf/newspapers/20minutes   # CF storage

day=`date +%d`
mon=`date +%m`
yea=`date +%Y`
i="20minutes"
url="http://20minutes.s3.amazonaws.com/$yea$mon$day"_"PAR.pdf"

wget -O /tmp/$i.pdf $url

if [ "$?" = "0" ]
then
	rm -rf $MINUTES_PATH/$i.pdf
	mkdir -p $MINUTES_PATH/$i.pdf
	echo "<?xml version=\"1.0\" encoding=\"utf-8\"?><package><metadata><dc-metadata><Title>20MINUTES</Title><Description>Description: `echo \`date\``</Description></dc-metadata><y-metadata><startpage>$i.pdf</startpage><image>icon.png</image><version>000</version></y-metadata></metadata></package>" > $MINUTES_PATH/$i.pdf/manifest.xml
	mv /tmp/$i.pdf $MINUTES_PATH/$i.pdf/$i.pdf
	cp /mnt/free/download/20minutes/icon.png $MINUTES_PATH/$i.pdf/icon.png
fi 


