#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}

ver=`cat $vlasovsoftbasedir/VERSION`
if [ -z "$ver" ] || [ "$ver" \< "2017.10.18" ]; then
  $ksmroot/kbmessage.sh "unsupported version of launcher"
  exit
fi

frontlightprg=$ksmroot/tools/frontlight
dontTamperwithFrontlight=${dontTamperwithFrontlight:-"true"}

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "product: $PRODUCT" >> $debug_logfile
fi

# frontligth off
[ "$dontTamperwithFrontlight" == "true" ] && [ "$PRODUCT" != "trilogy" ] && [ "$PRODUCT" != "pixie" ] &&
(
$frontlightprg "0"
[ "$KSMdebugmode" == "true" ] && echo "on start: frontlight level set to 0" >> $debug_logfile
)

# set variables
export ROOT="$vlasovsoftbasedir"
VLASOVSOFT_KSM=1
. $vlasovsoftbasedir/launcher.sh

#set frontlight for KSM
[ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ] && [ $PRODUCT != pika ] && (
$frontlightprg "$KSMfrontlightlevel"
[ "$KSMdebugmode" == "true" ] && echo "before exit: frontlight level set to $KSMfrontlightlevel" >> $debug_logfile
)

