package application;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

import csv.CSV;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		FXMLLoader loader = new FXMLLoader(Main.class.getResource("GUI.fxml"));
		Parent root = loader.load();
		stage.setTitle("CSV2XML");
		stage.setScene(new Scene(root));
		stage.show();
	}

	/*
	 * public static void main(String[] args) { Application.launch(Main.class,
	 * args); // start GUI return; }
	 */
	public static void main(String... args) throws Exception {
		System.out.println("Program Arguments:");
		for (String arg : args) {
			System.out.println("\t" + arg);
		}

		if (args.length < 3) {
			Application.launch(Main.class, args); // start GUI
			return;
		}

		Path output = Paths.get(args[0]);
		Path input = Paths.get(args[1]);
		String delim = args[2];
		List<String> lines = Files.readAllLines(input, StandardCharsets.UTF_8);
		Files.write(output, CSV.toXML(lines, delim).getBytes("UTF-8"), StandardOpenOption.CREATE);
		System.exit(0);
	}
}