<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0" exclude-result-prefixes="xs xdt err fn" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:err="http://www.w3.org/2005/xqt-errors">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="lines">
		<xsl:for-each select="line">
			<xsl:result-document method="xml" href="file_{_id}-metadata.opf">
				<package unique-identifier="uuid_id" version="2.0" xmlns="http://www.idpf.org/2007/opf">
					<metadata xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:opf="http://www.idpf.org/2007/opf">
						<dc:identifier opf:scheme="calibre" id="calibre_id">6094</dc:identifier>
						<dc:identifier opf:scheme="uuid" id="uuid_id">5b0caded-047f-48e0-9e5c-e259683874b2</dc:identifier>
						<dc:title>
							<xsl:apply-templates select="title"/>
						</dc:title>
						<dc:creator opf:file-as="{@author_details}" opf:role="aut">
							<xsl:apply-templates select="author_details"/>
						</dc:creator>
						<dc:subject>
							<xsl:apply-templates select="bookshelf"/>
						</dc:subject>
						<dc:description>
							<xsl:apply-templates select="description"/>
						</dc:description>
						<dc:publisher>
							<xsl:apply-templates select="publisher"/>
						</dc:publisher>
						<dc:contributor opf:file-as="calibre" opf:role="bkp">BookCatalogue</dc:contributor>
						<dc:language>
							<xsl:apply-templates select="language"/>
						</dc:language>
						<dc:date>
							<xsl:apply-templates select="date_published"/>T04:00:00+00:00</dc:date>
						<dc:type/>
						<dc:format>
							<xsl:apply-templates select="format"/>
						</dc:format>
						<dc:identifier opf:scheme="ISBN">
							<xsl:apply-templates select="isbn"/>
						</dc:identifier>
						<dc:source/>
						<dc:relation/>
						<dc:coverage/>
						<dc:rights/>
						<meta content="Unbekannt" name="calibre:title_sort"/>
						<meta content="{series_details}" name="calibre:series"/>
						<meta content="{last_update_date}" name="calibre:timestamp"/>
						<meta content="{title}" name="calibre:title_sort"/>

					</metadata>
					<guide>
						<reference href="{book_uuid}.jpg" title="Titelbild" type="cover"/>
					</guide>
				</package>
			</xsl:result-document>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="_id">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="title">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="isbn">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="publisher">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="author_details">
		<xsl:value-of select="." />
	</xsl:template>
	<xsl:template match="language">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="date_published">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="rating">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="bookshelf_id">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="bookshelf">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="read">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="series_details"/>
	<xsl:template match="pages"/>
	<xsl:template match="notes"/>
	<xsl:template match="list_price"/>
	<xsl:template match="anthology">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="location"/>
	<xsl:template match="read_start"/>
	<xsl:template match="read_end"/>
	<xsl:template match="format">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="signed">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="lloaned_to"/>
	<xsl:template match="anthology_titles"/>
	<xsl:template match="description">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="genre"/>
	<xsl:template match="date_added">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="last_update_date">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="book_uuid">
		<xsl:value-of select="."/>
	</xsl:template>
</xsl:stylesheet>
