/*
 * Decompiled with CFR 0.152.
 */
package application;

import csv.CSV;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main
extends Application {
    public void start(Stage stage) throws Exception {
        FXMLLoader loader = new FXMLLoader(Main.class.getResource("GUI.fxml"));
        Parent root = (Parent)loader.load();
        stage.setTitle("CSV2XML");
        stage.setScene(new Scene(root));
        stage.show();
    }

    public static void main(String ... args) throws Exception {
        System.out.println("Program Arguments:");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.out.println("\t" + arg);
            ++n2;
        }
        if (args.length < 3) {
            Application.launch(Main.class, (String[])args);
            return;
        }
        Path output = Paths.get(args[0], new String[0]);
        Path input = Paths.get(args[1], new String[0]);
        String delim = args[2];
        List<String> lines = Files.readAllLines(input, StandardCharsets.UTF_8);
        Files.write(output, CSV.toXML(lines, delim).getBytes("UTF-8"), StandardOpenOption.CREATE);
        System.exit(0);
    }
}

