/*
 * Decompiled with CFR 0.152.
 */
package application;

import csv.CSV;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;

public final class Controller {
    @FXML
    private TextField inputField;
    @FXML
    private TextField delimField;
    @FXML
    private TextField outputField;
    @FXML
    private Button inputButton;
    @FXML
    private Button outputButton;
    @FXML
    private Button exportButton;
    private Optional<File> fileOptional = Optional.empty();
    private Optional<File> directoryOptional = Optional.empty();

    public void input(ActionEvent actionEvent) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Importdatei ausw\u00e4hlen");
        chooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("CSV-Dateien", new String[]{"*.csv"}));
        this.fileOptional = Optional.ofNullable(chooser.showOpenDialog(this.inputButton.getScene().getWindow()));
        this.fileOptional.ifPresent(file -> {
            this.exportButton.setDisable(!this.directoryOptional.isPresent());
            this.inputField.setText(file.getAbsolutePath());
        });
    }

    public void output(ActionEvent actionEvent) {
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle("Ausgabepfad ausw\u00e4hlen");
        this.directoryOptional = Optional.ofNullable(chooser.showDialog(this.outputButton.getScene().getWindow()));
        this.directoryOptional.ifPresent(file -> {
            this.exportButton.setDisable(!this.fileOptional.isPresent());
            this.outputField.setText(file.getAbsolutePath());
        });
    }

    public void export(ActionEvent actionEvent) {
        String message;
        Path output = this.directoryOptional.get().toPath().resolve("output.xml");
        Path input = this.fileOptional.get().toPath();
        try {
            List<String> lines = Files.readAllLines(input, StandardCharsets.UTF_8);
            Files.write(output, CSV.toXML(lines, this.delimField.getText()).getBytes("UTF-8"), StandardOpenOption.CREATE);
            message = "Datei erfolgreich erstellt";
        }
        catch (Exception e) {
            message = "Datei konnte nicht erstellt werden: " + e.getMessage();
        }
        Stage dialog = new Stage();
        dialog.setTitle("Nachricht");
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.initOwner(this.exportButton.getScene().getWindow());
        Button button = new Button("OK");
        button.setOnAction(event -> dialog.close());
        VBox vbox = new VBox(50.0, new Node[]{new Text(message), button});
        vbox.setAlignment(Pos.CENTER);
        dialog.setScene(new Scene((Parent)vbox));
        dialog.showAndWait();
    }
}

