/*
 * Decompiled with CFR 0.152.
 */
package csv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class CSV {
    private static final char QUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char SEPARATOR = ',';

    public static String toXML(List<String> inputLines, String delim) {
        ArrayList<String> header = new ArrayList<String>(Arrays.asList(inputLines.get(0).split(delim)));
        String output = "<lines>" + inputLines.stream().skip(1L).map(line -> {
            ArrayList<String> cells = new ArrayList<String>(Arrays.asList(CSV.returnRow(line, true)));
            return "<line>" + IntStream.range(0, cells.size()).mapToObj(i -> "<" + (String)header.get(i) + ">" + (String)cells.get(i) + "</" + (String)header.get(i) + ">").collect(Collectors.joining()) + "</line>" + "\r\n";
        }).collect(Collectors.joining(System.lineSeparator())).replaceAll("&", "&amp;") + "</lines>";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + output + System.lineSeparator();
    }

    private static char unescape(char c) {
        switch (c) {
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
        }
        return c;
    }

    public static String[] returnRow(String row, boolean fullEscaping) {
        int pos = 0;
        boolean inQuote = false;
        boolean inEsc = false;
        row = row.replaceAll("<", "&lt;");
        char next = (row = row.replaceAll(">", "&gt;")).length() > 0 ? row.charAt(0) : (char)'\u0000';
        int endPos = row.length() - 1;
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder bld = new StringBuilder();
        while (next != '\u0000') {
            char c = next;
            char c2 = next = pos < endPos ? row.charAt(pos + 1) : (char)'\u0000';
            if (inEsc) {
                bld.append(CSV.unescape(c));
                inEsc = false;
            } else if (inQuote) {
                switch (c) {
                    case '\"': {
                        if (next == '\"') {
                            next = ++pos < endPos ? row.charAt(pos + 1) : (char)'\u0000';
                            bld.append(c);
                            break;
                        }
                        inQuote = false;
                        break;
                    }
                    case '\\': {
                        if (fullEscaping) {
                            inEsc = true;
                            break;
                        }
                        bld.append(c);
                        break;
                    }
                    default: {
                        bld.append(c);
                        break;
                    }
                }
            } else if (c != ' ' && c != '\t' || bld.length() != 0) {
                switch (c) {
                    case '\"': {
                        if (bld.length() > 0) {
                            throw new IllegalArgumentException();
                        }
                        inQuote = true;
                        break;
                    }
                    case '\\': {
                        if (fullEscaping) {
                            inEsc = true;
                            break;
                        }
                        bld.append(c);
                        break;
                    }
                    case ',': {
                        fields.add(bld.toString());
                        bld = new StringBuilder();
                        break;
                    }
                    default: {
                        bld.append(c);
                    }
                }
            }
            ++pos;
        }
        fields.add(bld.toString());
        String[] imported = new String[fields.size()];
        fields.toArray(imported);
        return imported;
    }
}

