#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#

import os, os.path, sys, codecs, shutil, inspect, time
from tempfile import mkdtemp                  
from cutils import *
from updater import updateCheck
from dialogs import UserOptions
import options
import tkinter as tk


SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3549010&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
options.PLUGIN_PATH = PLUGIN_PATH


def runUserDialog(bk):
    root = tk.Tk()
    root.title('StyleBender')
    root.resizable(width=True, height=True)
    if not sys.platform.startswith('darwin'):
        img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
        root.tk.call('wm','iconphoto', root._w, img)
    UserOptions(root).pack(fill=tk.BOTH, expand=True)
    root.mainloop()
    return(0)    
    
def run(bk):
    print('Python version: ', sys.version, '\n')
    print('Running StyleBender...\n') 
    
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()
    else:
        epubversion = BeautifulSoup(bk.get_opf(), 'lxml').find('package')['version']
    
    # check for correct epub version
    if epubversion == '3.0':
        msg = "Epub 3.0 ebooks are not supported. This plugin requires a valid epub 2.0 ebook as input. " + \
              "Please try again."        
        show_msgbox('Incompatible Epub Version', msg, msgtype="error")
        return(-1)
    
    # check for new plugin versions   
    latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
    if latest_version and latest_version != installed_version:
        options.NEW_PLUGIN_VERSION = True
        options.MSG_NEW_VERSION_AVAILABLE = ("A new version of this plugin is available from MR - v" + latest_version)     
    
    # create a work dir
    WDIR = mkdtemp()
    options.WDIR = WDIR
    
    s_fnames = []
    # copy the CSS, images and xhtml files to the work dir
    t_ids, t_fnames = copyTextFiles2Dir(bk, WDIR)           # copy epub text files
    s_ids, s_fnames = copyCSSFiles2Dir(bk, WDIR)            # copy epub css files
    
    # check the file type -- html or epub
    if len(t_fnames) == 1 and len(s_fnames) == 0:
        options.FILE_TYPE = 'HTML' 
        # check the a loaded html file is there
        if t_fnames[0] == 'Section0001.xhtml':
            fileNotLoadedError('File Not Loaded Warning', 'warning')
            options.SYS_EXIT = True
            return(0)
    else:          
        options.FILE_TYPE = 'EPUB'
    
    if len(t_fnames) == 1 and len(s_fnames) > 0:  
        options.FILE_TYPE = 'EPUB'    
    
    # check if the file has html <styles> section
    checkStyles(WDIR, t_fnames)  

    # show the Cleanup Options dialog    
    runUserDialog(bk)
    
    # if dialog 'Cancel' or exit 
    # is pressed then exit run()
    if options.SYS_EXIT == True:
       return(0)     
  
    # process both the automatic tasks and user selected tasks
    processAllTasks(bk, WDIR, s_ids, t_ids, t_fnames, s_fnames)
    
    # For Cancel or exit -- exit run()
    if options.SYS_EXIT == True:
       return(0)
   
    print('\n -- Completed SUCCESSFULLY...')
    # remove the temp work dir
    shutil.rmtree(WDIR, ignore_errors=True)
    
    return(0)                
       
def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())                          