#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserOptions(tk.Frame):

    def __init__(self, parent):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        centeredWindow(self.parent, 550, 370)
        parent.minsize(400, 50)
        parent.maxsize(700, 450)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
       
    def setup_UI(self):
    
        self.labelf1 = LabelFrame(self, text='User Options', 
                        bg     = '#E0E0E0', 
                        font  = ('Helvetica', 10),                        
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#000000',                         
                        bg     = '#E0E0E0', 
                        anchor = E
                        )
        InfoLabel.grid(columnspan=2, sticky=E, row=0,padx=10)         
        
        btnClearAll = Button(self.labelf1, 
                        text    = "Clear All",
                        bg      = '#EFEFEF',  
                        font  = ('Helvetica', 10), 
                        width   = 8, 
                        relief  = GROOVE,                          
                        command = self.onClearAll
                        ).grid(row=1, column=1,sticky=W, padx=37, pady=10)                    
        
        self.moveall = BooleanVar() 
        self.chkbMoveAll = Checkbutton(self.labelf1, 
                        text     = '  Move the html <style> section and inline styling to new epub stylesheets',
                        bg       = '#E0E0E0', 
                        font     = ('Helvetica', 10),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.moveall,
                        command = self.onMoveAll                         
                        )
        self.chkbMoveAll.grid(column=1, sticky=W, row=2, padx=40, pady=3)      
        
        self.move = BooleanVar() 
        self.chkbMove = Checkbutton(self.labelf1, 
                        text     = '  Move only the html <style> section to a new stylesheet',
                        bg       = '#E0E0E0', 
                        font     = ('Helvetica', 10),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.move,
                        command = self.onMove                          
                        )
        self.chkbMove.grid(column=1, sticky=W, row=3, padx=40, pady=3)        
        
        self.moveinline = BooleanVar()
        self.chkbMoveInline = Checkbutton(self.labelf1, 
                        text     = '  Move only the inline styling to a new stylesheet',
                        bg       = '#E0E0E0', 
                        font     = ('Helvetica', 10),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.moveinline,
                        command = self.onMoveInline                          
                        )
        self.chkbMoveInline.grid(column=1, sticky=W, row=4, padx=40, pady=3)       
        
        self.removestyles = BooleanVar()
        self.chkbRemoveStyles = Checkbutton(self.labelf1, 
                        text     = '  Remove all html styles(classes) from the html',
                        bg       = '#E0E0E0', 
                        font     = ('Helvetica', 10),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removestyles,
                        command = self.onRemoveStyles                          
                        )
        self.chkbRemoveStyles.grid(column=1, sticky=W, row=5, padx=40, pady=3)   

        self.removeinline = BooleanVar()
        self.chkbRemoveInline = Checkbutton(self.labelf1, 
                        text     = '  Remove all inline styling from the html',
                        bg       = '#E0E0E0', 
                        font     = ('Helvetica', 10),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removeinline,
                        command = self.onRemoveInline                          
                        )
        self.chkbRemoveInline.grid(column=1, sticky=W, row=6, padx=40, pady=3)             
        
        self.removeattrs = BooleanVar()
        self.chkbRemoveAttrs = Checkbutton(self.labelf1, 
                        text     = '  Remove all tag attributes from the html',
                        bg       = '#E0E0E0', 
                        font     = ('Helvetica', 10),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removeattrs,
                        command = self.onRemoveAttrs                         
                        )
        self.chkbRemoveAttrs.grid(column=1, sticky=W, row=7, padx=40, pady=3)      

        self.blank1 = Label(self.labelf1, text=" ",
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#000000',
                        anchor = W
                        )
        self.blank1.grid(row = 8, column=1, sticky=W, padx=5)                  

        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=14, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=9, column=1, pady=15)
                        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row = 10, columnspan=2, sticky=W, padx=5) 

        if options.FILE_TYPE == 'HTML':
            InfoLabel.config(text="Input File: HTML  ", font  = ('Helvetica', 10))
        else:
            InfoLabel.config(text="Input File: EPUB  ", font  = ('Helvetica', 10))
        
        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION:
            centeredWindow(self.parent, 550, 390)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)         
        
        
        # do not allow these options for epubs
        if options.FILE_TYPE == 'EPUB':
            self.chkbMoveAll.config(state=DISABLED)              
            self.chkbMoveInline.config(state=DISABLED) 
            self.chkbMove.config(state=DISABLED) 
        
        
        self.grab_set()
        
        
    def onClearAll(self):
        self.moveall.set(False)  
        self.move.set(False)
        self.moveinline.set(False)
        self.removestyles.set(False)    
        self.removeinline.set(False)
        self.removeattrs.set(False)

        options.MOVE_ALL_STYLES = False
        options.MOVE_HTML_STYLES = False
        options.MOVE_INLINE_STYLING = False
        options.REMOVE_HTML_STYLES = False
        options.REMOVE_INLINE_STYLING = False
        options.REMOVE_ALL_ATTRS = False        
        
    def onMoveAll(self):
        if self.moveall.get() == True:
            options.MOVE_ALL_STYLES = True
            self.move.set(False)
            self.moveinline.set(False)
            self.removeattrs.set(False)
            self.removestyles.set(False)
            options.REMOVE_ALL_ATTRS = False      
            options.MOVE_INLINE_STYLING = False
            options.MOVE_HTML_STYLES = False
        else:
            options.MOVE_ALL_STYLES = False            
        
    def onMove(self):
        if self.move.get() == True:
            options.MOVE_HTML_STYLES = True
            self.moveall.set(False)
            self.removeattrs.set(False)
            self.removestyles.set(False)
            options.MOVE_ALL_STYLES = False  
            options.REMOVE_ALL_ATTRS = False
            options.REMOVE_HTML_STYLES = False               
        else:     
            options.MOVE_HTML_STYLES = False  
  
    def onMoveInline (self):
        if self.moveinline.get() == True:
            options.MOVE_INLINE_STYLING = True
            self.moveall.set(False)
            options.MOVE_ALL_STYLES = False 
            self.removeattrs.set(False)
            options.REMOVE_ALL_ATTRS = False
            self.removeinline.set(False)
            options.REMOVE_INLINE_STYLING = False            
        else:     
            options.MOVE_INLINE_STYLING = False   
            
    def onRemoveStyles(self):
        if self.removestyles.get() == True:
            options.REMOVE_HTML_STYLES = True
            self.moveall.set(False)
            self.move.set(False)
            self.removeattrs.set(False)
            options.MOVE_ALL_STYLES = False              
            options.MOVE_HTML_STYLES = False 
            options.REMOVE_ALL_ATTRS = False                           
        else:     
            options.REMOVE_HTML_STYLING = False       
            
    def onRemoveInline(self):
        if self.removeinline.get() == True:
            options.REMOVE_INLINE_STYLING = True
            self.moveall.set(False)
            self.moveinline.set(False)
            self.removeattrs.set(False)
            options.MOVE_ALL_STYLES = False
            options.MOVE_INLINE_STYLING = False            
            options.REMOVE_ALL_ATTRS = False                           
        else:     
            options.REMOVE_INLINE_STYLING = False             
            
    def onRemoveAttrs(self):
        if self.removeattrs.get() == True:
            options.REMOVE_ALL_ATTRS = True
            self.moveall.set(False)
            self.moveinline.set(False)
            self.move.set(False)
            self.removestyles.set(False)
            self.removeinline.set(False)
            options.MOVE_ALL_STYLES = False
            options.MOVE_INLINE_STYLING = False
            options.MOVE_HTML_STYLES = False
            options.REMOVE_HTML_STYLES = False
            options.REMOVE_INLINE_STYLING = False
        else:    
            options.REMOVE_ALL_ATTRS = False                   

    def onOK(self):        
        self.parent.destroy() 
            
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()  
      
                
        