#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))          
                        

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    

class UserDialog(tk.Frame):

    def __init__(self, parent):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        centeredWindow(self.parent, 430, 150)
        parent.minsize(300, 50)
        parent.maxsize(500, 400)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = LabelFrame(self, text='User Options',
                        font     = ('Helvetica', 10),        
                        bg     = '#E0E0E0',                            
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, text=" ",    
                        justify = LEFT,                                             
                        bg     = '#E0E0E0', 
                        anchor = W
                        )
        InfoLabel.grid(column=1, sticky=W, row=0, padx=40)       
   
        lblQueries = Label(self.labelf1, 
                        text     = '  Select stylesheet for media queries: ',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblQueries.grid(column=1, sticky=W, row=1, pady=2, padx=30)  

        var1 = StringVar()
        var1.set(options.CSS_FNAMES[0]) # initial value

        #self.optionQueries = OptionMenu(self.labelf1, var1, *options.CSS_FNAMES)
        s = ttk.Style()
        s.configure("TOptionMenu", font=('Helvetica', 10))         
        self.optionQueries = ttk.OptionMenu(self.labelf1,  var1, *options.CSS_FNAMES)  
        self.optionQueries.grid(column=1, sticky=W, row=1, padx=255, pady=6)
        
        InfoLabel2 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel2.grid(row=2, columnspan=2, sticky=E)                
        
        """
        styler = ttk.Style()
        styler.configure('New.TButton', background='#E0E0E0', font=('Helvetica', 10), width=12, relief=FLAT)
        self.cancelButton = ttk.Button(self.labelf1, 
                        text    = "Cancel", 
                        style   = 'New.TButton', 
                        command = self.onCancel
                        ).grid(row=3, column=1, sticky=W, padx=310)
        
        self.okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=3, column=1, sticky=W, padx=210)       
        """
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=12, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=3, column=1, pady=15)
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=4, column=1, padx=5) 

        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION == True:
            centeredWindow(self.parent, 430, 315)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE) 
       
        self.optionQueries.focus_set()
        self.grab_set()       
        
   
    def onOK(self):
        print('\n >>> In onOK....\n')
        options.SET_CSS_FNAME = self.optionQueries.get()
        self.onCancel()
        
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()  
        
