#!/bin/sh

## (c) M.S.Zick, 2017
## License: MIT https://opensource.org/licenses/MIT

PATH="/mnt/us/esys/bin:/mnt/us/esys/sbin:$PATH"

userStore='/mnt/us'
images='/backups'
target="$userStore$images"

mkdir -p $target 1>/dev/null 2>&1
if [ $? -ne 0 ] ; then
    printf '\n%s\n' 'Make target directory failed.' 1>&2
    exit 1
fi

## $1 Image area file to look at.
getSize() {
    local hex4be
    hex4be=$(od -A none -j12 -N4 -tx1 $1)
    set $hex4be
    hex4be=$(printf '%d\n' '0x'$1$2$3$4)
    hex4be=$(($hex4be+64))              # uImage header
    echo $hex4be
    return 0
}

## Extract portions of the source
## blkSize skipCnt copyCnt source destination message
while read bs skip count src dst msg; do
    printf '\n' 1>&2
    printf '%s %s %s %s\n' $msg
    dd if=${src} of=${target}${dst} bs=${bs} skip=${skip} count=${count} 2>&1 | tail -n1 1>&2
done <<EoF
4096    0 8192 /dev/mmcblk0 /prefix.bin   Copying partitioned area prefix.
4096 3649 2048 /dev/mmcblk0 /diagkern.bin Copying diag kernel block.
4096   65 2048 /dev/mmcblk0 /mainkern.bin Copying main kernel block.
EoF

diagSize=$(getSize ${target}'/diagkern.bin')
mainSize=$(getSize ${target}'/mainkern.bin')

## Extract uImage from memory allocation block
## blkSize source destination message
while read bs src dst msg; do
    printf '\n' 1>&2
    printf '%s %s %s %s\n' $msg
    dd if=${target}${src} of=${target}${dst} bs=$bs count=1 2>&1 | tail -n1 1>&2
    mkimage -l ${target}${dst}
done <<EoF
${diagSize} /diagkern.bin /diag-uImage Extracting diagnostic uImage.
${mainSize} /mainkern.bin /main-uImage Extracting main uImage.
EoF

## Get the configuration file from whichever system is currently running.
if [ -f /proc/config.gz ] ; then
    MODE=$(rdev)
    set $MODE
    MODE=$1
    case "${MODE}" in
        /dev/mmcblk0p1)
            cp -a /proc/config.gz ${target}/main-config.gz 
        ;;
        /dev/mmcblk0p2)
            cp -a /proc/config.gz ${target}/diag-config.gz
        ;;
        *)
            printf '\n%s\n' "Mode main or diag not determined." 1>&2
        ;;
    esac
else
    printf '\n%s\n' "Kernel does not provide /proc/config.gz" 1>&2
fi

## Complete copies of the source
## blkSize source destination
while read bs src dst msg; do
    printf '\n' 1>&2
    printf '%s %s %s\n' $msg
    dd if=${src} of=${target}${dst} bs=$bs 2>&1 | tail -n1 1>&2
done <<EoF
4096 /dev/mmcblk0p1    /mainsys.bin  Copying main partition(2min).
4096 /dev/mmcblk0p2    /diagsys.bin  Copying diag partition.
4096 /dev/mmcblk0p3    /localsys.bin Copying local partition.
EoF

## Older firmware on older devices did not have the boot partitions.
if [ -b /dev/mmcblk0boot0 ] ; then
    ## blkSize source destination
    while read bs src dst msg; do
        printf '\n' 1>&2
        printf '%s %s %s\n' $msg
        dd if=${src} of=${target}${dst} bs=$bs 2>&1 | tail -n1 1>&2
    done <<EoF
4096 /dev/mmcblk0boot0 /boot0.bin    Copying boot0 partition.
4096 /dev/mmcblk0boot1 /boot1.bin    Copying boot1 partition.
EoF
fi

exit 0
