#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, shutil, inspect, re
import options
from PIL import Image
from decimal import *  
import tkinter as tk
import tkinter.messagebox as mbox

try:
    from sigil_bs4 import BeautifulSoup, Comment
except:
    from bs4 import BeautifulSoup, Comment    
    
    
    
___all__=["processAllTasks", "copyTextFiles2Dir", "copyCSSFiles2Dir", "copyImageFiles2Dir", "writeFiles2Epub", "writeFiles2CSS", "show_msgbox", "prettifyCSS", "convertAbs2RelCSSValues", "convertAbs2RelCSSValues_Old", "cleanExit", "prettifyCSS1", "prettifyCSS2", "convertMarginFormat", "convertPaddingFormat", "addMediaQueries2CSS", "formatImages",  "reformatSmallImages", "prettifyXHTMLFile"]


def processAllTasks(bk, wdir, t_ids, t_fnames, s_ids, s_fnames):
    print('\n -- Processing automatic tasks...')
    for fname in t_fnames:
        if 'cover.xhtml' in fname or 'TOC.xhtml' in fname:
            continue
        else:    
            fname = os.path.join(wdir, fname)
            reformatSmallImages(wdir, fname)
            
            if options.SYS_EXIT == True:
                return(0)
            
            prettifyXHTMLFile(wdir, fname)
        
    for file in s_fnames:
        if file == options.SET_CSS_FNAME:      
            file = os.path.join(wdir, file)
            prettifyCSS1(wdir, file)
            addMediaQueries2CSS(wdir, file)
            prettifyCSS2(wdir, file)          
         
    # write css files back to epub         
    writeFiles2Epub(bk, wdir, t_ids, t_fnames)
    writeFiles2CSS(bk, wdir, s_ids, s_fnames)        
    return(0)
    
def copyTextFiles2Dir(bk, wdir):
    t_ids = list()
    t_hrefs = list()
    t_fnames = list()
    
    for (id, href) in bk.text_iter():
        t_ids.append(id)
        t_hrefs.append(href)
        t_fnames.append(os.path.basename(href))
    
    # copy all xhtml files to the working dir    
    file = str()
    t_fnames_r = list()
    t_ids_r = list()
    i = 0      
    for id in t_ids:
        file = os.path.join(wdir, t_fnames[i])
        if 'cover.xhtml' in file or \
            'cover.html' in file or \
            'cover.htm' in file or \
            'TOC.xhtml' in file or \
            'contents.xhtml' in file or \
            'titlepage.xhtml' in file:
            i = i + 1
            continue    
        
        print(' -- Copy to work dir...' + t_fnames[i])
        with open(file, 'wt', encoding='utf-8') as outfp:
            data = bk.readfile(id)
            html = BeautifulSoup(data, 'html.parser')
            t_fnames_r.append(t_fnames[i])
            t_ids_r.append(id)
            outfp.writelines(str(html))
            i = i + 1
    
    return(t_ids_r, t_fnames_r)     
                
def copyCSSFiles2Dir(bk, wdir):
    s_ids = list()
    s_hrefs = list()
    s_fnames = list()
    for (i, h) in bk.css_iter():
        s_ids.append(i)
        s_hrefs.append(h)
        s_fnames.append(os.path.basename(h))
        
    j = 0    
    for sid in s_ids:
        file = os.path.join(wdir, s_fnames[j])
        print(' -- Write to work dir...' + file)
        with open(file, 'wt', encoding='utf-8') as outfp: 
            data = bk.readfile(sid)
            html = BeautifulSoup(data, 'html.parser')
            outfp.writelines(str(html))                
            j = j + 1     
            
    return(s_ids, s_fnames)

def copyImageFiles2Dir(bk, wdir):
    print(' ')
    i_ids = list()
    i_hrefs = list()
    i_fnames = list()
    
    for (i, h, m) in bk.image_iter():
        i_ids.append(i)
        i_hrefs.append(h)
        i_fnames.append(os.path.basename(h))
        
    j = 0    
    for iid in i_ids:
        file = os.path.join(wdir, i_fnames[j])
        print(' -- Copy images to work dir...' + file)
        with open(file, 'wb') as outfp: 
            data = bk.readfile(iid)
            outfp.write(data)                
            j = j + 1     
            
    return(i_ids, i_fnames) 
    
    
def writeFiles2Epub(bk, wdir, ids, fnames):

    print(' >>> In writeFiles2Epub()...' )       
    for file in fnames:    
       print(file)    

    count = len(fnames)
    if count == 0: 
        return(0)
    
    i = 0
    print(' ')  
    for file in fnames:
        print(' -- Write files to epub...' + fnames[i])
        file = os.path.join(wdir, file)
        with open(file, 'rt', encoding='utf-8') as fp:
            data = fp.read()           
            bk.writefile(ids[i], data)
            i = i + 1
                                

def writeFiles2CSS(bk, wdir, ids, s_fnames): 
    # no css files with imported html docs
    count = len(s_fnames)
    if count == 0: 
        return(0) 
        
    i = 0
    print(' ')  
    for file in s_fnames:
        if os.path.getsize(os.path.join(wdir, file)) < 5:
            continue        
        prettifyCSS2(wdir, file) 
        print(' -- Write to epub CSS...' + str(file))        
        with open(os.path.join(wdir, file), 'rt', encoding='utf-8') as fp:              # input file is epub 
            data = fp.read()           
            bk.writefile(ids[i], data)
            i = i + 1
                        
    return(0)                  
    
def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))
        
def prettifyCSS(wdir, css):
    output = os.path.join(wdir, 'link_rel.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as infp:      
        for line in infp:
            if re.match(r'^\s*$', line):
                continue 
            if line.strip() == '':
                continue   
            if line.strip() == ';':
                continue 
            if '{' in line:
                line = line.replace(' ', '')
                line = line.replace('{', '  {')                
            outfp.write(line.strip() + '\n')                
    
    outfp.close()
    os.remove(css)
    os.rename(output, css)
    return(0)  
 
def cleanExit(wdir):
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)
 
def prettifyCSS1(wdir, css):
    output = os.path.join(wdir, 'reformat1.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as infp:      
        for line in infp:
           
            if ':' in line and ': ' not in line and not line.strip().startswith('a:'):
                line = line.replace(':', ': ')         
           
           # format attribute from line to stacked format
            if '{' in line and ':' in line and '}' in line:
                line = line.replace('{', '  {\n')
                line = line.replace(';', ';\n')
                line = line.replace('}', '\n}\n')                
            outfp.write(line.strip() +'\n')
    
    outfp.close()
    os.remove(css)
    os.rename(output, css)    
    
    output = os.path.join(wdir, 'reformat2.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as infp:      
        for line in infp:
            if line.strip() == '':
                continue
        
           # ensure all style properties end in ';'
            if '{' not in line and '}' not in line and ',' not in line:
                if not line.strip().endswith(';'):
                    line = line + ';\n'                
            outfp.write(line.strip() + '\n')
    
    outfp.close()
    os.remove(css)
    os.rename(output, css)    
    return(0)
    
def prettifyCSS2(wdir, css):
    css = os.path.join(wdir, css)
    output = os.path.join(wdir, 'link_rel.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as infp:      
        for line in infp:
            if 'font-family:' not in line and '{' not in line:
                line = line.lower()    
        
            if re.match(r'^\s*$', line):
                continue 
            
            if line.strip() == '':
                continue   
            
            if line.strip() == ';':
                continue        
            
            if line.strip() == '':
                continue
        
            outfp.write(line)
    
    outfp.close()
    os.remove(css)
    os.rename(output, css)    
    return(0)
    
def addMediaQueries2CSS(wdir, css):    
    print('\n >>> Add media queries to stylesheet')
    
    output = os.path.join(wdir, 'link_rel.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as infp:      
        for line in infp:
            outfp.write(line)
        data = '@media amzn-mobi {\n'
        data += ' .kf8only {\n'
        data += '  display: none;\n' 
        data += '  }\n'
        data += ' .mobionly {\n'
        data += '  display: inline;\n' 
        data += '  }\n'     
        data += '}\n'       
     
        data += '@media not amzn-mobi {\n'
        data += ' .kf8only {\n'
        data += '  display: inline;\n' 
        data += '  }\n'
        data += ' .mobionly {\n'
        data += '  display: none;\n' 
        data += '  }\n'     
        data += '}\n'            
        outfp.write(data) 
    outfp.close()
    os.remove(css)
    os.rename(output, css)    
    return(0)
    
def formatImages(wdir, line):
    # get the image link
    original_line = line
    
    soup = BeautifulSoup(line, 'html.parser')
    tag = soup.find('img')    
    if tag.has_attr('src'):
        text = tag['src']      
    else:
        return(line)  
    
    #get the img file name from the img path    
    file_name = os.path.basename(text)
    file_path = os.path.join(wdir, file_name)
     
    # get the image dimensions
    width, height = getImageSize(file_path)
    perc_width = round(width/int(options.BASE_WIDTH_VALUE) * 100)       # calculates width as a percentage of screen width
    perc_height = round(height/1200 * 100)    # calculates height as a percentage of screen height
    
    if perc_width >= 100:
        perc_width = 100
        
    if perc_height >= 100:
        perc_height = 100
        
    file_name = os.path.split(file_name)[1]
    file_name = file_name.replace(' ', '_')
    
    # insert the height and width image values 
    soup = BeautifulSoup(line, 'html.parser')
    img = soup.img
    if img.has_attr('class'):
        del img['class']
    if not img.has_attr('style'):
        if img.has_attr('width'):
            del img['width']
        if img.has_attr('height'):
            del img['height']            
        img['style'] = 'width: ' + str(perc_width) + '%;height: auto;'
    else:
        img['style'] = 'width: ' + str(perc_width) + '%;height: auto;'        
    line = str(soup)
    
    # % image values for kf8 devices only
    liner = BeautifulSoup(line, 'html.parser')
    img1 = soup.img
    if img1.has_attr('class'):
        del img1['class']
        img1['class'] = 'kf8only'
    else:    
        img1['class'] = 'kf8only'
    l = str(soup)
    line2 = l + '\n'
    
 
    # pixel image values for mobi only
    soup = BeautifulSoup(original_line, 'html.parser')
    img2 = soup.img
    
    # remove all inline styling from the img tag
    if img2.has_attr('style'):
        del img2['style']
    
    # remove and add classes 
    if img2.has_attr('class'):
        del img2['class']
        img2['class'] = 'mobionly'
    else:
        img2['class'] = 'mobionly'
    
    #add 'px' to the value for mobi
    if img2.has_attr('width'):
        del img2['width'] 
        img2['width'] = str(width) + 'px'
    else: 
        img2['width'] = str(width) + 'px'   
    
    if img2.has_attr('height'):
        del img2['height']
        img2['height'] = str(height) + 'px'
    else:
        img2['height'] = str(height) + 'px'       
    
    line1 = str(soup)
    line = line1 + line2
    
    return(line)    
    
def reformatSmallImages(wdir, file):

    print(' -- Reformat smaller images')    
    # inserts and reformats all ebook images 
    outfile = wdir + os.sep + 'images.html'
    infp = open(file, 'rt', encoding=('utf-8'))
    outfp = open(outfile, 'wt', encoding=('utf-8'))
    for line in infp:
        if '<img' in line: 
            if 'mobionly' not in line and 'kf8only' not in line:
                line = formatImages(wdir, line)
                outfp.write(line)
            else:
                msg = "Media queries have been detected in your code. You already have the relevant media queries in this epub."
                show_msgbox('Warning', msg, msgtype="warning")
                options.SYS_EXIT = True
                return(0)                
        else:
            outfp.write(line) 
        
    outfp.close()                
    infp.close() 
    os.remove(file) 
    os.rename(outfile, file)
    return(0)                       
        
def prettifyXHTMLFile(wdir, file):

    # reformat and prettify the XHTML file
    outfile= os.path.join(wdir, 'final_one.css')
    infp = open(file, 'rt', encoding='utf-8')
    outfp = open(outfile, 'wt', encoding='utf-8') 
    
    for line in infp:
        if line.strip().startswith('<?xml') or \
            line.strip().startswith('<!DOCTYPE') or \
            line.strip().startswith('<html') or \
            line.strip().startswith('<head>') or \
            line.strip().startswith('<meta')or \
            line.strip().startswith('<title>') or \
            line.strip().startswith('<link') or \
            line.strip().startswith('</head>') or \
            line.strip().startswith('<body') or \
            line.strip().startswith('<body>'):
            line = line.strip()
            if not line:
                continue
            if line.startswith('<meta') or \
                line.startswith('<title>') or \
                line.startswith('<link'):
                line = '  ' + line      
            if line.startswith('<body'):
                line = '\n' + line
            if line.startswith('</body>'):
                outfp.write('\n' + line.rstrip() + '\n')
            else:
                outfp.write(line.rstrip() + '\n')    
        else:
            line = line.strip() 
            if not line or line == ';':
                continue
            if line.startswith('<p'):
                line = '  ' + line            
            outfp.write('\n' + line + '\n')    
            
    infp.close()
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)
    return(0)                 
             
def getImageSize(image):
    """ Uses PIL to get image dimensions 
    """
    image = image.replace('\n', '')
    im = Image.open(image)
    ht = im.size[1]        
    wd = im.size[0]        
    return(wd, ht)
                    
            