#!/bin/busybox sh

logthis=false

ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}
eventdatadir=${ksmroot}/pressdata
thisparent=$(dirname $(dirname $(readlink -f $0)))
logfile=${thisparent}/logfile.txt

urldecode() {
  local url_encoded="${1//+/ }"
  printf '%b' "${url_encoded//%/\\x}"
}

[ "$REQUEST_METHOD" == "POST" ] && read QUERY_STRING
[ "$logthis" == "true" ] || echo "$(date +%Y%m%d_%H%M%S)" >> ${logfile}
[ "$logthis" == "true" ] || echo "QUERY_STRING: $QUERY_STRING" >> ${logfile}
comtype=$(echo "${QUERY_STRING}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="com_type") {print $2}}')
comvalue=$(echo "${QUERY_STRING}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="com_value") {print $2}}')

[ "$logthis" == "true" ] || echo "comtype: $comtype" >> ${logfile}
[ "$logthis" == "true" ] || echo "comvalue: $comvalue" >> ${logfile}


getparams=$(echo "${HTTP_REFERER}" | awk 'BEGIN{RS="\?";} { if (NR==2) {print $0}}')

message="messages:"
case ${comtype} in
  touch)
    [ "$logthis" == "true" ] ||     echo "arrived in comptype: ${comtype}" >> ${logfile}
    if [ "x${comvalue}" != "x" ]; then
      if [ -e ${eventdatadir}/${comvalue} ]; then
        [ "$logthis" == "true" ] ||         echo "found ${eventdatadir}/${comvalue}" >> ${logfile}
        cat ${eventdatadir}/${comvalue} > /dev/input/event1
        message="${message}<br>cat ${eventdatadir}/${comvalue} > /dev/input/event1"
      else
        [ "$logthis" == "true" ] ||         echo "cannot find${eventdatadir}/${comvalue}" >> ${logfile}
        message="${message}<br>cannot find ${eventdatadir}/${comvalue}"
      fi
    else
      message="${message}<br>missing name of event file"
    fi
    ;;
  shell)
    [ "$logthis" == "true" ] ||     echo "arrived in comptype: ${comtype}" >> ${logfile}
    if [ "x${comvalue}" != "x" ]; then
      comvalue=$(urldecode "${comvalue}")
      [ "$logthis" == "true" ] ||       echo "comvalue: ${comvalue}" >> ${logfile}
      ${comvalue}
    fi
    ;;
esac

echo "Content-type: text/html"
echo ""
echo ""
echo "<html>"
echo "<body>"
echo "<p>"
echo "$QUERY_STRING"
echo "</br>"
echo "${message}"
echo "</br>"
echo "getparams: ${getparams}"
echo "</br>"
echo "</p>"
echo "</body>"
echo "</html>"

[ "$logthis" == "true" ] || echo "arrived at end of script" >> ${logfile}

exit 0
