#!/bin/sh

inpfile="/usr/local/Kobo/libnickel.so.1.0.0"
tmpfile="/tmp/libnickel.so"

codename=`/bin/kobo_config.sh 2>/dev/null`;
case $codename in
    pixie|trilogy|pika|kraken|phoenix|star)
        patchno="1";;  # Mini    | Touch (B/C) | Touch 2.0 | Glo | Aura | Aura Ed. 2
    dragon|dahlia|snow)
        patchno="2";;  # Aura HD | Aura H2O    | Aura H2O 2
    alyssum|daylight)
        patchno="3";;  # Glo HD  | Aura ONE
esac

cp $inpfile $tmpfile
/sbin/patch32lsb -p /root/keyboard$patchno.patch -i $tmpfile -o $tmpfile

reboot=0
md5_inpfile=`md5sum $inpfile | awk '{ print $1 }'`
md5_outfile=`md5sum $tmpfile | awk '{ print $1 }'`
if [ "$md5_inpfile" != "$md5_outfile" ]; then
    cp $inpfile $inpfile.sav
    cp $tmpfile $inpfile
    reboot=1
fi

rm $tmpfile

rm /etc/udev/rules.d/keyboard_patch.rules
rm /root/keyboard_patch.sh
rm /root/keyboard1.patch
rm /root/keyboard2.patch
rm /root/keyboard3.patch
rm /sbin/patch32lsb

if [ $reboot -eq 1 ]; then
    sync
    /sbin/reboot
fi
