#pragma once
#include <windows.h>

#include "RebList.h"

#define  REB_BLOCK_SZ                4096
#define  SUCCESS                     0
#define  FAILURE                     (-1)
#define  MAX_REB_PROP_CNT            4
#define  MAX_REB_PROP_LEN            64
#define  MAX_REB_LONG_FILENAME_LEN   128
#define  MAX_REB_FILETYPE_LEN        8

enum dirTokens {
	tokenShName = 0,
	tokenType,
	tokenAttr,
	tokenSz,
	tokenLgName,
	tokenMax
};

// The types of memory tree for each file and directory
#define  TRE_ROOT                    0
#define  TRE_INTMEM                  1
#define  TRE_SMARTMED                2
#define  REB_TREMAX                  3
#define  TRE_TITLES                  TRE_SMARTMED

// The file type (icon type) as displayed in the file list
typedef enum  rebFileE {
	rebDirFile = 0,
	rebRbFile,
	rebIniFile,
	rebHiddenFile,
	rebInfFile,
	rebRiFile,
	rebAnnoFile,
	rebXmlFile,
	rebDbFile,
	rebOtherFile,
	rebHtmlFile,
	rebMaxFile
} rebFileT;

typedef void PctDoneFnc(int pct);

/*
 REB IOCTL CODES
 */
#define IOCTL_RocketReadFile          0x222004 
#define IOCTL_RocketWriteFile         0x222008 
#define IOCTL_RocketWriteCodeSet      0x22200C 
#define IOCTL_RocketReadDebug         0x222010 
#define IOCTL_RocketReadSerialNumber  0x222014 
#define IOCTL_RocketReadInitiate      0x222018 
#define IOCTL_RocketReadContinue      0x22201C 
#define IOCTL_RocketWriteInitiate     0x222020 
#define IOCTL_RocketWriteContinue     0x222024 
#define IOCTL_RocketSendCommand       0x222028 
#define IOCTL_RocketWriteDebug        0x22202C 

class rebTitle;
class rebDirectory;
class rebFile;
class eBookComm;

class rebProperty
{
private:
	char  name[MAX_REB_PROP_LEN];
	char  value[MAX_REB_PROP_CNT][MAX_REB_PROP_LEN];
	int   valCnt;
	
	void setName (char * nm) {
		if (nm)
			strncpy (name,  nm,  sizeof (name));
		else
			name[0] = '\0';
	}

	void setValue (char * val, int cnt=0) {
		if (val)
			strncpy (value[cnt], val, MAX_REB_PROP_LEN);
		else
			value[cnt][0] = '\0';
	}
	

public:
	char * getName ()  { return name; }
	char * getValue (int cnt=0) { return value[cnt]; }
	int    getValCnt () { return valCnt; }

	rebProperty (char * nm, char * val);
	rebProperty (char * origDesr);

	friend class eBookComm;
};

class rebFile: private rebProperty
{
private:
	char fType[MAX_REB_FILETYPE_LEN];
	char longName[MAX_REB_LONG_FILENAME_LEN];
	int  size;
	rebFileT  type;
	rebTitle * titleP;
	rebDirectory * myDirP;
	eBookComm * ebcP;

public:
	rebFile (eBookComm * ebc, rebDirectory * dirP, 
		char * shortNm, char * fTp, char * longNm, int sz, char * attr);
	char *    getShName () { return rebProperty::getName (); }
	char *    getLnName () { return longName; }
	char *    getAttr   () { return rebProperty::getValue (); }
	char *    getExten  () { return fType; }
	int       getSz     () { return size; }
	rebFileT  getType   () { return type; }

	rebTitle * getTitle () { return titleP; }
	rebDirectory * getDir () { return myDirP; }
	bool isDirectory () { return (type == rebDirFile); }
	bool isHidden () { return (type == rebHiddenFile); }
	bool isEBook () { return (type == rebRbFile); }
	
	friend class rebDirectory;
	friend class eBookComm;
	// make the full path of the file
	char * makePath (char * buf);
	int readFile(char * szPcName, PctDoneFnc * fnc=NULL);
	int deleteTitle ();
};

class rebDirectory: public rebFile
{
private:
	int   memType;
	// clean all files and directories
	int removeAll(void);

public:
	List<rebFile *> * files;
#ifdef __AFX_H__
	HTREEITEM	      hTree;
#endif
	rebDirectory (eBookComm * ebc, rebDirectory * dirP,
		char * shortNm, char * longNm, char * attr, int memType);
	~rebDirectory ();
	
	int getMemType () { return memType; }
	int refresh ();
	friend class eBookComm;
};

class rebTitle {
private:
	rebFile * fileP; // the pointer to the corresponding rebFile

public:
	rebTitle (char * origDesr);

	char  title[MAX_REB_LONG_FILENAME_LEN];
	char  filename[MAX_REB_LONG_FILENAME_LEN];
	int   size;
	bool  anno;
	char  publisher[MAX_REB_LONG_FILENAME_LEN];
	char  author[MAX_REB_LONG_FILENAME_LEN];
	char  isbn[MAX_REB_PROP_LEN];
	char  url[MAX_REB_LONG_FILENAME_LEN];
	char  username[MAX_REB_PROP_LEN];

	rebFile * getFile () { return fileP; }

	friend class eBookComm;
};


class eBookComm
{
public:
	eBookComm(void);
	~eBookComm(void);
	int eBookOpen(void);
	int eBookClose(bool bForce=false);
	List<rebProperty *> * props;
	// List<rebFile *>     * files[REB_TREMAX];
	rebDirectory * roots[REB_TREMAX];
	List<rebTitle *>    * titles;

private:
	char eBookName[0x100];
	char internalBuffer[REB_BLOCK_SZ * 16];
	bool eBookConnected;
	HANDLE hDev;

public:
	int  iFiles[REB_TREMAX];
	int  iDirs[REB_TREMAX];
	int  freeIntMem;
	int  freeSMMem;
	int  totalIntMem;
	int  totalSMMem;
	char * batCap;
	bool smPresent;
	char * devId;
	bool resetF;
	int  titleCnt;
	char * osVer;
	char * userId;

public:
	char sernum[0x32];
	char eDate[0x32];
	char eTime[0x32];

	// Read the file into the local buffer. 
	// return bufSize and data in buffer...
	int eReadImmediate(char * szRebName, char * buffer, int * bufSize);
	int eReadFile(char * szRebName, char * szPcName, int sz=0, PctDoneFnc * fnc=NULL);
	int eWriteImmediate(char * szRebName, char * buffer, int bufSize);
	int eWriteFile(char * szRebName, char * szPcName, PctDoneFnc * fnc=NULL);
	int eWriteFileFromBuffer (char * buffer, int sendSize, int fnameSz, PctDoneFnc * fnc=NULL);
	
	// Get parameters from __STATUS special file
	int eBookGetParameters(void);
	int eBookGetDirTree(int memType, rebDirectory * dirP=NULL);
	int eBookGetTitles(void);
	static char *specFileName[REB_TREMAX];
private:
	void setDisconnState(void);
public:
	void checkKnownProps(rebProperty * prop, bool bStatFile);
	bool eBookCheck(void);
	bool getConnState () { return eBookConnected; }
	// Find the title entries corresponding to the eBook files
	int eBookFixTitles(int memType);
};

extern char * niceFormatInt (DWORD number);
