#pragma once

#include "SortHeaderCtrl.h"
#include "LCPrinting.h"

#ifdef _DEBUG
	#define ASSERT_VALID_STRING( str ) ASSERT( !IsBadStringPtr( str, 0xfffff ) )
#else	//	_DEBUG
	#define ASSERT_VALID_STRING( str ) ( (void)0 )
#endif	//	_DEBUG

// CFileListView view
#define MAX_TIP_LENGTH 80

class rebDirectory;
struct IDropTargetHelper;    // in case the newest PSDK isn't available.
DWORD WINAPI putFileToREB( LPVOID lpParam );

class CFileListView : public CListView
{
	DECLARE_DYNCREATE(CFileListView)

protected:
	CFileListView();           // protected constructor used by dynamic creation
	virtual ~CFileListView();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	DECLARE_MESSAGE_MAP()
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	CSortHeaderCtrl m_ctlHeader;
	CToolTipCtrl    m_ToolTip;
	static int CALLBACK CompareFunction( LPARAM lParam1, LPARAM lParam2, LPARAM lParamData );
	// Sort item by this column's order
	int rebItemSort(int iColumn, bool bAscending);
	int m_iSortColumn;
	bool m_bSortAscending;
	TCHAR  m_szNextFile [MAX_PATH];
	LCPrinting lcp;
	WCHAR *m_pwchTip;
	TCHAR *m_pchTip;

	// OLE Automation target and helper
	COleDropTarget     m_droptarget;

    IDropTargetHelper* m_piDropHelper;
    bool               m_bUseDnDHelper;
	DROPEFFECT         m_dwEffect;

public:
	virtual void OnInitialUpdate();

	// Attributes
public:
	CRebCommDoc* GetDocument() const;
	int clearFileList(void);
	int generateFileList(rebDirectory * dP);
	CImageList m_cil;
	// Set the proper number of columns in the view
	int setRebView(rebDirectory * dP);
	int dispType () { return currMemType; }
	rebDirectory * getDir () { return m_currDirP; }
	TCHAR * getNextFName () { return m_szNextFile; }
	bool AllowUpload ();

private:
	int currMemType;
	rebDirectory *m_currDirP;

public:
	afx_msg void OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult);

	friend class CRebCommDoc;
	// // Set the current file list
	void setFileList(rebDirectory * dP);
	void refreshFileList(void);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnReb1100fileDownloadtopc();
	static void showProgress(int currPct);
	afx_msg void OnUpdateReb1100fileDownloadtopc(CCmdUI *pCmdUI);
	afx_msg void OnFileUploadtoebook();
	afx_msg void OnUpdateFileUploadtoebook(CCmdUI *pCmdUI);
	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual void OnDragLeave();
	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual BOOL OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point);
	afx_msg void OnFileDeleteebook();
	afx_msg void OnUpdateFileDeleteebook(CCmdUI *pCmdUI);
	afx_msg void OnViewRefresh();
	afx_msg void OnUpdateViewRefresh(CCmdUI *pCmdUI);
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	BOOL OnToolTipText(UINT id, NMHDR* pNMHDR, LRESULT* pResult);
public:
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnUpdateFilePrint(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFilePrintPreview(CCmdUI *pCmdUI);
	afx_msg void OnFileProperties();
	afx_msg void OnUpdateFileProperties(CCmdUI *pCmdUI);
	virtual int OnToolHitTest(CPoint point, TOOLINFO* pTI) const;
	bool m_bToolTipCtrlCustomizeDone;
	afx_msg void OnViewShowtooltips();
	bool m_bShowTooltips;
	afx_msg void OnUpdateViewShowtooltips(CCmdUI *pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	void showProps(int itemNo);
	int itemHitTest(CPoint point);
	afx_msg void OnViewShowgridlines();
	afx_msg void OnUpdateViewShowgridlines(CCmdUI *pCmdUI);
//	afx_msg void OnClose();
//	afx_msg void OnDestroy();
//	virtual BOOL DestroyWindow();
	void saveSettings(bool shutDown=true);
};


#ifndef _DEBUG  // debug version in RebCommView.cpp
inline CRebCommDoc* CFileListView::GetDocument() const
   { return reinterpret_cast<CRebCommDoc*>(m_pDocument); }
#endif

