// RebStatusDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RebComm.h"
#include "RebStatusDlg.h"


// CRebStatusDlg dialog

IMPLEMENT_DYNAMIC(CRebStatusDlg, CPropertyPage)

CRebStatusDlg::CRebStatusDlg(CWnd* pParent /*=NULL*/)
	: CPropertyPage(CRebStatusDlg::IDD)
	, sSMPresent(_T(""))
	, sOSVersion(_T(""))
	, sUser(_T(""))
	, sSerNum(_T(""))
	, sDevID(_T(""))
	, sBatStat(_T(""))
	, sIMStat(_T(""))
	, sSMStat(_T(""))
	, ebcP (NULL)
{
}

CRebStatusDlg::~CRebStatusDlg()
{
}

void CRebStatusDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PROGRESS1, pcBatStatus);
	DDX_Control(pDX, IDC_PROGRESS2, pcIntMemStatus);
	DDX_Control(pDX, IDC_PROGRESS3, pcSmMedStatus);
	DDX_Text(pDX, IDC_EDIT14, sSMPresent);
	DDX_Text(pDX, IDC_EDIT13, sOSVersion);
	DDX_Text(pDX, IDC_EDIT2, sUser);
	DDX_Text(pDX, IDC_EDIT4, sSerNum);
	DDX_Text(pDX, IDC_EDIT5, sDevID);
	DDX_Control(pDX, IDC_SMMEDHDR, stSMHdr);
	DDX_Control(pDX, IDC_BATSTAT, csBatStat);
	DDX_Control(pDX, IDC_IMSTAT, csIMStat);
	DDX_Control(pDX, IDC_SMSTAT, csSMStat);
	DDX_Text(pDX, IDC_BATSTAT, sBatStat);
	DDX_Text(pDX, IDC_IMSTAT, sIMStat);
	DDX_Text(pDX, IDC_SMSTAT, sSMStat);
}

BOOL CRebStatusDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	if (ebcP == NULL)
		return TRUE;

	char szTemp[MAX_PATH];
	int  currLen;

	sBatStat = ebcP->batCap;
	pcBatStatus.SetRange32 (0, 100);
	pcBatStatus.SetPos (atoi (ebcP->batCap));

	pcIntMemStatus.SetRange32 (0, ebcP->totalIntMem);
	pcIntMemStatus.SetPos (ebcP->totalIntMem - ebcP->freeIntMem);

	currLen = sprintf (szTemp, "%s B / ", 
		niceFormatInt (ebcP->totalIntMem - ebcP->freeIntMem));
	currLen += sprintf (szTemp + currLen, "%s B",
		niceFormatInt (ebcP->totalIntMem));

	sIMStat = szTemp;

	if (ebcP->smPresent)
	{
		currLen = sprintf (szTemp, "%s B / ", 
			niceFormatInt (ebcP->totalSMMem - ebcP->freeSMMem));
		currLen += sprintf (szTemp + currLen, "%s B",
			niceFormatInt (ebcP->totalSMMem));

		pcSmMedStatus.SetRange32 (0, ebcP->totalSMMem);
		pcSmMedStatus.SetPos (ebcP->totalSMMem - ebcP->freeSMMem);
		sSMStat = szTemp;

		sSMPresent = "Present";
	}
	else
	{
		csSMStat.ShowWindow (SW_HIDE);
		pcSmMedStatus.ShowWindow (SW_HIDE);
		stSMHdr.ShowWindow (SW_HIDE);

		sSMPresent = "None";
	}

	if (ebcP->osVer)
		sOSVersion = ebcP->osVer;
	if (ebcP->devId)
		sSerNum    = ebcP->devId;  // This is actually the external ID
	if (ebcP->sernum)
		sDevID     = ebcP->sernum; // This is the hardware serial number
	if ((ebcP->userId) && (ebcP->userId[0] != '\0'))
		sUser      = ebcP->userId;
	else
		sUser      = "<None>";

	UpdateData (FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

BEGIN_MESSAGE_MAP(CRebStatusDlg, CPropertyPage)
END_MESSAGE_MAP()
