// RebOperDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RebComm.h"
#include "RebOperDlg.h"


// CRebOperDlg dialog

IMPLEMENT_DYNAMIC(CRebOperDlg, CPropertyPage)
CRebOperDlg::CRebOperDlg()
	: CPropertyPage(CRebOperDlg::IDD)
	, sDate(_T(""))
	, sTime(_T(""))
	, ebcP (NULL)
{
}

CRebOperDlg::~CRebOperDlg()
{
}

void CRebOperDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT1, sDate);
	DDX_Text(pDX, IDC_EDIT6, sTime);
}


BEGIN_MESSAGE_MAP(CRebOperDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_BUTTON1, OnBnClickedSynchTime)
	ON_BN_CLICKED(IDC_BUTTON2, OnBnClickedReset)
	ON_BN_CLICKED(IDC_BUTTON3, OnBnClickedFormatMem)
	ON_BN_CLICKED(IDC_BUTTON4, OnBnClickedFormatSMCard)
END_MESSAGE_MAP()


// CRebOperDlg message handlers

void CRebOperDlg::OnBnClickedSynchTime()
{
	char szScript[MAX_REB_LONG_FILENAME_LEN * 2];
	int  iLen;
	CTime currTime = CTime::GetCurrentTime();

	iLen = sprintf (szScript, "CMD!\nSETTIME %s\nSETDATE %s\n#/* Erase title */\n",
		currTime.Format ("%H %M %S"),
		currTime.Format ("%d %m %Y"));

	ebcP->eWriteImmediate ("__WHATYOUWANT", szScript, iLen);
	Sleep (300);
	ebcP->eBookGetParameters ();

	sDate = ebcP->eDate;
	sTime = ebcP->eTime;

	UpdateData (FALSE);
}

BOOL CRebOperDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	if (ebcP == NULL)
		return TRUE;

	sDate = ebcP->eDate;
	sTime = ebcP->eTime;

	UpdateData (FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CRebOperDlg::OnBnClickedReset()
{
	// TODO: Add your control notification handler code here
	char szScript[MAX_REB_LONG_FILENAME_LEN * 2];
	int  iLen;
	CWaitCursor waiting;

	iLen = sprintf (szScript, "CMD!\nRESET\n#/* Reset title */\n");

	ebcP->eWriteImmediate ("__WHATYOUWANT", szScript, iLen);
	Sleep (2000);
	this->GetParent ()->SendMessage (WM_CLOSE);
}

void CRebOperDlg::OnBnClickedFormatMem()
{
	// TODO: Add your control notification handler code here
	AfxMessageBox ("Not supported in this product", MB_OK|MB_ICONSTOP);
}

void CRebOperDlg::OnBnClickedFormatSMCard()
{
	// TODO: Add your control notification handler code here
	// AfxMessageBox ("Not supported in this product", MB_OK|MB_ICONSTOP);
	char szScript[MAX_REB_LONG_FILENAME_LEN * 2];
	int  iLen;
	CWaitCursor waiting;

	iLen = sprintf (szScript, "CMD!\nINITDIR %s 1\n#/* Format SM card */\n",
		ebcP->sernum);

	ebcP->eWriteImmediate ("__WHATYOUWANT", szScript, iLen);
	Sleep (2000);
	this->GetParent ()->SendMessage (WM_CLOSE);
}
