/***********************************************************************
 *
 * NAME:       RebList.h
 *
 * PURPOSE:    Reb Node and List Template Include File
 *
 * COPYRIGHT   Vlad
 *
 * CONTENTS:
 *        (P)  Node<Key>           - The Node class template
 *        (P)  List<Key>           - The List class template
 *
 *                (P)    - signifies public
 *
 * REVISION HISTORY:
 *
 *      Date   |  Rev  |  Author  |  Comments
 *---------------------------------------------------------------------
 *   03/06/97  |  001  |  VB      |  Added headers
 *   02/24/97  |  000  |  VB      |  Created
 ***********************************************************************/
#ifndef _REBLIST_H
#define _REBLIST_H

// This is an auxiliary class for the link list NODE. The link list will
// only link in one direction.

template<class Key> class Node
{
   private:
      Key key;
      Node<Key> * next;

   protected:
      Node () { next = NULL; };

   public:
      Node (Key k): key(k) { next = NULL; };

      Key    getKey  () { return key; };
      void   setKey  (Key k) { key = k; };
      Node<Key> * getNext () { return next; };
      void   setNext (Node<Key> * n) { next = n; };
};

// This template is to enable CTcpSocket and CTcpApi classes work as
// linked lists. This is a generic link list class with single linkage
// (forward only). Multiple occurences of the same key are not allowed.

template<class Key> class List : public Node<Key>
{
   private:
	   bool cleanKeys;

   public:
	   List (bool cK): cleanKeys (cK) {}
	   List (): cleanKeys (false) {}
	  ~List () { removeAll (); }

      Node<Key> * getTail ()               // Get the last element on list
         {
            Node<Key> * n = this;

            while (n->getNext ())
              n = n->getNext ();
            
            return n;
         };

      int insertTail (Key k)               // Append at the end of list
         {
            if (findKey (k))
               return (0);

            Node<Key> * nnode = new Node<Key> (k);
            if (nnode == NULL)
              return (-1);
            
            getTail ()->setNext (nnode);
            return (0);
         };

      int insertHead (Key k)               // Prepend at the beginning of list
         {
            if (findKey (k))
               return (0);

            Node<Key> * nnode = new Node<Key> (k);
            if (nnode == NULL)
              return (-1);
            
            nnode->setNext (getNext ());
            setNext (nnode);
            return (0);
         };

      Node<Key> * findKey (Key k)          // Find a key in the list
         {
            Node<Key> * curr = this;

            while (curr = curr->getNext ())
               if (curr->getKey () == k)
                  return (curr);

            return (NULL);
         };

      int removeKey (Key k)               // Remove a key from the list
         {
            Node<Key> * curr = this;
            Node<Key> * remove;

            while (remove = curr->getNext ())
            {
               if (remove->getKey () == k)
               {
                  curr->setNext (remove->getNext ());
                  delete remove;
                  return (0);
               }
               curr = remove;
            }

            return (-1);
         };

	  int removeAll ()               // Remove all members
         {
            Node<Key> * remove;

            while (remove = getNext ())
            {
			   if (cleanKeys)
				   delete remove->getKey ();

               setNext (remove->getNext ());
               delete remove;
            }

			return (0);
         };
};
#endif // _TCPUTIL_H
/* End of TcpUtil.h */
