// RebCommView.cpp : implementation of the CRebCommView class
//

#include "stdafx.h"
#include "RebComm.h"

#include "RebCommDoc.h"
#include "RebCommView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CRebCommView

IMPLEMENT_DYNCREATE(CRebCommView, CTreeView)

BEGIN_MESSAGE_MAP(CRebCommView, CTreeView)
	// Standard printing commands
	// ON_COMMAND(ID_FILE_PRINT, CTreeView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CTreeView::OnFilePrint)
	// ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTreeView::OnFilePrintPreview)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnTvnSelchanged)
	ON_UPDATE_COMMAND_UI(ID_FILE_UPLOADTOEBOOK, OnUpdateFileUploadtoebook)
	ON_COMMAND(ID_FILE_UPLOADTOEBOOK, OnFileUploadtoebook)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_UPDATE_COMMAND_UI(ID_VIEW_REFRESH, OnUpdateViewRefresh)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_PREVIEW, OnUpdateFilePrintPreview)
	ON_COMMAND(ID_VIEW_SHOWTOOLTIPS, OnViewShowtooltips)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWTOOLTIPS, OnUpdateViewShowtooltips)
	ON_COMMAND(ID_VIEW_SHOWGRIDLINES, OnViewShowgridlines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWGRIDLINES, OnUpdateViewShowgridlines)
END_MESSAGE_MAP()

// CRebCommView construction/destruction

CRebCommView::CRebCommView()
{
	// TODO: add construction code here

}

CRebCommView::~CRebCommView()
{
}

BOOL CRebCommView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	cs.style |= TVS_HASLINES | TVS_HASBUTTONS | TVS_LINESATROOT ;

	return CTreeView::PreCreateWindow(cs);
}

// CRebCommView drawing

void CRebCommView::OnDraw(CDC* /*pDC*/)
{
	CRebCommDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}


// CRebCommView printing

BOOL CRebCommView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CRebCommView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CRebCommView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


// CRebCommView diagnostics

#ifdef _DEBUG
void CRebCommView::AssertValid() const
{
	CTreeView::AssertValid();
}

void CRebCommView::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}

CRebCommDoc* CRebCommView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CRebCommDoc)));
	return (CRebCommDoc*)m_pDocument;
}
#endif //_DEBUG


// CRebCommView message handlers

void CRebCommView::OnInitialUpdate()
{
	CTreeView::OnInitialUpdate();

	// TODO: Add your specialized code here and/or call the base class
	CBitmap treBmap;
	CTreeCtrl& TheTree = GetTreeCtrl();
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	treBmap.LoadBitmap (IDB_TREE);

	m_TreeImg.Create(16, 16, ILC_COLOR8, 0, 4);
	m_TreeImg.Add (&treBmap, RGB (0, 0, 0));


	pDoc->setTreeView (this);
	
	TheTree.SetImageList(&m_TreeImg, TVSIL_NORMAL);

	pDoc->checkEBook (true, true);

}

void CRebCommView::OnTvnSelchanged(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);

	// TODO: Add your control notification handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	
	pDoc->updateFileList (pNMTreeView->itemNew.lParam);

	*pResult = 0;
}

int CRebCommView::loadDirTree(bool setSelF, int memType)
{
	CTreeCtrl& TheTree = GetTreeCtrl();
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	Node<rebFile *> * nP;
	rebDirectory * dP;
	int iTree;

	TheTree.DeleteAllItems ();

	TV_INSERTSTRUCT	itemNew;

	itemNew.hParent = NULL;
	itemNew.hInsertAfter = TVI_ROOT;
	itemNew.item.iImage = rebFileEBook;
	itemNew.item.iSelectedImage = rebFileEBook;
	itemNew.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_STATE | TVIF_PARAM;
	itemNew.item.state = TVIS_EXPANDED | TVIS_BOLD;
	itemNew.item.stateMask = itemNew.item.state;
	itemNew.item.pszText = pDoc->dirEntries[TRE_ROOT].itemName;
	itemNew.item.lParam = TRE_ROOT;

	m_hPrevParent[TRE_ROOT] = TheTree.InsertItem(&itemNew);

	// We got the main trunk, now let's attach the branches

	itemNew.hInsertAfter = TVI_LAST;
	itemNew.item.iImage = rebFileClosedFolder;
	itemNew.item.iSelectedImage = rebFileOpenFolder;
	itemNew.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;

	for (iTree=TRE_INTMEM; iTree < REB_TREMAX; iTree++)
	{
		dP = pDoc->ebc.roots[iTree];

		itemNew.hParent = m_hPrevParent[TRE_ROOT];
		itemNew.item.lParam = (LPARAM) dP;
		itemNew.item.pszText = pDoc->dirEntries[iTree].itemName;

		dP->hTree = TheTree.InsertItem(&itemNew);
		m_hPrevParent[iTree] = dP->hTree;

		if (!pDoc->bTitles)
		{
			nP = dP->files;
			while (nP = nP->getNext ())
			{
				if (nP->getKey()->isDirectory())
				{
					dP = (rebDirectory *) nP->getKey();
					itemNew.hParent = dP->getDir()->hTree;
					itemNew.item.lParam = (LPARAM) dP;
					itemNew.item.pszText = dP->getLnName();

					dP->hTree = TheTree.InsertItem(&itemNew);
				}
			}
		}
	}

	if (setSelF)
	{
		if (memType == TRE_ROOT)
		{
			TheTree.SelectItem (m_hPrevParent[memType]);
			pDoc->updateFileList (NULL);
		}
		else
		{
			dP = pDoc->ebc.roots[memType];
			TheTree.SelectItem (dP->hTree);
			TheTree.Expand (dP->hTree, TVE_EXPAND);
			pDoc->updateFileList ((LPARAM) dP);
		}
	}

	return 0;
}

void CRebCommView::OnUpdateFileUploadtoebook(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	
	if (pDoc->getListView())
		pDoc->getListView()->OnUpdateFileUploadtoebook (pCmdUI);
}

void CRebCommView::OnFileUploadtoebook()
{
	// TODO: Add your command handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	
	if (pDoc->getListView())
		pDoc->getListView()->OnFileUploadtoebook ();
}

void CRebCommView::OnViewRefresh()
{
	// TODO: Add your command handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnViewRefresh ();
}

void CRebCommView::OnUpdateViewRefresh(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnUpdateViewRefresh (pCmdUI);
	else
		pCmdUI->Enable (FALSE);
}

void CRebCommView::OnFilePrint()
{
	// TODO: Add your command handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnFilePrint ();
}

void CRebCommView::OnUpdateFilePrint(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnUpdateFilePrint (pCmdUI);
	else
		pCmdUI->Enable (FALSE);
}

void CRebCommView::OnFilePrintPreview()
{
	// TODO: Add your command handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnFilePrintPreview ();
}

void CRebCommView::OnUpdateFilePrintPreview(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnUpdateFilePrintPreview (pCmdUI);
	else
		pCmdUI->Enable (FALSE);
}

void CRebCommView::OnViewShowtooltips()
{
	// TODO: Add your command handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnFilePrintPreview ();
}

void CRebCommView::OnUpdateViewShowtooltips(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnUpdateViewShowtooltips (pCmdUI);
	else
		pCmdUI->Enable (FALSE);
}

void CRebCommView::OnViewShowgridlines()
{
	// TODO: Add your command handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnViewShowgridlines ();
}

void CRebCommView::OnUpdateViewShowgridlines(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if (pDoc->getListView ())
		pDoc->getListView ()->OnUpdateViewShowgridlines (pCmdUI);
	else
		pCmdUI->Enable (FALSE);
}

// force the directory to be selected
void CRebCommView::forceSelection(rebDirectory * dP)
{
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	CTreeCtrl& TheTree = GetTreeCtrl();

	TheTree.SelectItem (dP->hTree);
	TheTree.Expand (dP->hTree, TVE_EXPAND);
	pDoc->updateFileList ((LPARAM) dP);
}
