// RebCommDoc.h : interface of the CRebCommDoc class
//
#pragma once

#include "eBookComm.h"
#include "RebCommView.h"
#include "FileListView.h"

#define REB_MAX_FNAME_SZ   64
#define KUKUSTR            64

// The file type (icon type) as displayed in the file list
enum rebFileTypes {
	rebFileClosedFolder = 0,
	rebFileOpenFolder,
	rebFileEBook,
	rebFileRbFile,
	rebFileIniFile,
	rebFileHiddenFile,
	rebFileSmartMedia
};

#define REB_DIRMAX      40


typedef struct rebFileEntry {
	char fileName[REB_MAX_FNAME_SZ];
	char itemName[REB_MAX_FNAME_SZ];
	int  memType;
	int  iIcon;
}  rebFileEntryT;

class CRebCommDoc : public CDocument
{
protected: // create from serialization only
	CRebCommDoc();
	DECLARE_DYNCREATE(CRebCommDoc)

// Attributes
public:
	int            numDirs;
	rebFileEntryT  dirEntries[REB_DIRMAX];
	static eBookComm      ebc;
    
// Operations
public:
	void setListView (CFileListView * pView)
	{ m_pListView = pView; };
	CFileListView * getListView (void)
	{ return m_pListView; };
	void setTreeView (CRebCommView * pView)
	{ m_pTreeView = pView; };
	CRebCommView * getTreeView (void)
	{ return m_pTreeView; };

// Overrides
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CRebCommDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CRebCommView * m_pTreeView;
	CFileListView * m_pListView;

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	int updateFileList(LPARAM dirIx);
	int refreshFileStruct(int memType);
	bool eBookUpF;
	// check the eBook connection
	bool checkEBook(bool fullRefrF, bool propRefrF);
//	afx_msg void OnReb1100fileDownloadtopc();
//	afx_msg void OnUpdateFileUploadtoebook(CCmdUI *pCmdUI);
	afx_msg void OnViewRefreshall();
	afx_msg void OnViewTitlelist();
	afx_msg void OnUpdateViewTitlelist(CCmdUI *pCmdUI);
	// // Are we looking at titles?
	bool bTitles;
	afx_msg void OnOptionsSetupreb1100();
	afx_msg void OnUpdateOptionsSetupreb1100(CCmdUI *pCmdUI);
	void completeInit(void);
	bool bPollStopped;
};


