// MainFrm.h : interface of the CMainFrame class
//

#pragma once
#include "XStatusBar.h"
#include "RebCommDoc.h"

enum StatusBarPanes {
	paneFreeMem = 0,
	paneBattery,
	paneSmartMed,
	paneConnect,
	paneDevId
};

class CTextToolBar: public CToolBar
{
public:
	BOOL LoadToolBar(UINT nIDResource);
	BOOL ChangeButtonTxt(UINT id, LPCTSTR szText);
};

class CMainFrame : public CFrameWnd
{
	
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
protected:
	CSplitterWnd m_wndSplitter;
public:

// Operations
public:
	XStatusBar * stBar () { return &m_wndStatusBar; }
	CTextToolBar  * toolBar () { return &m_wndToolBar; }
	CFileListView * m_pListView;

// Overrides
public:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	XStatusBar      m_wndStatusBar;
	CTextToolBar    m_wndToolBar;
	CReBar          m_wndReBar;
	// CDialogBar      m_wndDlgBar;

// Generated message map functions
protected:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	DECLARE_MESSAGE_MAP()

public:
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnClose();
	afx_msg void OnHelpRebcommhelp();
};


