// RebCommView.h : interface of the CRebCommView class
//
class CRebCommDoc;

#pragma once
#include <afxcview.h>

class CRebCommView : public CTreeView
{
protected: // create from serialization only
	CRebCommView();
	DECLARE_DYNCREATE(CRebCommView)

// Attributes
public:
	CRebCommDoc* GetDocument() const;
	CImageList m_TreeImg;
	HTREEITEM	 m_hPrevParent[10];

// Operations
public:

// Overrides
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

// Implementation
public:
	virtual ~CRebCommView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
	afx_msg void OnTvnSelchanged(NMHDR *pNMHDR, LRESULT *pResult);
	int loadDirTree(bool setSelF, int memType=TRE_ROOT);
	afx_msg void OnUpdateFileUploadtoebook(CCmdUI *pCmdUI);
	afx_msg void OnFileUploadtoebook();
	afx_msg void OnViewRefresh();
	afx_msg void OnUpdateViewRefresh(CCmdUI *pCmdUI);
	afx_msg void OnFilePrint();
	afx_msg void OnUpdateFilePrint(CCmdUI *pCmdUI);
	afx_msg void OnFilePrintPreview();
	afx_msg void OnUpdateFilePrintPreview(CCmdUI *pCmdUI);
	afx_msg void OnViewShowtooltips();
	afx_msg void OnUpdateViewShowtooltips(CCmdUI *pCmdUI);
	afx_msg void OnViewShowgridlines();
	afx_msg void OnUpdateViewShowgridlines(CCmdUI *pCmdUI);
	// force the directory to be selected
	void forceSelection(rebDirectory * dP);
};

#ifndef _DEBUG  // debug version in RebCommView.cpp
inline CRebCommDoc* CRebCommView::GetDocument() const
   { return reinterpret_cast<CRebCommDoc*>(m_pDocument); }
#endif

