// RebCommDoc.cpp : implementation of the CRebCommDoc class
//

#include "stdafx.h"
#include "RebComm.h"
#include "MainFrm.h"
#include "RebCommDoc.h"
#include "RebStatusDlg.h"
#include "RebOperDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

eBookComm      CRebCommDoc::ebc;

// CRebCommDoc

IMPLEMENT_DYNCREATE(CRebCommDoc, CDocument)

BEGIN_MESSAGE_MAP(CRebCommDoc, CDocument)
//	ON_COMMAND(ID_REB1100FILE_DOWNLOADTOPC, OnReb1100fileDownloadtopc)
//ON_UPDATE_COMMAND_UI(ID_FILE_UPLOADTOEBOOK, OnUpdateFileUploadtoebook)
ON_COMMAND(ID_VIEW_REFRESHALL, OnViewRefreshall)
ON_COMMAND(ID_VIEW_TITLELIST, OnViewTitlelist)
ON_UPDATE_COMMAND_UI(ID_VIEW_TITLELIST, OnUpdateViewTitlelist)
ON_COMMAND(ID_OPTIONS_SETUPREB1100, OnOptionsSetupreb1100)
ON_UPDATE_COMMAND_UI(ID_OPTIONS_SETUPREB1100, OnUpdateOptionsSetupreb1100)
END_MESSAGE_MAP()


// CRebCommDoc construction/destruction

CRebCommDoc::CRebCommDoc()
: eBookUpF(false)
, bTitles(false)
, bPollStopped(false)
{
	// TODO: add one-time construction code here
	m_pListView = NULL;
	m_pTreeView = NULL;

	numDirs = 0;
}

CRebCommDoc::~CRebCommDoc()
{
}

BOOL CRebCommDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	int i;
	CString strColumnHeader;
	int strId[REB_TREMAX] = {
		IDS_TRE_EBOOK,
		IDS_TRE_INTMEM,
		IDS_TRE_SMARTMED
	};

	int iconIds[REB_TREMAX] = {
		rebFileEBook,
		rebFileClosedFolder,
		rebFileSmartMedia
	};

	for (i=0, numDirs=0; i < REB_TREMAX; i++, numDirs++)
	{
		dirEntries[i].memType = i;
		dirEntries[i].iIcon   = iconIds[i];
		strColumnHeader.LoadString(strId[i]);
		strcpy (dirEntries[i].fileName, ".");
		strcpy (dirEntries[i].itemName, 
			(LPTSTR) (LPCTSTR) strColumnHeader);
	}

	for (i=0; i < REB_TREMAX; i++)
	{
		refreshFileStruct (i);
	}

	return TRUE;
}




// CRebCommDoc serialization

void CRebCommDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


// CRebCommDoc diagnostics

#ifdef _DEBUG
void CRebCommDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CRebCommDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CRebCommDoc commands
int CRebCommDoc::updateFileList(LPARAM dirIx)
{
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;
	rebDirectory * dP = (rebDirectory *) dirIx;

	if (m_pListView)
	{
		m_pListView->setFileList (dP);
	}
	return 0;
}

int CRebCommDoc::refreshFileStruct(int memType)
{
	switch (memType)
	{
	case TRE_ROOT:
		break;

	case TRE_INTMEM:
		break;

	case TRE_SMARTMED:
		break;
	}

	return 0;
}

// check the eBook connection
bool CRebCommDoc::checkEBook(bool fullRefrF, bool propRefrF)
{
	bool    newState;
	int     retVal;
	CString dispStr;

	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;

	// If we are not allowed to poll at this moment,
	// let's just keep the status quo
	if (bPollStopped)
		return eBookUpF;

	newState = ebc.eBookCheck ();

	if (newState != eBookUpF)
		fullRefrF = true;

	if (fullRefrF)
		propRefrF = true;

	if (newState)
	{
		if (propRefrF)
			retVal = ebc.eBookGetParameters ();

		if (fullRefrF)
		{
			retVal = ebc.eBookGetDirTree (TRE_INTMEM);
			retVal = ebc.eBookGetDirTree (TRE_SMARTMED);
			retVal = ebc.eBookGetTitles ();
			retVal = ebc.eBookFixTitles (TRE_INTMEM);
			retVal = ebc.eBookFixTitles (TRE_SMARTMED);
		}
	}

	eBookUpF = ebc.getConnState ();

	if (propRefrF)
	{
		pMainFrame->stBar()->EnablePane(paneConnect, eBookUpF);
		pMainFrame->stBar()->EnablePane(paneSmartMed, ebc.smPresent);
		dispStr.LoadString (ID_INDICATOR_BATTERY);
		if (eBookUpF && (ebc.batCap != NULL))
			dispStr += ebc.batCap;
		pMainFrame->stBar()->SetText (paneBattery, dispStr, "");

		dispStr.LoadString (ID_INDICATOR_FREEMEM);
		if (eBookUpF)
		{
			if (ebc.resetF)
				dispStr.LoadString (ID_INDICATOR_RESET);
			else
			{
				CString tmpStr;
				tmpStr.Format ("%s%s B", dispStr, niceFormatInt (ebc.freeIntMem));
				if (ebc.smPresent)
					dispStr.Format ("%s / %s B (SmartMedia)", tmpStr, 
						niceFormatInt (ebc.freeSMMem));
				else
					dispStr = tmpStr;
			}
		}
		pMainFrame->stBar()->SetText (paneFreeMem, dispStr, "");

		dispStr.LoadString (ID_INDICATOR_DEVID);
		if (eBookUpF)
		{
			if (ebc.resetF)
				dispStr += ebc.sernum;
			else if (ebc.devId != NULL)
				dispStr += ebc.devId;
		}
		pMainFrame->stBar()->SetText (paneDevId, dispStr, "");
		// vvvvvvvvvvvvvvvv

		if (!fullRefrF)
		{
			if (m_pListView && 
				(m_pListView->dispType () == TRE_ROOT))
			{
				m_pListView->refreshFileList ();
			}
		}
	}

	if (fullRefrF)
	{
		dispStr.LoadString (IDS_TRE_EBOOK);
		sprintf (dirEntries[TRE_ROOT].itemName, "%s %s",
			dispStr, ebc.osVer ? ebc.osVer : "");

		if (m_pTreeView)
		{
			if (m_pListView)
			{
				m_pTreeView->loadDirTree (true,
					(eBookUpF && m_pListView->getDir()) ? 
					m_pListView->getDir()->getMemType() : TRE_ROOT);
			}
			else
			{
				m_pTreeView->loadDirTree (false);
			}
		}
	}

	return eBookUpF;
}

void CRebCommDoc::OnViewRefreshall()
{
	// TODO: Add your command handler code here
	checkEBook (true, true);
}

void CRebCommDoc::OnViewTitlelist()
{
	// TODO: Add your command handler code here
	
	bTitles = !bTitles; // Toggle the titles view

	if (m_pTreeView)
	{
		if (m_pListView)
		{
			m_pTreeView->loadDirTree (true,
				m_pListView->getDir() ? 
				m_pListView->getDir()->getMemType() : TRE_ROOT);
		}
		else
		{
			m_pTreeView->loadDirTree (false);
		}
	}

	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;
	LPCTSTR szButton, szTitle;

	if (bTitles)
	{
		szButton = _T ("Files");
		szTitle  = _T ("Title List View");
	}
	else
	{
		szButton = _T ("Titles");
		szTitle  = _T ("File System View");
	}
	pMainFrame->toolBar()->ChangeButtonTxt (ID_VIEW_TITLELIST, szButton);
	SetTitle (szTitle);


}

void CRebCommDoc::OnUpdateViewTitlelist(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here

	if (bTitles)
		pCmdUI->SetText ("File List");
	else
		pCmdUI->SetText ("Title List");
}

void CRebCommDoc::OnOptionsSetupreb1100()
{
	// TODO: Add your command handler code here
	CString propString;

	propString = CString ("eBook ") + CString (ebc.osVer);

	CPropertySheet dlgEBookProps ((const char *) propString, 
		AfxGetApp()->GetMainWnd(), 0);

	CRebStatusDlg  rebStatus;
	CRebOperDlg  rebOps;

	dlgEBookProps.AddPage (&rebStatus);
	dlgEBookProps.AddPage (&rebOps);

	rebStatus.ebcP = &ebc;
	rebOps.ebcP = &ebc;

	dlgEBookProps.DoModal ();

	if (m_pListView)
		m_pListView->OnViewRefresh ();
}

void CRebCommDoc::OnUpdateOptionsSetupreb1100(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here

	pCmdUI->Enable (eBookUpF);
}

void CRebCommDoc::completeInit(void)
{
	// We will get the flag and reverse it here, then reverse it again and
	// update all the settings...
	bTitles = (AfxGetApp ()->GetProfileInt (_T("Settings"), _T("Titles"), 0) == 0);
	OnViewTitlelist ();

	// SetTitle (_T ("File System View"));
}
