// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "RebComm.h"

#include "MainFrm.h"
#include "RebCommDoc.h"
#include "RebCommView.h"
#include "FileListView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_TIMER()
//	ON_COMMAND(145, On145)
ON_WM_CLOSE()
ON_COMMAND(ID_HELP_REBCOMMHELP, OnHelpRebcommhelp)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_BATTERY,
	ID_INDICATOR_SM,
	ID_INDICATOR_CONNECT,
	ID_INDICATOR_DEVID,
};

extern void PASCAL NEAR WriteWindowPlacement(LPWINDOWPLACEMENT pwp);

// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	m_pListView = NULL;
}

CMainFrame::~CMainFrame()
{
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	// if (!m_wndDlgBar.Create(this, IDR_MAINFRAME, 
	// 	CBRS_ALIGN_TOP, AFX_IDW_DIALOGBAR))
	// {
	//	 TRACE0("Failed to create dialogbar\n");
	//	 return -1;		// fail to create
	// }

	if (!m_wndReBar.Create(this) ||
		!m_wndReBar.AddBar(&m_wndToolBar)
	//	|| !m_wndReBar.AddBar(&m_wndDlgBar)
		)
	{
		TRACE0("Failed to create rebar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.CreateStatusBar(this, indicators, sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // Fehler beim Erzeugen
	}

	m_wndStatusBar.SetMode(paneConnect, XSB_BITMAP | XSB_STRETCH);
	m_wndStatusBar.SetBitmap(paneConnect, "IDB_CONNECTION_ON", "IDB_CONNECTION_OFF");
	
	m_wndStatusBar.SetMode(paneSmartMed, XSB_BITMAP | XSB_STRETCH);
	m_wndStatusBar.SetBitmap(paneSmartMed, "IDB_SM_CARD_ON", "IDB_SM_CARD_OFF");
	
	m_wndStatusBar.SetWidth(paneBattery,  100);
	m_wndStatusBar.SetWidth(paneSmartMed, 50);
	m_wndStatusBar.SetWidth(paneConnect,  70);
	m_wndStatusBar.SetWidth(paneDevId,    200);

	// TODO: Remove this if you don't want tool tips
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);

	SetIcon((HICON)(LoadImage(AfxGetResourceHandle(), 
			MAKEINTRESOURCE(IDR_MAINFRAME), 
			IMAGE_ICON, 16, 16, 0)), FALSE);

	return 0;
}

BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT /*lpcs*/,
	CCreateContext* pContext)
{
	BOOL bRet;

#ifdef NOTUSED
	return m_wndSplitter.Create(this,
		1, 2,               // TODO: adjust the number of rows, columns
		CSize(200, 300),      // TODO: adjust the minimum pane size
		pContext);
#endif

	if(!m_wndSplitter.CreateStatic(this, 1, 2))
		return FALSE;

#ifdef NOTUSED
	for (nRow = 0; nRow < 1; nRow++)
	for (nCol = 0; nCol < 2; nCol++)
	{
		bRet = m_wndSplitter.CreateView(nRow, nCol,
			RUNTIME_CLASS(CRebCommView),
			CSize(200, 30), pContext);
		if (bRet ==  FALSE)
			return FALSE;
	}
#endif

	bRet = m_wndSplitter.CreateView(0, 0,
		RUNTIME_CLASS(CRebCommView),
		CSize(200, 30), pContext);
	if (bRet ==  FALSE)
		return FALSE;

	bRet = m_wndSplitter.CreateView(0, 1,
		RUNTIME_CLASS(CFileListView),
		CSize(300, 30), pContext);
	if (bRet ==  FALSE)
		return FALSE;

	m_pListView = (CFileListView *) m_wndSplitter.GetPane (0, 1);

	SetTimer( IDC_CONNECT_TIMER, 2000, NULL);

	return TRUE;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}


// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


void CMainFrame::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	CRebCommDoc *pDoc = (CRebCommDoc *) GetActiveDocument();
	static int iBatCheck = 0;

	switch (nIDEvent)
	{
	case IDC_CONNECT_TIMER:
		iBatCheck++;
		if (iBatCheck > 10)
		{
			pDoc->checkEBook (false, true);
			iBatCheck = 0;
		}
		else
		{
			pDoc->checkEBook (false, false);
		}
		break;
	}

	CFrameWnd::OnTimer(nIDEvent);
}

BOOL CTextToolBar::LoadToolBar(UINT nIDResource /* LPCTSTR lpszResourceName */)
{
	BOOL bReturn = CToolBar::LoadToolBar(nIDResource);
	// Check if we loaded the toolbar.
	if (bReturn == FALSE)
		return bReturn;

	// Make it flat.
	ModifyStyle(0, GetStyle()|TBSTYLE_FLAT);

	// Set the text for each button
	CToolBarCtrl& bar = GetToolBarCtrl();


	// Remove the string map in case we are loading another toolbar into this control
	if (m_pStringMap)
	{
		delete m_pStringMap;
		m_pStringMap = NULL;
	}

	int		nIndex = 0;
	TBBUTTON	tb;

	for (nIndex = bar.GetButtonCount() - 1; nIndex >= 0; nIndex--)
	{
		ZeroMemory(&tb, sizeof(TBBUTTON));
		bar.GetButton(nIndex, &tb);

		// Do we have a separator?
		if ((tb.fsStyle & TBSTYLE_SEP) ==  TBSTYLE_SEP)
			continue;

		// Have we got a valid command id?
		if (tb.idCommand == 0)
			continue;

		// Get the resource string if there is one.
		CString strText;
		LPCTSTR lpszButtonText = NULL;
		CString	strButtonText(_T(""));
		_TCHAR	seps[] = _T("\n");

		strText.LoadString(tb.idCommand);

		if (!strText.IsEmpty())
		{
			lpszButtonText = _tcstok((LPTSTR)(LPCTSTR)strText, seps);

			while(lpszButtonText)
			{
				strButtonText = lpszButtonText;
				lpszButtonText = _tcstok(NULL, seps);
			}
		}

		if (!strButtonText.IsEmpty())
			SetButtonText(nIndex, strButtonText);
	}

	// Resize the buttons so that the text will fit.
	CRect rc(0, 0, 0, 0);
	CSize sizeMax(0, 0);

	for (nIndex = bar.GetButtonCount() - 1; nIndex >= 0; nIndex--)
	{
		bar.GetItemRect(nIndex, rc);

		rc.NormalizeRect();
		sizeMax.cx = __max(rc.Size().cx, sizeMax.cx);
		sizeMax.cy = __max(rc.Size().cy, sizeMax.cy);
	}
	SetSizes(sizeMax, CSize(16,16));

	return bReturn;
}

BOOL CTextToolBar::ChangeButtonTxt(UINT id, LPCTSTR szText)
{
	BOOL bReturn = FALSE;

	// Set the text for each button
	CToolBarCtrl& bar = GetToolBarCtrl();

	int		nIndex = 0;
	TBBUTTON	tb;

	for (nIndex = bar.GetButtonCount() - 1; nIndex >= 0; nIndex--)
	{
		ZeroMemory(&tb, sizeof(TBBUTTON));
		bar.GetButton(nIndex, &tb);

		// Do we have a separator?
		if ((tb.fsStyle & TBSTYLE_SEP) ==  TBSTYLE_SEP)
			continue;

		// Have we got a valid command id?
		if (tb.idCommand == id)
		{
			bReturn = TRUE;
			SetButtonText(nIndex, szText);
			break;
		}
	}

#ifdef RESIZE_ON_CHANGE
	// Resize the buttons so that the text will fit.
	CRect rc(0, 0, 0, 0);
	CSize sizeMax(0, 0);

	for (nIndex = bar.GetButtonCount() - 1; nIndex >= 0; nIndex--)
	{
		bar.GetItemRect(nIndex, rc);

		rc.NormalizeRect();
		sizeMax.cx = __max(rc.Size().cx, sizeMax.cx);
		sizeMax.cy = __max(rc.Size().cy, sizeMax.cy);
	}
	SetSizes(sizeMax, CSize(16,16));
#endif

	return bReturn;
}

void CMainFrame::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	KillTimer (IDC_CONNECT_TIMER);

	if (m_pListView)
		m_pListView->saveSettings ();

	WINDOWPLACEMENT wp;
	wp.length = sizeof wp;
	if (GetWindowPlacement(&wp))
	{
		wp.flags = 0;

		if (IsZoomed())
			wp.flags |= WPF_RESTORETOMAXIMIZED;

		// and write it to the .INI file
		WriteWindowPlacement(&wp);
	}

	CFrameWnd::OnClose();
}

void CMainFrame::OnHelpRebcommhelp()
{
	// TODO: Add your command handler code here
	CFrameWnd::OnHelpFinder ();
}
