// FileListView.cpp : implementation file
//

#include "stdafx.h"
#include <afxstat_.h>
#include "MainFrm.h"
#include "RebComm.h"
#include "RebCommDoc.h"
#include "FileListView.h"
#include "FilePropPage.h"
#include "TitlePropPage.h"
#include ".\filelistview.h"

UINT g_uCustomClipbrdFormat = RegisterClipboardFormat ( _T("RebComm_clipboard_format") );
bool g_bNT = (0 == (GetVersion() & 0x80000000) );

// CFileListView

IMPLEMENT_DYNCREATE(CFileListView, CListView)

CFileListView::CFileListView()
: currMemType(-1)
, m_iSortColumn(-1)
, m_bSortAscending(true)
, m_currDirP(NULL)
, m_pwchTip(NULL)
, m_pchTip(NULL)
, m_bToolTipCtrlCustomizeDone(false)
, m_bShowTooltips(true)
{
	m_szNextFile[0] = '\0';

    // Create an instance of the shell DnD helper object.
    if ( SUCCEEDED( CoCreateInstance ( CLSID_DragDropHelper, NULL, 
                                       CLSCTX_INPROC_SERVER,
                                       IID_IDropTargetHelper, 
                                       (void**) &m_piDropHelper ) ))
	{
		m_bUseDnDHelper = true;
	}
}

CFileListView::~CFileListView()
{
	if(m_pchTip != NULL)
		delete m_pchTip;

	if(m_pwchTip != NULL)
		delete m_pwchTip;
}

BEGIN_MESSAGE_MAP(CFileListView, CListView)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnLvnColumnclick)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_FILE_DOWNLOADTOPC, OnReb1100fileDownloadtopc)
	ON_UPDATE_COMMAND_UI(ID_FILE_DOWNLOADTOPC, OnUpdateReb1100fileDownloadtopc)
	ON_COMMAND(ID_FILE_UPLOADTOEBOOK, OnFileUploadtoebook)
	ON_UPDATE_COMMAND_UI(ID_FILE_UPLOADTOEBOOK, OnUpdateFileUploadtoebook)
	ON_COMMAND(ID_FILE_DELETEEBOOK, OnFileDeleteebook)
	ON_UPDATE_COMMAND_UI(ID_FILE_DELETEEBOOK, OnUpdateFileDeleteebook)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_UPDATE_COMMAND_UI(ID_VIEW_REFRESH, OnUpdateViewRefresh)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFilePrint)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_PREVIEW, OnUpdateFilePrintPreview)
	ON_COMMAND(ID_FILE_PROPERTIES, OnFileProperties)
	ON_UPDATE_COMMAND_UI(ID_FILE_PROPERTIES, OnUpdateFileProperties)
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTW, 0, 0xFFFF, OnToolTipText)
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTA, 0, 0xFFFF, OnToolTipText)
	ON_COMMAND(ID_VIEW_SHOWTOOLTIPS, OnViewShowtooltips)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWTOOLTIPS, OnUpdateViewShowtooltips)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_VIEW_SHOWGRIDLINES, OnViewShowgridlines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWGRIDLINES, OnUpdateViewShowgridlines)
//	ON_WM_CLOSE()
ON_NOTIFY_REFLECT(LVN_BEGINDRAG, OnLvnBegindrag)
END_MESSAGE_MAP()


// CFileListView diagnostics

#ifdef _DEBUG
void CFileListView::AssertValid() const
{
	CListView::AssertValid();
}

void CFileListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CRebCommDoc* CFileListView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CRebCommDoc)));
	return (CRebCommDoc*)m_pDocument;
}
#endif //_DEBUG


// CFileListView message handlers

BOOL CFileListView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Add your specialized code here and/or call the base class
	cs.style |= (LVS_REPORT | WS_VSCROLL /* | LVS_SINGLESEL */);
	cs.style &= ~(LVS_SORTDESCENDING | LVS_SORTASCENDING);
	// cs.dwExStyle |= WS_EX_ACCEPTFILES;

	EnableToolTips(); // Enables list contrl ToolTip control

	return CListView::PreCreateWindow(cs);
}

void CFileListView::OnInitialUpdate()
{
	CListView::OnInitialUpdate();

	// TODO: Add your specialized code here and/or call the base class
	CListCtrl& TheList = GetListCtrl();
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	CWinApp * appP = AfxGetApp ();
	
	VERIFY( m_ctlHeader.SubclassWindow( TheList.GetHeaderCtrl()->GetSafeHwnd() ) );

    // Register our view as a drop target.

    m_droptarget.Register ( this );

	pDoc->setListView (this);

	CBitmap treBmap;

	treBmap.LoadBitmap (IDB_FILETYPES);

	m_cil.Create(16, 16, ILC_COLOR8, 0, 10);
	m_cil.Add (&treBmap, RGB (0, 0, 0));

	TheList.SetImageList( &m_cil, LVSIL_SMALL );
	TheList.SetExtendedStyle(TheList.GetExtendedStyle()
		| (LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP));

	TCHAR BASED_CODE szSection[] = _T("Settings");
	TCHAR BASED_CODE * szParam;

	szParam = _T("Gridlines");

	if (appP->GetProfileInt (szSection, szParam, FALSE))
		TheList.SetExtendedStyle(TheList.GetExtendedStyle() | LVS_EX_GRIDLINES);

	pDoc->completeInit ();


}

int CFileListView::clearFileList(void)
{
	CListCtrl& TheList = GetListCtrl();

	TheList.DeleteAllItems ();

	return 0;
}

int CFileListView::generateFileList(rebDirectory * dP)
{
	CListCtrl& TheList = GetListCtrl();
	int i, iSubItem, ix;
	LVITEM listItem;
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;

	if ((dP == NULL) && (currMemType == TRE_ROOT))
	{
		Node<rebProperty *> * nP = pDoc->ebc.props;
		rebProperty * pP;
		CString propString;

		for (i = 0; nP = nP->getNext(); i++)
		{
			pP = nP->getKey ();

			listItem.mask = LVIF_PARAM | LVIF_TEXT | LVIF_IMAGE;
			listItem.lParam   = (LPARAM) pP;
			listItem.iItem    = i;
			listItem.iImage   = 0;
			listItem.iSubItem = 0;
			listItem.pszText  = pP->getName();
			iSubItem = 0;
			ix = TheList.InsertItem (&listItem);

			propString = pP->getValue (0);
			for (int cnt=1; cnt < pP->getValCnt(); cnt++)
			{
				propString += " [";
				propString += pP->getValue (cnt);
				propString += "]";
			}

			listItem.pszText = LPSTR ((const char *) propString);
			TheList.SetItemText(ix, ++iSubItem, listItem.pszText);

			// TheList.SetItemData (ix, (LPARAM) pP);
		}
	}
	else if (currMemType == TRE_TITLES)
	{
		Node<rebTitle *> * nP = pDoc->ebc.titles;
		rebTitle * tP;
		rebFile  * fP;
		char    tempBuf[64];

		for (i = 0; nP = nP->getNext(); i++)
		{
			tP = nP->getKey ();
			fP = tP->getFile ();

			if (fP == NULL)
				continue;

			if (dP && (fP->getDir()->getMemType() != dP->getMemType()))
				continue;

			listItem.mask = LVIF_PARAM | LVIF_TEXT | LVIF_IMAGE;
			listItem.lParam   = (LPARAM) tP;
			listItem.iItem    = i;
			listItem.iImage   = 1 + rebRbFile;
			listItem.iSubItem = 0;
			listItem.pszText  = tP->title;
			iSubItem = 0;
			ix = TheList.InsertItem (&listItem);

			listItem.pszText = tP->author;
			TheList.SetItemText(ix, ++iSubItem, listItem.pszText);

			sprintf (tempBuf, "%s", niceFormatInt (tP->size));
			listItem.pszText = tempBuf;
			TheList.SetItemText(ix, ++iSubItem, listItem.pszText);
			// TheList.SetItemData (ix, (LPARAM) pP);
		}
	}
	else 
	{
		Node<rebFile *> * nP = dP->files;
		rebFile * fP;
		char    tempBuf[64];
		char    shortNm[64];
		char   *szP;

		for (i = 0; nP = nP->getNext(); i++)
		{
			fP = nP->getKey ();

			szP = fP->getExten();
			if (szP && (szP[0] != '\0'))
				sprintf (shortNm, "%s.%s", fP->getShName (), szP);
			else
				strcpy (shortNm, fP->getShName ());

			listItem.mask = LVIF_PARAM | LVIF_TEXT | LVIF_IMAGE;
			listItem.lParam   = (LPARAM) fP;
			listItem.iItem    = i;
			listItem.iImage   = 1+fP->getType();
			listItem.iSubItem = 0;
			listItem.pszText  = fP->getLnName();
			if (listItem.pszText[0] == '\0')
				listItem.pszText  = shortNm;

			iSubItem = 0;
			ix = TheList.InsertItem (&listItem);

			listItem.pszText = fP->getAttr ();
			TheList.SetItemText(ix, ++iSubItem, listItem.pszText);

			sprintf (tempBuf, "%s", niceFormatInt (fP->getSz ()));
			listItem.pszText = tempBuf;
			TheList.SetItemText(ix, ++iSubItem, listItem.pszText);

			listItem.pszText = shortNm;
			TheList.SetItemText(ix, ++iSubItem, listItem.pszText);
		}
	}

	return 0;
}

// Set the proper number of columns in the view
int CFileListView::setRebView(rebDirectory * dP)
{
	CListCtrl& TheList = GetListCtrl();
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();
	
	int memType;
	
	// There is really only two view types we want to
	// support at the time...
	if (pDoc->bTitles)
		memType = TRE_TITLES;
	else if (dP)
		memType = TRE_INTMEM;
	else
		memType = TRE_ROOT;

	if (memType != currMemType)
	{
		int nColumnCount = TheList.GetHeaderCtrl()->GetItemCount();
		LV_COLUMN lvc;
		CString strColumnHeader;

		// Delete all of the columns.
		for (int i=0;i < nColumnCount;i++)
		{
			TheList.DeleteColumn(0);
		}

		lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		lvc.fmt = LVCFMT_LEFT;
		lvc.iSubItem = 0;

		if (memType == TRE_ROOT)
		{
			strColumnHeader.LoadString(IDS_PROPERTY);
			lvc.cx = 160;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;

			lvc.iSubItem++;
			strColumnHeader.LoadString(IDS_VALUE);
			lvc.cx = 160;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;
			
		}
		else if (memType == TRE_INTMEM)
		{
			strColumnHeader.LoadString(IDS_FILE_NAME);
			lvc.cx = 260;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;

			lvc.iSubItem++;
			lvc.fmt = LVCFMT_RIGHT;
			strColumnHeader.LoadString(IDS_ATTRIBUTES);
			lvc.cx = 80;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;
			
			lvc.iSubItem++;
			strColumnHeader.LoadString(IDS_SIZE);
			lvc.cx = 80;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;
			
			lvc.iSubItem++;
			strColumnHeader.LoadString(IDS_SHORT_NAME);
			lvc.cx = 110;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;
		}
		else if (memType == TRE_TITLES)
		{
			strColumnHeader.LoadString(IDS_TITLE_NAME);
			lvc.cx = 260;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;

			lvc.iSubItem++;
			strColumnHeader.LoadString(IDS_TITLE_AUTHOR);
			lvc.cx = 180;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;
			
			lvc.iSubItem++;
			lvc.fmt = LVCFMT_RIGHT;
			strColumnHeader.LoadString(IDS_SIZE);
			lvc.cx = 80;
			lvc.pszText = (LPTSTR) (LPCTSTR) strColumnHeader;
			if (TheList.InsertColumn(lvc.iSubItem, &lvc) == -1)
				return -1;
		}

		currMemType = memType;
		m_iSortColumn = -1;
	}
	return 0;
}

void CFileListView::OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here

	const int iColumn = pNMLV->iSubItem;

	// if it's a second click on the same column then reverse the sort order,
	// otherwise sort the new column in ascending order.
	rebItemSort( iColumn, (iColumn == m_iSortColumn) ? !m_bSortAscending : TRUE );

	*pResult = 0;
}

// Sort item by this column's order
int CFileListView::rebItemSort(int iColumn, bool bAscending)
{
	CListCtrl& TheList = GetListCtrl();

	m_iSortColumn = iColumn;
	m_bSortAscending = bAscending;

	// show the appropriate arrow in the header control.
	m_ctlHeader.SetSortArrow( m_iSortColumn, m_bSortAscending );

	VERIFY( TheList.SortItems( CompareFunction, reinterpret_cast<LPARAM>( this ) ) );

	return 0;
}

int NumberCompare (int iNumber1, int iNumber2)
{
	if( iNumber1 < iNumber2 )
		return -1;
	
	if( iNumber1 > iNumber2 )
		return 1;

	return 0;
}

int CALLBACK CFileListView::CompareFunction( LPARAM lParam1, LPARAM lParam2, LPARAM lParamData )
{
	CFileListView* pListView = reinterpret_cast<CFileListView*>( lParamData );
	ASSERT( pListView->IsKindOf( RUNTIME_CLASS( CListView ) ) );
	LPCTSTR pszText1 = "";
	LPCTSTR pszText2 = "";

	if (pListView->currMemType == TRE_ROOT)
	{
		rebProperty * pid1 = reinterpret_cast<rebProperty*>( lParam1 );
		rebProperty * pid2 = reinterpret_cast<rebProperty*>( lParam2 );

		ASSERT( pid1 );
		ASSERT( pid2 );

		switch (pListView->m_iSortColumn)
		{
		case 0:
			pszText1 = pid1->getName ();
			pszText2 = pid2->getName ();
			break;
		case 1:
			pszText1 = pid1->getValue ();
			pszText2 = pid2->getValue ();
			break;
		}
	}
	else if (pListView->currMemType == TRE_INTMEM)
	{
		rebFile * pid1 = reinterpret_cast<rebFile*>( lParam1 );
		rebFile * pid2 = reinterpret_cast<rebFile*>( lParam2 );

		ASSERT( pid1 );
		ASSERT( pid2 );

		char    shortNm1[64];
		char    shortNm2[64];

		switch (pListView->m_iSortColumn)
		{
		case 0:
			pszText1 = pid1->getLnName ();
			pszText2 = pid2->getLnName ();
			break;
		case 1:
			pszText1 = pid1->getAttr ();
			pszText2 = pid2->getAttr ();
			return pListView->m_bSortAscending ? 
				strcmp( pszText1, pszText2 ) : 
				strcmp( pszText2, pszText1 );

		case 2:
			return pListView->m_bSortAscending ? 
				NumberCompare( pid1->getSz (), pid2->getSz () ) : 
				NumberCompare( pid2->getSz (), pid1->getSz () );

		case 3:
			// Make first short name
			pszText1 = pid1->getExten();
			if (pszText1 && (pszText1[0] != '\0'))
				sprintf (shortNm1, "%s.%s", pid1->getShName (), pszText1);
			else
				strcpy (shortNm1, pid1->getShName ());
			pszText1 = shortNm1;

			// Make second short name
			pszText2 = pid2->getExten();
			if (pszText2 && (pszText2[0] != '\0'))
				sprintf (shortNm2, "%s.%s", pid2->getShName (), pszText2);
			else
				strcpy (shortNm2, pid2->getShName ());
			pszText2 = shortNm2;

			break;
		}
	}
	else if (pListView->currMemType == TRE_TITLES)
	{
		rebTitle * pid1 = reinterpret_cast<rebTitle*>( lParam1 );
		rebTitle * pid2 = reinterpret_cast<rebTitle*>( lParam2 );

		ASSERT( pid1 );
		ASSERT( pid2 );

		switch (pListView->m_iSortColumn)
		{
		case 0:
			pszText1 = pid1->title;
			pszText2 = pid2->title;
			break;
		case 1:
			pszText1 = pid1->author;
			pszText2 = pid2->author;
			break;

		case 2:
			return pListView->m_bSortAscending ? 
				NumberCompare( pid1->size, pid2->size ) : 
				NumberCompare( pid2->size, pid1->size );
		}
	}

	ASSERT_VALID_STRING( pszText1 );
	ASSERT_VALID_STRING( pszText2 );

	return pListView->m_bSortAscending ? lstrcmpi( pszText1, pszText2 ) : lstrcmpi( pszText2, pszText1 );
}

// // Set the current file list
void CFileListView::setFileList(rebDirectory * dP)
{
	clearFileList ();

	m_currDirP = dP;

	setRebView (dP);

	generateFileList (dP);

	if (m_iSortColumn >= 0)
	{
		rebItemSort (m_iSortColumn,	m_bSortAscending);
	}
}

void CFileListView::refreshFileList(void)
{
	setFileList (m_currDirP);
}

void CFileListView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// The default handler is going to set the item
	// selected, so our menu selections will work

	CListView::OnRButtonDown(nFlags, point);

	CListCtrl& TheList = GetListCtrl();
	int nIndex = itemHitTest (point);
	if (nIndex >= 0)
	{
		if ((currMemType == TRE_INTMEM) ||
			(currMemType == TRE_TITLES))
		{
			CMenu popup;
			ClientToScreen(&point); 

			popup.LoadMenu(IDR_FILEMENU);

			CMenu* pMenu = popup.GetSubMenu(0);
			ASSERT(pMenu);

			if (currMemType == TRE_INTMEM)
			{
				rebFile * fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nIndex));

				if (fileP->getType () != rebRbFile)
				{
					pMenu->EnableMenuItem (ID_FILE_DELETEEBOOK,
						MF_GRAYED);
				}
			}

			pMenu->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON,
				point.x, point.y, this);
		}
	}
}

void CFileListView::OnReb1100fileDownloadtopc()
{
	// TODO: Add your command handler code here
	CString fileName;
	char fileSaveName[256];
    static char BASED_CODE szFilterRb[] = "eBook Files (*.rb)|*.rb|All Files (*.*)|*.*||";
    static char BASED_CODE szFilterAll[] = "All Files (*.*)|*.*||";
	CListCtrl& TheList = GetListCtrl();
	UINT i, uSelectedCount = TheList.GetSelectedCount();
	int  nItem = -1;
	LPARAM  lParam;
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;
	rebFile * fileP;

	// Update all of the selected items.
	if (uSelectedCount > 0)
	{
		for (i=0;i < uSelectedCount;i++)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			ASSERT(nItem != -1);
			lParam = TheList.GetItemData (nItem);
			
			switch (currMemType) {
				case TRE_INTMEM:
                    fileP = reinterpret_cast<rebFile *> (lParam);
					break;

				case TRE_TITLES:
					fileP = (reinterpret_cast<rebTitle *> (lParam))->getFile();
					break;

				default:
					return;
			}

			if (fileP == NULL)
				return;

			CFileDialog openFileDlg(FALSE, 
				fileP->isEBook () ? "*.rb" : NULL, 
				fileP->getLnName (),
				OFN_LONGNAMES | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
				fileP->isEBook () ? szFilterRb : szFilterAll);


			if (openFileDlg.DoModal() == IDOK)
			{
				CWaitCursor waiting;

				fileName = openFileDlg.GetPathName();
				strcpy(fileSaveName,fileName);
				// dbISaveFile (fileSaveName);

				pMainFrame->stBar ()->SavePane(0);
				pMainFrame->stBar ()->SetMode(0, XSB_PROGRESS);
				pMainFrame->stBar ()->SetRange(0, 0, 100);
				fileP->readFile (fileSaveName, showProgress);
				Sleep (100);
				pMainFrame->stBar ()->RestorePane(0);
			}
		}
	}

}

void CFileListView::showProgress(int currPct)
{
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;

	pMainFrame->stBar ()->SetPos(0, currPct);
	pMainFrame->stBar ()->UpdateWindow ();
	Sleep (0);
}

void CFileListView::OnUpdateReb1100fileDownloadtopc(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
	CListCtrl& TheList = GetListCtrl();
	UINT uSelectedCount = TheList.GetSelectedCount();
	int  nItem = -1;

	if (uSelectedCount > 0)
	{
		if (currMemType == TRE_INTMEM)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			if (nItem != -1)
			{		
				rebFile * fileP;
				fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nItem));
				pCmdUI->Enable (!(fileP->isDirectory () || fileP->isHidden ()));
				return;
			}
		}
		else if (currMemType == TRE_TITLES)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			if (nItem != -1)
			{	
				rebTitle * tP;
				tP = reinterpret_cast<rebTitle *> (TheList.GetItemData (nItem));
				pCmdUI->Enable (tP->getFile() != NULL);
				return;
			}
		}
	}

	pCmdUI->Enable (false);
}

void CFileListView::OnFileUploadtoebook()
{
	// TODO: Add your command handler code here
	CString fileName;
    static char BASED_CODE szFilterRb[] = "eBook Files (*.rb)|*.rb||";
    static char BASED_CODE szFilterAll[] = "All Files (*.*)|*.*||";

	CFileDialog openFileDlg(TRUE, "*.rb", NULL,
		OFN_LONGNAMES, szFilterRb);

	if (openFileDlg.DoModal() == IDOK)
	{
		fileName = openFileDlg.GetPathName();
		strcpy (m_szNextFile, fileName);
		
		putFileToREB (this);

		m_szNextFile[0] = '\0';
	}
}

bool CFileListView::AllowUpload ()
{
	bool bEnb = false;
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	if ((currMemType == TRE_INTMEM) && 
		(!strcmp (m_currDirP->getLnName(), "books")))
	{
		bEnb = true;
	}
	else if (currMemType == TRE_TITLES)
	{
		if (m_currDirP)
		{
			if ((m_currDirP->getMemType () != TRE_SMARTMED) ||
				pDoc->ebc.smPresent)
			{
				bEnb = true;
			}
		}
		else
		{
			bEnb = true;
		}
	}

	return (bEnb);
}

void CFileListView::OnUpdateFileUploadtoebook(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable  (AllowUpload());
}

DROPEFFECT CFileListView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	HDROP       hdrop;
	DROPEFFECT  dwEffect = DROPEFFECT_NONE;
	UINT        uNumFiles;
	HGLOBAL     hg;

    // Check for our own custom clipboard format in the data object.  If it's
    // present, then the DnD was initiated from our own window, and we won't
    // accept the drop.
    // If it's not present, then we check for CF_HDROP data in the data object.

    if ( NULL == pDataObject->GetGlobalData ( g_uCustomClipbrdFormat ))
	{
        // Look for CF_HDROP data in the data object, and accept the drop if
        // it's there.

		hg = pDataObject->GetGlobalData ( CF_HDROP );
        if ( NULL !=  hg )
		{
			if (AllowUpload ())
			{
			    hdrop = (HDROP) GlobalLock ( hg );

				if ( NULL != hdrop )
				{
					// Get the # of files being dropped.

					uNumFiles = DragQueryFile ( hdrop, -1, NULL, 0 );

					for ( UINT uFile = 0; uFile < uNumFiles; uFile++ )
					{
						// Get the next filename from the HDROP info.

						if ( DragQueryFile ( hdrop, uFile, m_szNextFile, MAX_PATH ) > 0 )
						{
							if ( PathMatchSpec ( m_szNextFile, _T("*.rb") ))
							{
								dwEffect = DROPEFFECT_COPY;
								break;
							}
						}
					}
				}
		
				GlobalUnlock ( hg );
			}
		}
	}

    // Call the DnD helper.

    if ( m_bUseDnDHelper )
	{
        // The DnD helper needs an IDataObject interface, so get one from
        // the COleDataObject.  Note that the FALSE param means that
        // GetIDataObject will not AddRef() the returned interface, so 
        // we do not Release() it.

        IDataObject* piDataObj = pDataObject->GetIDataObject ( FALSE ); 

        m_piDropHelper->DragEnter ( GetSafeHwnd(), piDataObj, 
                                    &point, dwEffect );
	}

	m_dwEffect = dwEffect;

    return dwEffect;
}

void CFileListView::OnDragLeave()
{
    if ( m_bUseDnDHelper )
    {
        m_piDropHelper->DragLeave();
    }

	m_szNextFile[0] = '\0';
	m_dwEffect = DROPEFFECT_NONE;
}

DROPEFFECT CFileListView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	DROPEFFECT dwEffect = m_dwEffect;

    // Call the DnD helper.

    if ( m_bUseDnDHelper )
    {
        m_piDropHelper->DragOver ( &point, dwEffect );
    }

    return dwEffect;
}

BOOL CFileListView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point)
{
	BOOL bRet = TRUE;
	HDROP       hdrop;
	UINT        uNumFiles;
	HGLOBAL     hg;

    // Read the CF_HDROP data and put the files in the main window's list.

    if (m_szNextFile[0] != '\0')
	{
		hg = pDataObject->GetGlobalData ( CF_HDROP );
        if ( NULL !=  hg )
		{
			hdrop = (HDROP) GlobalLock ( hg );

			if ( NULL != hdrop )
			{
				// Get the # of files being dropped.

				uNumFiles = DragQueryFile ( hdrop, -1, NULL, 0 );

				for ( UINT uFile = 0; uFile < uNumFiles; uFile++ )
				{
					// Get the next filename from the HDROP info.

					if ( DragQueryFile ( hdrop, uFile, m_szNextFile, MAX_PATH ) > 0 )
					{
						if ( PathMatchSpec ( m_szNextFile, _T("*.rb") ))
						{
#ifdef USE_SEPARATE_THREAD
							HANDLE hThread;
							DWORD  dwThreadId;

							hThread = CreateThread( 
									NULL,                        // default security attributes 
									0,                           // use default stack size  
									putFileToREB,                // thread function 
									this,                        // argument to thread function 
									0,                           // use default creation flags 
									&dwThreadId);                // returns the thread identifier 
								
							// Check the return value for success. 
							if (hThread != NULL) 
							{
								CloseHandle( hThread );
							}
							// putFileToREB ();
							Sleep (200); // Make sure the thread get all it needs
#else
							putFileToREB (this);
#endif
						}
					}
				}
			}

			GlobalUnlock ( hg );
		}
	}

    // Call the DnD helper.

    if ( m_bUseDnDHelper )
    {
        // The DnD helper needs an IDataObject interface, so get one from
        // the COleDataObject.  Note that the FALSE param means that
        // GetIDataObject will not AddRef() the returned interface, so 
        // we do not Release() it.

        IDataObject* piDataObj = pDataObject->GetIDataObject ( FALSE ); 

        m_piDropHelper->Drop ( piDataObj, &point, dropEffect );
    }
    
	m_dwEffect = DROPEFFECT_NONE;

	m_szNextFile[0] = '\0';

    return bRet;
}

DWORD WINAPI putFileToREB( LPVOID lpParam )
{
	char fileRebName[MAX_REB_LONG_FILENAME_LEN];
	char baseName[MAX_PATH];
	char message[MAX_PATH * 4];
	CFileListView * flvP = reinterpret_cast<CFileListView *> (lpParam);
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;
    CRebCommDoc* pDoc = (CRebCommDoc*) flvP->GetDocument();
	DWORD  fileSize, freeMem = pDoc->ebc.freeIntMem;

	strcpy (baseName, PathFindFileName (flvP->getNextFName()));

    HANDLE hPcFile= CreateFile (flvP->getNextFName(),
                                GENERIC_READ,
                                FILE_SHARE_READ,
                                NULL,
                                OPEN_EXISTING,
                                FILE_ATTRIBUTE_NORMAL,
                                NULL);

    if (hPcFile == INVALID_HANDLE_VALUE)
    {
		AfxMessageBox ("Unable to open file for reading", MB_OK|MB_ICONSTOP);
		return FAILURE;
    }

	fileSize = GetFileSize (hPcFile, NULL);
	CloseHandle (hPcFile);

	if (flvP->getDir())
	{
		flvP->getDir()->makePath (fileRebName);
		if (flvP->getDir()->getMemType () == TRE_SMARTMED)
			freeMem = pDoc->ebc.freeSMMem;
	}
	else if ((flvP->dispType () == TRE_TITLES) && (pDoc->ebc.smPresent == false))
		fileRebName[0] = '\0';
	else
	{
		sprintf (message, "Name:\t%s\nSize:\t%d B\n"
					        "Please select the appropriate folder before dropping files",
							baseName, 
							fileSize);
		AfxMessageBox (message, MB_OK|MB_ICONSTOP);
		return FAILURE;
	}

	if (fileSize >= freeMem)
	{
		sprintf (message, "Name:\t%s\nSize:\t%d B\nFree:\t%d B\n"
					        "Not enough room in folder. Free up some space!",
							baseName, 
							fileSize,
							freeMem);
		AfxMessageBox (message, MB_OK|MB_ICONSTOP);
		return FAILURE;
	}

	if (flvP->dispType () == TRE_TITLES)
	{
		strcat (fileRebName, "\\books\\");
	}
	else if (flvP->dispType () == TRE_INTMEM)
	{
		strcat (fileRebName, "\\");
	}
	else
		return FAILURE;
	strcat (fileRebName, baseName);

	Node<rebTitle *> * nP = pDoc->ebc.titles;
	rebFile * fP;

	while (nP = nP->getNext())
	{
		fP = nP->getKey ()->getFile();
		if (fP)
		{
			if (!strcmp (fP->getLnName (), baseName))
			{
				sprintf (message, "Name:\t%s\nTitle:\t%s\nAuthor:\t%s\n"
					              "File with this name already exists, delete it first!",
								  baseName, 
								  fP->getTitle()->title, fP->getTitle()->author);
				AfxMessageBox (message, MB_OK|MB_ICONSTOP);
				return FAILURE;
			}
		}
	}

	pDoc->bPollStopped = true;

	CWaitCursor waiting;
	
	pMainFrame->SetForegroundWindow ();
	pMainFrame->UpdateWindow ();

	pMainFrame->stBar ()->SavePane(0);
	pMainFrame->stBar ()->SetMode(0, XSB_PROGRESS);
	pMainFrame->stBar ()->SetRange(0, 0, 100);
	if (pDoc->ebc.eWriteFile (fileRebName, 
		flvP->getNextFName(), flvP->showProgress) == FAILURE)
	{
		sprintf (message, "Name:\t%s\nTitle:\t%s\nAuthor:\t%s\n"
					        "Failed to write file to REB1100",
							baseName, 
							fP->getTitle()->title, fP->getTitle()->author);
		AfxMessageBox (message, MB_OK|MB_ICONSTOP);
	}

	// It takes a bit longer to update the titles after
	// upload to SM card
	if (flvP->getDir() && (flvP->getDir()->getMemType() == TRE_SMARTMED))
		Sleep (600);
	Sleep (1000);
	
	pMainFrame->stBar ()->RestorePane(0);

	pDoc->bPollStopped = false;

	flvP->OnViewRefresh ();

	return (SUCCESS);
}

void CFileListView::OnFileDeleteebook()
{
	// TODO: Add your command handler code here

	CListCtrl& TheList = GetListCtrl();
	UINT i, uSelectedCount = TheList.GetSelectedCount();
	int  nItem = -1;
	rebFile * fileP = NULL;

	if (uSelectedCount > 0)
	{
		if (uSelectedCount > 1)
		{
			if (AfxMessageBox ("Are you sure you want to delete multiple titles?", 
				MB_OKCANCEL | MB_ICONQUESTION) != IDOK)
				return;
		}

		CWaitCursor waiting;

		for (i=0, nItem=-1; i < uSelectedCount; i++)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			ASSERT(nItem != -1);
			fileP = NULL;

			if (currMemType == TRE_INTMEM)
			{
				fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nItem));
			}
			else if (currMemType == TRE_TITLES)
			{
				rebTitle * tP = reinterpret_cast<rebTitle *> (TheList.GetItemData (nItem));
				fileP = tP->getFile ();
			}

			if ((fileP != NULL) && fileP->isEBook ())
			{
				fileP->deleteTitle ();
			}
		}
		
		Sleep (1000);
		OnViewRefresh ();
	}
}

void CFileListView::OnUpdateFileDeleteebook(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here

	CListCtrl& TheList = GetListCtrl();
	UINT uSelectedCount = TheList.GetSelectedCount();
	int  nItem = -1;
	rebFile * fileP;

	if (uSelectedCount > 0)
	{
		if (currMemType == TRE_INTMEM)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			if (nItem != -1)
			{		
				fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nItem));
				pCmdUI->Enable (fileP->isEBook ());
				return;
			}
		}
		else if (currMemType == TRE_TITLES)
		{
			pCmdUI->Enable (true);
			return;
		}
	}

	pCmdUI->Enable (false);
}

void CFileListView::OnViewRefresh()
{
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	// TODO: Add your command handler code here
	if ((currMemType == TRE_INTMEM) ||
		(currMemType == TRE_TITLES))
	{
		if ((m_currDirP == NULL) || (m_currDirP->getDir () == NULL))
		{
			pDoc->checkEBook (true, true);
			return;
		}
		else
		{
			m_currDirP->refresh ();
			pDoc->ebc.eBookGetTitles ();
			pDoc->ebc.eBookFixTitles (m_currDirP->getMemType());
  			refreshFileList ();
		}
	}
	
	pDoc->checkEBook (false, true);
}

void CFileListView::OnUpdateViewRefresh(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
    CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

	pCmdUI->Enable (pDoc->ebc.getConnState ());
}

//*****************************ONPREPAREPRINTING**********************
BOOL CFileListView::OnPreparePrinting(CPrintInfo* pInfo) 
{	
	// The third parameter expects a pointer to your list control
	CListCtrl& TheList = GetListCtrl();

	return lcp.OnPreparePrinting(pInfo, this, &TheList); //Guess the # of pages
}

//**************************ONBEGINGPRINTING********************
void CFileListView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{	
	// The title and date are CString references printed on each page
	CRebCommDoc* pDoc = GetDocument();
	// CMainFrame * mf_ptr = (CMainFrame *)AfxGetMainWnd();

	CTime time = CTime::GetCurrentTime();
	CString strDate = time.Format(_T("%A, %B %d, %y"));

	CString doc_title = pDoc->GetTitle();
	lcp.OnBeginPrinting(pDC, pInfo, doc_title, strDate);

	return;
}

//***********************ONPRINT**********************
void CFileListView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	lcp.OnPrint(pDC, pInfo);
	return;
}
	
//******************ONENDPRINTING************************
void CFileListView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
	lcp.OnEndPrinting(pDC, pInfo);//Clean up those printing fonts
	CListView::OnEndPrinting(pDC, pInfo);
	return;
}

void CFileListView::OnFilePrint()
{
	// TODO: Add your command handler code here
	CListView::OnFilePrint ();
}

void CFileListView::OnFilePrintPreview()
{
	// TODO: Add your command handler code here
	CListView::OnFilePrintPreview ();
}

void CFileListView::OnUpdateFilePrint(CCmdUI *pCmdUI)
{
	CRebCommDoc* pDoc = GetDocument();

	pCmdUI->Enable (pDoc->eBookUpF);
}

void CFileListView::OnUpdateFilePrintPreview(CCmdUI *pCmdUI)
{
	CRebCommDoc* pDoc = GetDocument();

	pCmdUI->Enable (pDoc->eBookUpF);
}

void CFileListView::OnFileProperties()
{
	// TODO: Add your command handler code here
	CListCtrl& TheList = GetListCtrl();
	UINT i, uSelectedCount = TheList.GetSelectedCount();
	int  nItem = -1;

	if (uSelectedCount > 0)
	{
		for (i=0, nItem=-1; i < uSelectedCount; i++)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			ASSERT(nItem != -1);
			showProps (nItem);
		}
	}
}

void CFileListView::OnUpdateFileProperties(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
	CListCtrl& TheList = GetListCtrl();
	UINT uSelectedCount = TheList.GetSelectedCount();
	pCmdUI->Enable ((uSelectedCount > 0) && 
		(currMemType != TRE_ROOT));
}

int CFileListView::OnToolHitTest(CPoint point, TOOLINFO* pTI) const
{
	// TODO: Add your specialized code here and/or call the base class
	CRect rect;

	if (!m_bShowTooltips)
		return -1;

	CListCtrl& TheList = GetListCtrl();
	GetClientRect(&rect);

	if(rect.PtInRect(point))
	{
		if(TheList.GetItemCount())
		{
			int nTopIndex = TheList.GetTopIndex();
			int nBottomIndex = nTopIndex + TheList.GetCountPerPage();
			if(nBottomIndex > TheList.GetItemCount()) nBottomIndex = TheList.GetItemCount();
			for(int nIndex = nTopIndex; nIndex <= nBottomIndex; nIndex++)
			{
				TheList.GetItemRect(nIndex, rect, LVIR_BOUNDS);
				if(rect.PtInRect(point))
				{
					pTI->hwnd = m_hWnd;
					pTI->uId = (UINT)(nIndex+1);
					pTI->lpszText = LPSTR_TEXTCALLBACK;
					pTI->rect = rect;
					return (int) pTI->uId;
				}
			}
		}
	}

	return -1;

	// return CListView::OnToolHitTest(point, pTI);
}

BOOL CFileListView::OnToolTipText(UINT id, NMHDR* pNMHDR, LRESULT* pResult)
{
	// I want to implement this in PreSubclassWindow(), but it crashes.
	CListCtrl& TheList = GetListCtrl();

	if(!m_bToolTipCtrlCustomizeDone)
	{
#ifdef NOTUSED
		_AFX_THREAD_STATE* pThreadState = AfxGetThreadState();
		CToolTipCtrl *pToolTip = pThreadState->m_pToolTip;
		// Set max tip width in pixel.
		// you can change delay time, tip text or background color also. enjoy yourself!
		pToolTip.SetMaxTipWidth(500);
#endif
		// This is useless here, need to do this every time we
		// change the tooltip text...
		// ::SendMessage(pNMHDR->hwndFrom, TTM_SETMAXTIPWIDTH, 0, 300);
		m_bToolTipCtrlCustomizeDone = TRUE;
	}

	// need to handle both ANSI and UNICODE versions of the message
	TOOLTIPTEXTA* pTTTA = (TOOLTIPTEXTA*)pNMHDR;
	TOOLTIPTEXTW* pTTTW = (TOOLTIPTEXTW*)pNMHDR;
	UINT nID = (UINT) pNMHDR->idFrom;

	if(nID == 0)	  	// Notification in NT from automatically
		return FALSE;   	// created tooltip

	int nItem = nID - 1;
	if (nItem > TheList.GetItemCount ())
		return FALSE;

	CString strTip;
	TCHAR buf[MAX_TIP_LENGTH+1];
	HDITEM hdCol;
	hdCol.mask = HDI_TEXT;
	hdCol.pszText = buf;
	hdCol.cchTextMax = MAX_TIP_LENGTH; 
	int nNumCol = m_ctlHeader.GetItemCount();
	for(int col=0; col<nNumCol; col++)
	{
		m_ctlHeader.GetItem(col, &hdCol);
		strTip += hdCol.pszText;
		strTip += _T(": ");
		strTip += TheList.GetItemText(nItem, col);
		if(col < nNumCol-1) strTip += _T("\r\n");
	}

	rebTitle * tP;
	rebFile  * fileP;

	if (currMemType == TRE_INTMEM)
	{
		fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nItem));
		tP = fileP->getTitle ();
		if (tP != NULL)
		{
			strTip += _T ("\r\n");
			strTip += _T ("Book Title: ");
			strTip += _T (tP->title);
			strTip += _T ("\r\n");
			strTip += _T ("Author: ");
			strTip += _T (tP->author);
		}
	}
	else if (currMemType == TRE_TITLES)
	{
		rebTitle * tP = reinterpret_cast<rebTitle *> (TheList.GetItemData (nItem));
		fileP = tP->getFile ();
		if (fileP != NULL)
		{
			strTip += _T ("\r\n");
			strTip += _T ("Filename: ");
			strTip += _T (tP->filename);
		}
	}
	
	::SendMessage(pNMHDR->hwndFrom, TTM_SETMAXTIPWIDTH, 0, 500);

#ifndef _UNICODE
	if(pNMHDR->code == TTN_NEEDTEXTA)
	{
		if(m_pchTip != NULL)
			delete m_pchTip;

		m_pchTip = new TCHAR[strTip.GetLength()+1];
		lstrcpyn(m_pchTip, strTip, strTip.GetLength() + 1);
		m_pchTip[strTip.GetLength()] = 0;
		pTTTW->lpszText = (WCHAR*)m_pchTip;
	}
	else
	{
		if(m_pwchTip != NULL)
			delete m_pwchTip;

		m_pwchTip = new WCHAR[strTip.GetLength()+1];
		// _mbstowcsz(m_pwchTip, strTip, strTip.GetLength());
		// m_pwchTip[strTip.GetLength()] = 0; // end of text

		MultiByteToWideChar (1251, 0, 
			strTip, -1,
			m_pwchTip, strTip.GetLength () + 1);

		pTTTW->lpszText = (WCHAR*)m_pwchTip;
	}
#else
	if(pNMHDR->code == TTN_NEEDTEXTA)
	{
		if(m_pchTip != NULL)
			delete m_pchTip;

		m_pchTip = new TCHAR[strTip.GetLength()+1];
		_wcstombsz(m_pchTip, strTip, strTip.GetLength());
		m_pchTip[strTip.GetLength()] = 0; // end of text
		pTTTA->lpszText = (LPTSTR)m_pchTip;
	}
	else
	{
		if(m_pwchTip != NULL)
			delete m_pwchTip;

		m_pwchTip = new WCHAR[strTip.GetLength()+1];
		lstrcpyn(m_pwchTip, strTip, strTip.GetLength() + 1);
		m_pwchTip[strTip.GetLength()] = 0;
		pTTTA->lpszText = (LPTSTR) m_pwchTip;
	}
#endif

	*pResult = 0;

	return TRUE;    // message was handled
}

void CFileListView::OnViewShowtooltips()
{
	// TODO: Add your command handler code here
	m_bShowTooltips = !m_bShowTooltips;
}

void CFileListView::OnUpdateViewShowtooltips(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable ();
	pCmdUI->SetCheck (m_bShowTooltips);
}

void CFileListView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	int nIndex = itemHitTest (point);

	if (nIndex >= 0)
	{
		if (currMemType == TRE_INTMEM)
		{
			rebFile * fileP = NULL;
			CListCtrl& TheList = GetListCtrl();
			fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nIndex));
			if (fileP->isDirectory ())
			{
				CRebCommDoc* pDoc = (CRebCommDoc*) GetDocument();

				if (pDoc->getTreeView ())
				{
					pDoc->getTreeView ()->forceSelection ((rebDirectory *) fileP);
					return;
				}
			}
		}

		showProps (nIndex);
		return;
	}

	CListView::OnLButtonDblClk(nFlags, point);
}

void CFileListView::showProps(int nItem)
{
	rebFile * fileP = NULL;
	rebTitle * titleP = NULL;
	CListCtrl& TheList = GetListCtrl();

	if (nItem != -1)
	{		
		if (currMemType == TRE_INTMEM)
		{
			fileP = reinterpret_cast<rebFile *> (TheList.GetItemData (nItem));
		}
		else if (currMemType == TRE_TITLES)
		{
			titleP = reinterpret_cast<rebTitle *> (TheList.GetItemData (nItem));
			fileP = titleP->getFile ();
		}
	}

	if (fileP != NULL)
	{
		char szTemp[MAX_PATH];

		CPropertySheet dlgFileProps (fileP->getLnName (), this,
			(currMemType == TRE_TITLES) ? 1 : 0);

		CFilePropPage  fileProps;
		CTitlePropPage titleProps;

		dlgFileProps.AddPage (&fileProps);
		dlgFileProps.AddPage (&titleProps);

		fileProps.sFileType = "Reb eBook";
		if (fileP->getExten () && (fileP->getExten ()[0] != '\0'))
			fileProps.sShortName.Format ("%s.%s", 
				fileP->getShName (),
				fileP->getExten ());
		else
			fileProps.sShortName = fileP->getShName ();

		if (fileP->getLnName()[0])
			fileProps.sFileName = fileP->getLnName ();
		else
			fileProps.sFileName = fileProps.sShortName;

		fileProps.sLocation = fileP->getDir ()->makePath (szTemp);
		fileProps.sSize.Format ("%s B", niceFormatInt (fileP->getSz ()));
		if (strchr (fileP->getAttr (), 'A'))
			fileProps.bIsArch = TRUE;
		if (strchr (fileP->getAttr (), 'H'))
			fileProps.bIsHidden = TRUE;
		if (strchr (fileP->getAttr (), 'D'))
			fileProps.bIsDir = TRUE;
		if (strchr (fileP->getAttr (), 'R'))
			fileProps.bIsReadOnly = TRUE;
		if (strchr (fileP->getAttr (), 'S'))
			fileProps.bIsSys = TRUE;

		if (titleP = fileP->getTitle ())
		{
			titleProps.sTitle     = titleP->title;
			titleProps.sAuthor    = titleP->author;
			titleProps.sISBN      = titleP->isbn;
			titleProps.sURL       = titleP->url;
			titleProps.sPublisher = titleP->publisher;
			titleProps.sFilename  = titleP->filename;
			titleProps.bAnno      = titleP->anno;
			titleProps.sUser      = titleP->username;
			titleProps.sSize.Format ("%s B", niceFormatInt (titleP->size));
		}

		dlgFileProps.DoModal ();
		return;
	}
}

int CFileListView::itemHitTest(CPoint point)
{
	CRect rect;

	CListCtrl& TheList = GetListCtrl();
	GetClientRect(&rect);

	if(rect.PtInRect(point))
	{
		if(TheList.GetItemCount())
		{
			int nTopIndex = TheList.GetTopIndex();
			int nBottomIndex = nTopIndex + TheList.GetCountPerPage();
			if(nBottomIndex > TheList.GetItemCount()) 
				nBottomIndex = TheList.GetItemCount();
			for(int nIndex = nTopIndex; nIndex <= nBottomIndex; nIndex++)
			{
				TheList.GetItemRect(nIndex, rect, LVIR_BOUNDS);
				if(rect.PtInRect(point))
				{
					return nIndex;
				}
			}
		}
	}
	
	return -1;
}

void CFileListView::OnViewShowgridlines()
{
	// TODO: Add your command handler code here
	CListCtrl& TheList = GetListCtrl();
static TCHAR BASED_CODE szSection[] = _T("Settings");
static TCHAR BASED_CODE szWindowPos[] = _T("WindowPos");

	TheList.SetExtendedStyle(TheList.GetExtendedStyle() ^ LVS_EX_GRIDLINES );
}

void CFileListView::OnUpdateViewShowgridlines(CCmdUI *pCmdUI)
{
	// TODO: Add your command update UI handler code here
	CListCtrl& TheList = GetListCtrl();

	pCmdUI->Enable ();
	pCmdUI->SetCheck ((TheList.GetExtendedStyle() & LVS_EX_GRIDLINES) != 0);
}

void CFileListView::saveSettings(bool)
{
	CWinApp * appP = AfxGetApp ();
	TCHAR BASED_CODE szSection[] = _T("Settings");
	TCHAR BASED_CODE * szParam;
	CListCtrl& TheList = GetListCtrl();

	szParam = _T("Gridlines");

	appP->WriteProfileInt (szSection, szParam, 
		((TheList.GetExtendedStyle() & LVS_EX_GRIDLINES) != 0));

	szParam = _T("Titles");

	appP->WriteProfileInt (szSection, szParam, (currMemType == TRE_TITLES));

}

void CFileListView::OnLvnBegindrag(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	CListCtrl& TheList = GetListCtrl();
	COleDataSource datasrc;
	HGLOBAL        hgDrop;
	DROPFILES*     pDrop;
	CStringList    lsDraggedFiles;
	POSITION       pos;
	UINT           uBuffSize = 0;
	TCHAR*         pszBuff;
	FORMATETC      etc = { CF_HDROP, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL };

    *pResult = 0;   // return value ignored

    // For every selected item in the list, put the filename into lsDraggedFiles.

	CString fileName;
	UINT i, uSelectedCount = TheList.GetSelectedCount();
	int  nItem;
	LPARAM  lParam;
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;
	rebFile * fileP;
	HANDLE hPcFile;

	// Update all of the selected items.
	if (uSelectedCount > 0)
	{
		for (i=0, nItem=-1; i < uSelectedCount; i++)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			ASSERT(nItem != -1);
			lParam = TheList.GetItemData (nItem);
			fileP = NULL;
			
			switch (currMemType) {
				case TRE_INTMEM:
                    fileP = reinterpret_cast<rebFile *> (lParam);
					break;

				case TRE_TITLES:
					fileP = (reinterpret_cast<rebTitle *> (lParam))->getFile();
					break;
			}

			if (fileP == NULL)
				continue;

			fileName.GetEnvironmentVariable("TEMP");
			fileName += "\\";
			fileName += fileP->getLnName ();

			hPcFile       = CreateFile (fileName,
										GENERIC_WRITE,
										FILE_SHARE_READ,
										NULL,
										CREATE_ALWAYS,
										FILE_ATTRIBUTE_NORMAL,
										NULL);

			if (hPcFile != INVALID_HANDLE_VALUE)
			{
				lsDraggedFiles.AddTail ( fileName );

				// Calculate the # of chars required to hold this string.

				uBuffSize += lstrlen ( fileName ) + 1;

				CloseHandle (hPcFile);
			}
		}
	}
	else
		return;

    // Add 1 extra for the final null char, and the size of the DROPFILES struct.

    uBuffSize = sizeof(DROPFILES) + sizeof(TCHAR) * (uBuffSize + 1);

    // Allocate memory from the heap for the DROPFILES struct.

    hgDrop = GlobalAlloc ( GHND | GMEM_SHARE, uBuffSize );

    if ( NULL == hgDrop )
        return;

    pDrop = (DROPFILES*) GlobalLock ( hgDrop );

    if ( NULL == pDrop )
    {
        GlobalFree ( hgDrop );
        return;
    }

    // Fill in the DROPFILES struct.

    pDrop->pFiles = sizeof(DROPFILES);

#ifdef _UNICODE
    // If we're compiling for Unicode, set the Unicode flag in the struct to
    // indicate it contains Unicode strings.

    pDrop->fWide = TRUE;
#endif

    // Copy all the filenames into memory after the end of the DROPFILES struct.

    pos = lsDraggedFiles.GetHeadPosition();
    pszBuff = (TCHAR*) (LPBYTE(pDrop) + sizeof(DROPFILES));

    while ( NULL != pos )
    {
        lstrcpy ( pszBuff, (LPCTSTR) lsDraggedFiles.GetNext ( pos ) );
        pszBuff = 1 + _tcschr ( pszBuff, '\0' );
    }

    GlobalUnlock ( hgDrop );

    // Put the data in the data source.

    datasrc.CacheGlobalData ( CF_HDROP, hgDrop, &etc );

    // Add in our own custom data, so we know that the drag originated from our 
    // window.  OnDragEnter() checks for this custom format, and
    // doesn't allow the drop if it's present.  This is how we prevent the user
    // from dragging and then dropping in our own window.
    // The data will just be a dummy bool.
	HGLOBAL hgBool;

    hgBool = GlobalAlloc ( GHND | GMEM_SHARE, sizeof(bool) );

    if ( NULL == hgBool )
    {
        GlobalFree ( hgDrop );
        return;
    }

    // Put the data in the data source.

    etc.cfFormat = g_uCustomClipbrdFormat;
    
    datasrc.CacheGlobalData ( g_uCustomClipbrdFormat, hgBool, &etc );


    // Start the drag 'n' drop!
	CMyOleDropSource   myDropSource;
	myDropSource.listViewP = this;

	DROPEFFECT dwEffect = datasrc.DoDragDrop ( DROPEFFECT_COPY, 0, 
		&myDropSource );

    // If the DnD completed OK, we remove all of the dragged items from our
    // list.

    switch ( dwEffect )
    {
        case DROPEFFECT_NONE:
			// The DnD operation wasn't accepted, or was canceled, so we 
            // should call GlobalFree() to clean up.
            GlobalFree ( hgDrop );
            GlobalFree ( hgBool );
			// Fall thru...

		case DROPEFFECT_COPY:
        case DROPEFFECT_MOVE:
            // This needs special handling, because on NT, DROPEFFECT_NONE
            // is returned for move operations, instead of DROPEFFECT_MOVE.
            // See Q182219 for the details.
            // So if we're on NT, we check each selected item, and if the
            // file no longer exists, it was moved successfully and we can
            // remove it from the list.

			for (i=0, nItem=-1; i < uSelectedCount; i++)
			{
				nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
				ASSERT(nItem != -1);
				lParam = TheList.GetItemData (nItem);
				fileP = NULL;
				
				switch (currMemType) {
					case TRE_INTMEM:
						fileP = reinterpret_cast<rebFile *> (lParam);
						break;

					case TRE_TITLES:
						fileP = (reinterpret_cast<rebTitle *> (lParam))->getFile();
						break;
				}

				if (fileP == NULL)
					continue;

				fileName.GetEnvironmentVariable("TEMP");
				fileName += "\\";
				fileName += fileP->getLnName ();

				DeleteFile (fileName);
            }   // end for all selected
			break;  // end case DROPEFFECT_NONE
    }   // end switch

}

SCODE CMyOleDropSource::GiveFeedback(DROPEFFECT dropEffect)
{
	m_dwLastEffect = dropEffect;
	
	return COleDropSource::GiveFeedback(dropEffect);
}

SCODE CMyOleDropSource::QueryContinueDrag(BOOL bEscapePressed, DWORD dwKeyState)
{
    // If ESC was pressed, cancel the drag. If the left button was released,
    // do the drop.
    if ( bEscapePressed )
        return DRAGDROP_S_CANCEL;
    else if ( !(dwKeyState & MK_LBUTTON) )
    {
        // If the last effect returned was NONE, then we don't do anything
        // here because the target rejected the drag.
        if ( DROPEFFECT_NONE == m_dwLastEffect )
            return DRAGDROP_S_CANCEL;
 
        // ......
        // Actually do the file copying here, so that when we return, the files
        // are in the temp dir & ready for Explorer to copy.
        // ......
		listViewP->SaveSelectedToTemp ();
 
        return DRAGDROP_S_DROP;
    }
    else
        return S_OK;
	// TODO: Add your specialized code here and/or call the base class

	return COleDropSource::QueryContinueDrag(bEscapePressed, dwKeyState);
}

// Save all selected file to TEMP
int CFileListView::SaveSelectedToTemp(void)
{
	CListCtrl& TheList = GetListCtrl();
	CString fileName;
	UINT i, uSelectedCount = TheList.GetSelectedCount();
	int  nItem;
	LPARAM  lParam;
	CMainFrame * pMainFrame = (CMainFrame *) AfxGetApp ()->m_pMainWnd;
	rebFile * fileP;

	// Update all of the selected items.
	if (uSelectedCount > 0)
	{
		CWaitCursor waiting;

		for (i=0, nItem=-1; i < uSelectedCount; i++)
		{
			nItem = TheList.GetNextItem(nItem, LVNI_SELECTED);
			ASSERT(nItem != -1);
			lParam = TheList.GetItemData (nItem);
			fileP = NULL;
			
			switch (currMemType) {
				case TRE_INTMEM:
                    fileP = reinterpret_cast<rebFile *> (lParam);
					break;

				case TRE_TITLES:
					fileP = (reinterpret_cast<rebTitle *> (lParam))->getFile();
					break;
			}

			if (fileP == NULL)
				continue;

			fileName.GetEnvironmentVariable("TEMP");
			fileName += "\\";
			fileName += fileP->getLnName ();

            {
				const char * tempPtr = (LPCTSTR) fileName;

				pMainFrame->stBar ()->SavePane(0);
				pMainFrame->stBar ()->SetMode(0, XSB_PROGRESS);
				pMainFrame->stBar ()->SetRange(0, 0, 100);
				fileP->readFile (tempPtr, showProgress);
				Sleep (100);
				pMainFrame->stBar ()->RestorePane(0);
            }
		}
	}
	return 0;
}
