#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}

debug_logfile=${ksmuser}/H2OEd2rotation_$(date +%Y%m%d_%H%M%S).txt
echo "PRODUCT: $PRODUCT" >> ${debug_logfile}
echo "PRODUCT_ID: $PRODUCT_ID" >> ${debug_logfile}
echo "rotation: $(cat /sys/class/graphics/fb0/rotate)" >> ${debug_logfile}
echo "$(fbset)" >> ${debug_logfile}

for i in 0 1 2 3 0 1 2 3
do
  echo "$i" > /sys/class/graphics/fb0/rotate
  value1=$(cat /sys/class/graphics/fb0/rotate)
  cat /sys/class/graphics/fb0/rotate > /sys/class/graphics/fb0/rotate
  value2=$(cat /sys/class/graphics/fb0/rotate)
  echo "------------ loop ${i} ----------" >> ${debug_logfile}
  echo "value1: ${value1}, value2: ${value2}"  >> ${debug_logfile}
  echo "$(fbset)" >> ${debug_logfile}

  moptions="-autoselectafter=7 -autoselectoption=auto correct"
  binfo="${i}:${value1}:${value2}"
  selection=$($ksmroot/kobomenu.sh -infolines=3 "-infotext=${binfo}" ${moptions})
  value3=$(cat /sys/class/graphics/fb0/rotate)
  echo "value3: ${value3}"  >> ${debug_logfile}
  echo "$(fbset)" >> ${debug_logfile}
  [ "${selection}" != "auto" ] && break
done

sync
