#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}
ksmFontDir=$ksmroot/fonts

export ksmroot
export ksmuser

configureKSM() {
  KSMdebugmode=false
  duringPWcheckActivate=
  dontTamperwithFrontlight=true
  nickelpreload=
  avoidPickel=false
  frontlightOnLevel=4
  insertCRportrait=false
  insertCRlandscape=false
  combineCoolreaderAdditions=false
  insertNickelKoreaderSwitch=true
  insertKoreaderNickelSwitch=true
  selectKoreaderVersion=true
  combineKoreaderAdditions=true
  deleteSDRsOnboard=false
  enablerotation=false
  preventfreeze=true
  useDropbear=true
  useMultiplefonts=true
  kobomenuShowClock=false
  poweroffRandomdir=
  poweroffRotation=90
  provideSleepInMainMenu=false
  suppressEntries=
  mrotation=90


  case $PRODUCT in
    phoenix )
      ksmGeometryValuesN=758x1012+0+0
      ksmGeometryValuesS=758x1012+0+11
      ksmGeometryValuesE=1012x758+0+0
      ksmGeometryValuesW=1012x758+11+0
      ;;
    dahlia )
      ksmGeometryValuesN=1080x1429+0+11
      ksmGeometryValuesS=1080x1429+0+0
      ksmGeometryValuesE=1429x1080+11+0
      ksmGeometryValuesW=1429x1080+0+0
      ;;
    * )
      ksmGeometryValuesN=
      ksmGeometryValuesS=
      ksmGeometryValuesE=
      ksmGeometryValuesW=
      ;;
  esac

  case $PRODUCT in
    kraken)
      ksmImageWidthPortrait=724
      ksmImageWidthLandscape=800
      ;;
    phoenix)
      ksmImageWidthPortrait=714
      ksmImageWidthLandscape=790
      ;;
    dragon)
      ksmImageWidthPortrait=1040
      ksmImageWidthLandscape=1384
      ;;
    dahlia)
      ksmImageWidthPortrait=1040
      ksmImageWidthLandscape=1384
      ;;
    *)
      ksmImageWidthPortrait=566
      ksmImageWidthLandscape=750
      ;;
  esac

  case $PRODUCT in
    kraken)
      kobomenuFontsize=40
      kobomenuMenuBarFontsize=35
      ;;
    phoenix)
      kobomenuFontsize=40
      kobomenuMenuBarFontsize=35
      ;;
    star)
      kobomenuFontsize=40
      kobomenuMenuBarFontsize=35
      ;;
    dragon)
      kobomenuFontsize=50
      kobomenuMenuBarFontsize=40
      ;;
    daylight)
      kobomenuFontsize=64
      kobomenuMenuBarFontsize=50
      ;;
    dahlia)
      kobomenuFontsize=55
      kobomenuMenuBarFontsize=45
      ;;
    alyssum)
      kobomenuFontsize=60
      kobomenuMenuBarFontsize=50
      ;;
    *)
      kobomenuFontsize=35
      kobomenuMenuBarFontsize=25
      ;;
  esac

  configfile=$ksmroot/ksm_ini
  if [ -e $configfile ]; then
    while read p; do
      p="${p#"${p%%[![:space:]]*}"}"
      case "$p" in
        [*|export*|'#'* ) ;;
        *=|*=* )
          eval "$p" > /dev/null 2>&1
          ;;
      esac
    done <$configfile
  elif [ -f "${configfile}_template" ]; then
    cp "${configfile}_template" "$configfile"
  fi

  if [ "$insertCRportrait" != "true" ] && [ "$insertCRlandscape" != "true" ]; then
    combineCoolreaderAdditions=false
  fi

  export kobomenuFontsize
  export kobomenuMenuBarFontsize
  export ksmImageWidthPortrait
  export ksmImageWidthLandscape
  export ksmGeometryValuesN
  export ksmGeometryValuesS
  export ksmGeometryValuesE
  export ksmGeometryValuesW
  export KSMdebugmode
  export dontTamperwithFrontlight
  export nickelpreload
  export deleteSDRsOnboard
  export avoidPickel
  export kobomenuShowClock
  export poweroffRandomdir
  export poweroffRotation
  export useDropbear
  export provideSleepInMainMenu
  export mrotation

  if [ "$useMultiplefonts" == "true" ]; then
    export QWS_NO_SHARE_FONTS=1
  else
    export QWS_NO_SHARE_FONTS=0
  fi
### select font dir: begin
  fonttestdirs="$ksmFontDir \
  $ksmuser/fonts \
  $ksmroot/fonts"

  containsfont() {
    local result
    result="false"
    [ -d "$1" ] || exit
    for f in $(find "$1" -type f -maxdepth 1 -iname "*.ttf" -o -iname "*.otf" -o -iname "*.ttc")
    do
      result="true"
      break
    done
    echo $result
  }

  for dir in $fonttestdirs
  do
    if [ "$(containsfont "$dir")" == "true" ]; then
      ksmFontDir="$dir"
      break
    fi
  done

  export ksmFontDir
### select font dir: end
  [ "x${suppressEntries}" != "x" ] && showFull="false" || showFull="true"
}

frontlightprg=$ksmroot/tools/frontlight
export KSMfrontlightlevel=0
installUpdate="TRUE"
preserveRcS="FALSE"
isFirstRun="TRUE"
startwithlighton=false
# switch off leds begin
echo "ch 4" > /sys/devices/platform/pmic_light.1/lit
echo "cur 0" > /sys/devices/platform/pmic_light.1/lit
echo "dc 0" > /sys/devices/platform/pmic_light.1/lit
#switch off leds end

modelnr=$($ksmroot/onstart/getmodelnr.sh)
case $modelnr in
  310 ) PRODUCT_ID=0x4163;;
  320 ) PRODUCT_ID=0x4163;;
  330 ) PRODUCT_ID=0x4173;;
  340 ) PRODUCT_ID=0x4183;;
  350 ) PRODUCT_ID=0x4193;;
  360 ) PRODUCT_ID=0x4203;;
  370 ) PRODUCT_ID=0x4213;;
  371 ) PRODUCT_ID=0x4223;;
  372 ) PRODUCT_ID=0x4224;;
  373 ) PRODUCT_ID=0x4225;;
  374 ) PRODUCT_ID=0x4227;;
  375 ) PRODUCT_ID=0x4226;;
  * ) PRODUCT_ID=unknown;;
esac
export PRODUCT_ID

###
rotationtestscript=${ksmuser}/scripts/rotationtest.sh
ksmAutoselectafter=5
ksmAutoselectoption=runrotationtest
moptions="-autoselectafter=$ksmAutoselectafter -autoselectoption=$ksmAutoselectoption skip_test"
selection=$($ksmroot/kobomenu.sh $moptions)
[ "${selection}" != "skip_test" ] && ${rotationtestscript}
###





configureKSM

 

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=$ksmroot/log/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "script path: $0" >> $debug_logfile
  echo "ksmroot: $ksmroot" >> $debug_logfile
  echo "ksmFontDir: $ksmFontDir" >> $debug_logfile
  echo "PRODUCT: $PRODUCT" >> $debug_logfile
  echo "PRODUCT_ID: $PRODUCT_ID" >> $debug_logfile
  echo "ksmGeometryValuesN: $ksmGeometryValuesN"  >> $debug_logfile
  echo "ksmGeometryValuesE: $ksmGeometryValuesE"  >> $debug_logfile
  echo "ksmGeometryValuesS: $ksmGeometryValuesS"  >> $debug_logfile
  echo "ksmGeometryValuesW: $ksmGeometryValuesW"  >> $debug_logfile
  sync
fi


if [ "$KSMdebugmode" == "true" ]; then
  fbrotatevalue=$(cat /sys/class/graphics/fb0/rotate)
  echo "fbrotatevalue before dragon-dahlia special: $fbrotatevalue" >> $debug_logfile
fi

#if [ "$PRODUCT" == "dragon" ] || [ "$PRODUCT" == "dahlia" ] || [ "$PRODUCT" == "snow" ]; then
$ksmroot/kobomenu.sh -autoselectafter=0
touch /tmp/pngshow_rotation_hack_disable
#else
# touch /tmp/pngshow_rotation_hack_enable
#fi

fbrotatevalue=$(cat /sys/class/graphics/fb0/rotate)
[ "$KSMdebugmode" == "true" ] && echo "fbrotatevalue after dragon-dahlia special: $fbrotatevalue" >> $debug_logfile


export fbrotatevalue

if [ "$preventfreeze" == "true" ]; then
  $ksmroot/onstart/preventfreeze.sh &
fi

if [ "$startwithlighton" == "true" ]; then
  $frontlightprg "$frontlightOnLevel"
  export KSMfrontlightlevel=$frontlightOnLevel
fi



pwfile="$ksmroot/kbbouncer/bouncerpw.txt"
if [ -e $pwfile ] && [ "$($ksmroot/onstart/checkbouncerinstall.sh)" == "ok" ]; then
  case $duringPWcheckActivate in
    usb )
      [ "$KSMdebugmode" == "true" ] && echo "password check: call $ksmroot/scripts_intern/usb/usb_enable.sh" >> $debug_logfile
      $ksmroot/scripts_intern/usb/usb_enable.sh
      ;;
    usbnet )
      [ "$KSMdebugmode" == "true" ] && echo "password check: call $ksmroot/scripts_intern/usb/usbnet_toggle.sh" >> $debug_logfile
      $ksmroot/scripts_intern/usb/usbnet_toggle.sh
      ;;
  esac
  export KBBouncerMode=
  bouncer=$ksmroot/kbbouncer/kbbouncer.sh
  pw=$(cat $pwfile)
  answer=""
  pwcount=0
  while [ "$answer" != "passed" ] && [ $pwcount -lt 3 ]; do
    answer=$($bouncer "$pw")
    let pwcount++
  done
  if [ "$answer" == "failed" ]; then
    $ksmroot/onstart/poweroff.sh
  fi
  case $duringPWcheckActivate in
    usb )
      $ksmroot/scripts_intern/usb/usb_disable.sh
      ;;
    usbnet )
      $ksmroot/scripts_intern/usb/usbnet_toggle.sh
      ;;
  esac
fi


setKSMupdateoptions() {
  mksmupdateoptions="info:help.png"
  for f in $(find $ksmuser -name "KSM*.zip")
  do
    mksmupdateoptions="$mksmupdateoptions install_KSM_update:execute.png"
    mksmupdateoptions="$mksmupdateoptions delete_KSM_update:execute.png"
    [ "$KSMdebugmode" == "true" ] && echo "available KSM update package: $f" >> $debug_logfile
    break
  done
  mksmupdateoptions="$mksmupdateoptions show_KSM_update_history:help.png"
  mksmupdateoptions="$mksmupdateoptions return"
}

addMenuEntryStringIfWished() {
  local menuEntryString=$1
  local menuEntry="+${menuEntryString%:*}+"
  if  [ ${showFull} == "true" ] || [ "x${suppressEntries#*$menuEntry}" == "x${suppressEntries}" ]; then
    moptions="${moptions} ${menuEntryString}"
  fi
}


setoptions() {
  moptions=""
  if [ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ] && [ $PRODUCT != pika ]; then
    addMenuEntryStringIfWished "front_light_on:execute.png"
    addMenuEntryStringIfWished "front_light_off:execute.png"
  fi

  addMenuEntryStringIfWished "info:help.png"

  if [ "$enablerotation" == "true" ]; then
    addMenuEntryStringIfWished "toggle_rotation:toggle.png"
  fi

#####
  for f in $(find $ksmuser -name "KSM*.zip")
  do
    moptions="$moptions handle_KSM_update:gear.png"
    [ "$KSMdebugmode" == "true" ] && echo "available KSM update package: $f" >> $debug_logfile
    break
  done
#####


#####
  mupdateoptions=""
  if [ -e /mnt/onboard/.kobo/Kobo.tgz ] || [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
    installUpdate="FALSE"
    moptions="$moptions handle_update:gear.png "
    mupdateoptions="$mupdateoptions info:help.png"
    if [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
      mupdateoptions="$mupdateoptions install_partial_update:execute.png"
    fi
    mupdateoptions="$mupdateoptions install_update:execute.png"
    mupdateoptions="$mupdateoptions delete_update:execute.png"
    mupdateoptions="$mupdateoptions return"
  fi
#####
  if [ -d /mnt/onboard/.kobo ]; then
    addMenuEntryStringIfWished "start_nickel:book.png"
  fi

  koreaderbasedir=
  if [ -e /mnt/onboard/.adds/koreader/reader.lua ]; then
    koreaderbasedir=/mnt/onboard/.adds
  elif [ -e /mnt/onboard/.kobo/koreader/reader.lua ]; then
    koreaderbasedir=/mnt/onboard/.kobo
  fi
  export koreaderbasedir
  if [ "$koreaderbasedir" != "" ]; then
    addMenuEntryStringIfWished "start_koreader:book.png"
    if  [ "$combineKoreaderAdditions" == "true" ]; then
      KoreaderAdditionsmoptions=
      [ "$insertNickelKoreaderSwitch" == "true" ] && KoreaderAdditionsmoptions="$mKoreaderAdditionsmoptions start_nickel_koreader_switch:book.png"
      [ "$insertKoreaderNickelSwitch" == "true" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions start_koreader_nickel_switch:book.png"
      [ "$selectKoreaderVersion" == "true" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions select_koreader_version:menu.png"
      [ -d "$ksmroot/koreaderfindsh" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions find_and_open:menu.png"
      KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions return:arrowup.png"
      addMenuEntryStringIfWished "koreader_additions:menu.png"
    else
      [ "$insertNickelKoreaderSwitch" == "true" ] && addMenuEntryStringIfWished "start_nickel_koreader_switch:book.png"
      [ "$insertKoreaderNickelSwitch" == "true" ] && addMenuEntryStringIfWished "start_koreader_nickel_switch:book.png"
      [ "$selectKoreaderVersion" == "true" ] && addMenuEntryStringIfWished "select_koreader_version:menu.png"
      [ -d "$ksmroot/koreaderfindsh" ] && addMenuEntryStringIfWished "find_and_open:menu.png"
    fi
  fi
  if [ -e /mnt/onboard/.kobo/KoboLauncher/launcher ]; then
    addMenuEntryStringIfWished "start_kobolauncher:rocket.png"
  fi

  vlasovsoftbasedir=
  if [ -e /mnt/onboard/.adds/vlasovsoft/launcher ]; then
    vlasovsoftbasedir=/mnt/onboard/.adds/vlasovsoft
  elif [ -e /mnt/onboard/.kobo/vlasovsoft/launcher ]; then
    vlasovsoftbasedir=/mnt/onboard/.kobo/vlasovsoft
  fi
  export vlasovsoftbasedir

  if [ "$vlasovsoftbasedir" != "" ]; then
    addMenuEntryStringIfWished "start_vlasovsoftlauncher:rocket.png"
    if  [ "$combineCoolreaderAdditions" == "true" ]; then
      CoolreaderAdditionsmoptions=
      [ "$insertCRportrait" == "true" ] && CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions start_coolreader:book.png"
      [ "$insertCRlandscape" == "true" ] && CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions start_coolreader_ls:book.png"
      CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions return:arrowup.png"
      addMenuEntryStringIfWished "coolreader:menu.png"
    else
      [ "$insertCRportrait" == "true" ] && addMenuEntryStringIfWished "start_coolreader:book.png"
      [ "$insertCRlandscape" == "true" ] && addMenuEntryStringIfWished "start_coolreader_ls:book.png"
    fi
  fi

  addMenuEntryStringIfWished "usb:usb.png"
  addMenuEntryStringIfWished "wifi:wifi.png"
  addMenuEntryStringIfWished "configure:gear.png"
  addMenuEntryStringIfWished "tools:menu.png"
  addMenuEntryStringIfWished "scripts:menu.png"

  [ -e "$ksmuser/scripts" ] && addMenuEntryStringIfWished "user_scripts:menu.png"
  [ "$provideSleepInMainMenu" == "true" ] &&addMenuEntryStringIfWished "sleep:moon.png"


  [ "x${suppressEntries}" != "x" ] && moptions="$moptions toggle_btw_full_and_short_menu:toggle.png"
  addMenuEntryStringIfWished "reboot:restart.png"
  addMenuEntryStringIfWished "power_off:poweroff.png"

  if [ "$ksmroot" != "/adds/kbmenu" ]; then
    moptions="$moptions exit_to_calling_KSM:arrowup.png"
  fi
}

(
if [ "$avoidPickel" != "true" ]; then
  /usr/local/Kobo/pickel disable.rtc.alarm
fi
echo 1 > /sys/devices/platform/mxc_dvfs_core.0/enable
/sbin/hwclock -s -u
) &


[ "$KSMdebugmode" == "true" ] && sync
#mrotation="90"
#export mrotation
udevadm trigger

#---- do the menu loop
selection=""
while [ "$selection" != "EXIT" ]; do
  setoptions
  if [ "$isFirstRun" == "TRUE" ] && [ "$ksmAutoselectoption" != "" ] && [ "$ksmAutoselectoption" != "reboot" ] && [ "$ksmAutoselectoption" != "power_off" ]; then
    moptions="-autoselectafter=$ksmAutoselectafter -autoselectoption=$ksmAutoselectoption $moptions"
    isFirstRun="FALSE"
  fi
  selection=$($ksmroot/kobomenu.sh $moptions)
  case $selection in
    exit_to_calling_KSM )
      exit;
      ;;
    info )
      $ksmroot/kbmessage.sh "-f $ksmuser/txt/start_info.html"
      ;;
    handle_update )
      binfo="capacity: `cat /sys/devices/platform/pmic_battery.1/power_supply/mc13892_bat/capacity`"
      binfo=${binfo// /_}
      updateselection=$($ksmroot/kobomenu.sh -infolines=1 "-infotext=$binfo" $mupdateoptions)
      case $updateselection in
        info )
          $ksmroot/kbmessage.sh "-f $ksmuser/txt/update_info.txt"
          ;;
        install_update )
          installUpdate="TRUE"
          preserveRcS="FALSE"
          selection="EXIT"
          ;;
        install_partial_update )
          installUpdate="TRUE"
          preserveRcS="TRUE"
          selection="EXIT"
          ;;
        delete_update )
          rm -f /mnt/onboard/.kobo/KoboRoot.tgz
          rm -f /mnt/onboard/.kobo/Kobo.tgz
          rm -rf /mnt/onboard/.kobo/upgrade
          rm -f /mnt/onboard/manifest.md5sum
          ;;
        return )
          updateselection=""
          ;;
      esac
      ;;
##
    handle_KSM_update )
      ksmupdateselection=""
      binfo="capacity: `cat /sys/devices/platform/pmic_battery.1/power_supply/mc13892_bat/capacity`"
      while [ "$ksmupdateselection" != "EXIT" ]; do
        setKSMupdateoptions
        binfo=${binfo// /_}
        ksmupdateselection=$($ksmroot/kobomenu.sh -infolines=1 "-infotext=$binfo" $mksmupdateoptions)
        case $ksmupdateselection in
          info )
            $ksmroot/kbmessage.sh "-f $ksmroot/scripts_intern/ksmupdate/info.txt"
            ;;
          install_KSM_update )
            binfo=$($ksmroot/scripts_intern/ksmupdate/installupdates.sh)
            ;;
          delete_KSM_update )
            rm -f "$ksmuser"/KSM*.zip
            ;;
          show_KSM_update_history )
            $ksmroot/kbmessage.sh "-f $ksmroot/updatehistory.txt"
            ;;
          return )
            ksmupdateselection="EXIT"
            ;;
        esac
      done
      ;;
##
    toggle_btw_full_and_short_menu )
      [ "x${showFull}" == "xtrue" ] && showFull="false" || showFull="true"
      ;;
    toggle_rotation )
      if [ "$mrotation" == "0" ]; then
        mrotation="90"
      elif [ "$mrotation" == "90" ]; then
        mrotation="180"
      elif [ "$mrotation" == "180" ]; then
        mrotation="270"
      elif [ "$mrotation" == "270" ]; then
        mrotation="0"
      fi
      export mrotation
      ;;
    start_nickel )
      $ksmroot/onstart/start_nickel.sh
      ;;
    power_off )
      $ksmroot/onstart/poweroff.sh
      ;;
    sleep )
      $ksmroot/onstart/suspend.sh
      ;;
    reboot )
      reboot
      ;;
    usb )
      $ksmroot/onstart/scriptmenuusb.sh $ksmroot/scripts_intern/usb
      ;;
    wifi )
      $ksmroot/onstart/scriptmenuwifi.sh $ksmroot/scripts_intern/wifi
      ;;
    configure )
      confresp=$($ksmroot/kbconfsel.sh $ksmroot/ksm_ini -optionsfile=$ksmuser/confoptions/ksm_ini_options.txt)
      if  [ "$confresp" == "saved" ]; then
        configureKSM
      fi
      ;;
    tools )
      $ksmroot/helpers/list_shscripts.msh $ksmroot/scripts_intern/tools
      ;;
    scripts )
      $ksmroot/helpers/list_shscripts.msh $ksmroot/scripts
      ;;
    user_scripts )
      $ksmroot/helpers/list_shscripts.msh $ksmuser/scripts
      ;;
    start_koreader )
      $ksmroot/onstart/start_koreader.sh
      ;;
    start_nickel_koreader_switch )
      $ksmroot/onstart/nickelkoreaderloop.sh
      ;;
    start_koreader_nickel_switch )
      $ksmroot/onstart/koreadernickelloop.sh
      ;;
    koreader_additions )
      koreaderadditionsselection=$($ksmroot/kobomenu.sh $KoreaderAdditionsmoptions)
      case $koreaderadditionsselection in
        start_nickel_koreader_switch )
          $ksmroot/onstart/nickelkoreaderloop.sh
          ;;
        start_koreader_nickel_switch )
          $ksmroot/onstart/koreadernickelloop.sh
          ;;
        find_and_open )
          $ksmroot/helpers/list_shscripts.msh "$ksmroot/koreaderfindsh"
          ;;
        select_koreader_version )
          $ksmroot/helpers/list_koreaderdirs.msh "$koreaderbasedir"
          ;;
      esac
      ;;
    start_kobolauncher )
      $ksmroot/onstart/start_KoboLauncherA.sh
      ;;
    start_vlasovsoftlauncher )
      $ksmroot/onstart/start_vlasovlauncher.sh
      ;;
    start_coolreader )
      $ksmroot/onstart/cr3.sh
      ;;
    start_coolreader_ls )
      $ksmroot/onstart/cr3_180.sh
      ;;
    coolreader )
      coolreaderselection=$($ksmroot/kobomenu.sh $CoolreaderAdditionsmoptions $mupdateoptions)
      case $coolreaderselection in
        start_coolreader )
          $ksmroot/onstart/cr3.sh
          ;;
        start_coolreader_ls )
          $ksmroot/onstart/cr3_180.sh
          ;;
      esac
      ;;

    front_light_on )
      $frontlightprg "$frontlightOnLevel"
      export KSMfrontlightlevel=$frontlightOnLevel
      ;;
    front_light_off )
      $frontlightprg "0"
      export KSMfrontlightlevel=0
      ;;
    start_nickel_koreader_switch )
      $ksmroot/onstart/nickelkoreaderloop.sh
      ;;
    start_koreader_nickel_switch )
      $ksmroot/onstart/koreadernickelloop.sh
      ;;
    find_and_open )
      $ksmroot/helpers/list_shscripts.msh "$ksmroot/koreaderfindsh"
      ;;
    select_koreader_version )
      $ksmroot/helpers/list_koreaderdirs.msh "$koreaderbasedir"
      ;;

  esac
done

if [ "$installUpdate" == "TRUE" ]; then

  if [ "$newpickelversion" == "TRUE" ]; then
    /usr/local/Kobo/pickel can-upgrade
    CAN_UPGRADE=$?
  else
    CAN_UPGRADE=1
  fi

  if [ $CAN_UPGRADE == 1 ] && [ -e /mnt/onboard/.kobo/Kobo.tgz ]; then
# replaced zcat by tar tzf following frostschutz's suggestion, cf. http://www.mobileread.com/forums/showpost.php?p=3001793&postcount=568
    tar tzf /mnt/onboard/.kobo/Kobo.tgz > /dev/null && tar zxf /mnt/onboard/.kobo/Kobo.tgz -C /usr/local/Kobo/ && ( cat /usr/local/Kobo/revinfo >> /usr/local/Kobo/install.log )
    rm /mnt/onboard/.kobo/Kobo.tgz
# echo "Done upgrading..."
  fi
                               
  if [ $CAN_UPGRADE == 1 ] && [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
    zcat /etc/images/$PREFIX\ghostbuster.raw.gz > /dev/fb0
    $ksmroot/scripts_intern/div/on-animator.sh &
    udevfiles="usb ac sd plug"
    udevdir="/usr/local/Kobo/udev"
    preservedir="$ksmroot/preserve"
    [ "$KSMdebugmode" == "true" ] && echo "udevfiles: $udevfiles" >> $debug_logfile
    [ "$KSMdebugmode" == "true" ] && echo "udevdir: $udevdir" >> $debug_logfile
    [ "$KSMdebugmode" == "true" ] && echo "preserveRcS: $preserveRcS" >> $debug_logfile

    if [ "$preserveRcS" == "TRUE"  ]; then
      [ ! -e $preservedir ] && mkdir -p $preservedir
      [ -f /etc/init.d/rcS ] && cp "/etc/init.d/rcS" "$preservedir"
      for udevfile in $udevfiles; do
        [ -f "$udevdir/$udevfile" ] && cp "$udevdir/$udevfile" "$preservedir"
      done
    fi

# replaced zcat by tar tzf following frostschutz's suggestion, cf. http://www.mobileread.com/forums/showpost.php?p=3001793&postcount=568
    tar tzf /mnt/onboard/.kobo/KoboRoot.tgz > /dev/null && tar zxf /mnt/onboard/.kobo/KoboRoot.tgz -C / && ( cat /usr/local/Kobo/revinfo >> /usr/local/Kobo/install.log )

    if [ -e /mnt/onboard/.kobo/upgrade ]; then
      /etc/init.d/upgrade-wifi.sh
      rm -rf /mnt/onboard/.kobo/upgrade
    fi
    rm /mnt/onboard/.kobo/KoboRoot.tgz
    killall on-animator.sh
    echo "Done upgrading..."

    if [ "$preserveRcS" == "TRUE"  ]; then
      [ -f $preservedir/rcS ] && cp "$preservedir/rcS" "/etc/init.d"
      for udevfile in $udevfiles; do
        [ -f "$preservedir/$udevfile" ] && cp "$preservedir/$udevfile" "$udevdir"
      done
    fi

    zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
    zcat /etc/images/$PREFIX\reboot.raw.gz | /usr/local/Kobo/pickel showpic
    sync
    reboot
  fi

fi

# Emergency exit, but how do you get there?
reboot

