import re
import sys

try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup

def run(bk):
    try:
        list_id = {}
        for id_file, href in bk.text_iter():        
            data = bk.readfile(id_file)
            soup = BeautifulSoup(data, "html5lib")
            a_list = soup.findAll()

            if a_list is not None or not a_list:
                for a in a_list:
                    try:
                        list_id['"#'+a.attrs['id']+'"'] = 'href="../'+href+'#'+a.attrs['id']+'"'
                    except:
                        continue
            else:
                continue
        
        for id_file, href in bk.text_iter():
            data = bk.readfile(id_file)
            for id in list_id:
                rgx = re.compile('(href=' + id + ')')
                data = re.sub(rgx, list_id[id], data)
                           
            # Mise à jour du fichier source
            try:
                print("Mise a jour de " + id_file + "...")
                bk.writefile(id_file, data)
            except:
                print(str(sys.exc_info()[0]) + " : " + str(sys.exc_info()[1]))
    except:
        print(str(sys.exc_info()[0]) + " : " + str(sys.exc_info()[1]))

    return 0

def main():
    print("[-] No main")
    return -1

if __name__ == "__main__":
    sys.exit(main())
