#include <stdlib.h>
#include <stdio.h>

int
main(int argc, char *argv[])
{
  unsigned major, minor, build;
  FILE *ifp, *ofp;

  if (argc != 4 && argc != 5) {
    fprintf(stderr, "incver cmd old.h new.h new.wxi\n");
    fprintf(stderr, "\twhere cmd is either MAJOR, MINOR, or BUILD\n");
    return EXIT_FAILURE;
  }

  ifp = fopen(argv[2], "rt");
  if (ifp == NULL) {
    perror(argv[2]);
    return EXIT_FAILURE;
  }

  if (fscanf(ifp, "#define STRING_VERSION \"%u.%u.%u\"\n", &major, &minor, &build) != 3) {
    fprintf(stderr, "Invalid input format.\n");
    return EXIT_FAILURE;
  }

  fclose(ifp);

  if (strcmp(argv[1], "MAJOR") == 0) {
    major += 1;
    minor = 0;
  }
  if (strcmp(argv[1], "MINOR") == 0) {
    minor += 1;
  }
  if (strcmp(argv[1], "BUILD") == 0) {
    build += 1;
  }

  ofp = fopen(argv[3], "wt");
  if (ofp == NULL) {
    perror(argv[3]);
    return EXIT_FAILURE;
  }

  fprintf(ofp, "#define STRING_VERSION \"%u.%u.%u\"\n", major, minor, build);
  fprintf(ofp, "#define MAJOR_VERSION %u\n", major);
  fprintf(ofp, "#define MINOR_VERSION %u\n", minor);
  fprintf(ofp, "#define BUILD_VERSION %u\n", build);

  fclose(ofp);

  if (argc < 4) return EXIT_SUCCESS;

  ofp = fopen(argv[4], "wt");
  if (ofp == NULL) {
    perror(argv[3]);
    return EXIT_FAILURE;
  }

  fprintf(ofp, "<?xml version=\"1.0\"?>");
  fprintf(ofp, "<Include>");
  fprintf(ofp, "<?define FullVersion = %u.%u.%u ?>", major, minor, build);
  fprintf(ofp, "<?define MajorVersion = %u ?>", major);
  fprintf(ofp, "<?define MinorVersion = %u ?>", minor);
  fprintf(ofp, "<?define BuildVersion = %u ?>", build);
  fprintf(ofp, "</Include>\n");

  fclose(ofp);
  
}
