#! /bin/sh

# Start from our working directory
cd "${0%/*}" || exit 1

# Check whether nickel is running
FROM_NICKEL=0
pgrep -f nickel > /dev/null && FROM_NICKEL=1

if [ "$FROM_NICKEL" -eq 1 ]; then
	# Siphon a few things from nickel's environment
	eval "$(xargs -n 1 -0 < /proc/$(pidof nickel)/environ | grep -e DBUS_SESSION_BUS_ADDRESS -e WIFI_MODULE -e INTERFACE)"
	export DBUS_SESSION_BUS_ADDRESS WIFI_MODULE INTERFACE
	# Flush the disks: might help avoid damaging nickel's DB...
	sync
	# Stop kobo software because it's running
	killall nickel hindenburg sickel fickel fmon > /dev/null 2>&1
fi

export PRODUCT=$(/bin/kobo_config.sh 2> /dev/null)

./sketch > crash.log 2>&1
RESULT=$?

if [ "$FROM_NICKEL" -eq 1 ]; then
	# Start kobo software because it was running before sketch
	./nickel.sh &
elif ! pgrep -f kbmenu > /dev/null; then
	# If we were called from advboot then we must reboot to go to the menu
	/sbin/reboot
fi

return $RESULT
