#! /bin/sh

export LANG=en_US.UTF-8
export PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/lib:
export NICKEL_HOME=/mnt/onboard/.kobo
export LD_LIBRARY_PATH=/usr/local/Kobo
export WIFI_MODULE_PATH=/drivers/${PLATFORM}/wifi/${WIFI_MODULE}.ko

( usleep 400000; /etc/init.d/on-animator.sh ) &

# Make sure we kill the WiFi first, nickel will fail is it's up
if lsmod | grep -q sdio_wifi_pwr; then
	killall udhcpc default.script wpa_supplicant 2> /dev/null
	wlarm_le -i "$INTERFACE" down
	ifconfig "$INTERFACE" down
	# rmmod appears to be modprobe in disguise, defaulting to the -r flag. If
	# re-specifying -r starts to fail one day, switch to rmmod without args, or
	# modprobe -r.
	rmmod -r "$WIFI_MODULE"
	rmmod -r sdio_wifi_pwr
fi

grep -q "dhcpcd=true" "/mnt/onboard/.kobo/Kobo/Kobo eReader.conf" && dhcpcd -d -t 10 &
/usr/local/Kobo/hindenburg > /dev/null 2>&1 &
LIBC_FATAL_STDERR_=1 /usr/local/Kobo/nickel -platform kobo -skipFontLoad > /dev/null 2>&1 &
lsmod | grep -q lowmem || insmod "/drivers/${PLATFORM}/misc/lowmem.ko" &

# Launch sickel if it exists
[ -x /usr/local/Kobo/sickel ] && /usr/local/Kobo/sickel -platform kobo:noscreen > /dev/null 2>&1 &

# Handle SD card
[ -e "/dev/mmcblk1p1" ] && echo sd add /dev/mmcblk1p1 >> /tmp/nickel-hardware-status &
