/* when I open event1, theres this block we need to make somehow
[root@kindle root]# evtest /dev/input/event1
Input driver version is 1.0.1
Input device ID: bus 0x0 vendor 0x0 product 0x0 version 0x0
Input device name: "cyttsp4_mt"
Supported events:
  Event type 0 (Sync)
  Event type 1 (Key)
    Event code 325 (ToolFinger)
    Event code 330 (Touch)
    Event code 333 (Tool Doubletap)
    Event code 334 (Tool Tripletap)
  Event type 2 (Relative)
  Event type 3 (Absolute)
    Event code 47 (MT Slot)
      Value      0
      Min        0
      Max       10
    Event code 53 (MT X)
      Value      0
      Min        0
      Max     1071
    Event code 54 (MT Y)
      Value      0
      Min        0
      Max     1447
    Event code 57 (MT Tracking ID)
      Value      0
      Min        0
      Max    65535
Testing ... (interrupt to exit)

*/


/*
 *  Copyright (c) 1999-2001 Vojtech Pavlik
 */

/*
 *  Input driver event debug module - dumps all events into syslog
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Should you need to contact me, the author, you can do so either by
 * e-mail - mail your message to <vojtech@ucw.cz>, or by paper mail:
 * Vojtech Pavlik, Simunkova 1594, Prague 8, 182 00 Czech Republic
 */

#define pr_fmt(fmt) KBUILD_MODNAME ": " fmt

#include <linux/poll.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/input.h>
#include <linux/major.h>
#include <linux/device.h>
#include "input-compat.h"

MODULE_AUTHOR("Vojtech Pavlik <vojtech@ucw.cz>");
MODULE_DESCRIPTION("Input driver event debug module");
MODULE_LICENSE("GPL");



#define  DEVICE_NAME "mdcdev"    ///< The device will appear at /dev/ebbchar using this value
#define  CLASS_NAME  "mdc"        ///< The device class -- this is a character device driver

static struct class*  mdccharClass  = NULL; ///< The device-driver class struct pointer
static struct device* mdccharDevice = NULL; ///< The device-driver device struct pointer

#define EVENT_LIST_MAX	1024
struct input_event event_list[EVENT_LIST_MAX];

static struct input_event *event_head = NULL;
static struct input_event *event_tail = NULL;
static int event_list_size = 0;
//static int event_hidx = 0;
//static int event_tidx = 0;

static int Major;		/* Major number assigned to our device driver */

static int Device_Open = 0;

static int device_open(struct inode *, struct file *);
static int device_release(struct inode *, struct file *);
static ssize_t device_read(struct file *, char *, size_t, loff_t *);
static ssize_t device_write(struct file *, const char *, size_t, loff_t *);
static long evdev_ioctl(struct file *file, unsigned int cmd, unsigned long arg);

static struct file_operations fops = {
	.owner =	THIS_MODULE,
	.read = device_read,
	.write = device_write,
	.open = device_open,
	.release = device_release,
	.unlocked_ioctl	= evdev_ioctl,
};


static long evdev_do_ioctl(struct file *file, unsigned int cmd,
			   void __user *p, int compat_mode)
{


	/*
struct evdev_client *client = file->private_data;
	struct evdev *evdev = client->evdev;
	struct input_dev *dev = evdev->handle.dev;
	struct input_absinfo abs;
	struct ff_effect effect;
*/

	int __user *ip = (int __user *)p;

//printk(KERN_ALERT "cmd = 0x%X\n", cmd);
/*
	unsigned int i, t, u, v;
	unsigned int size;
	int error;

define _IOC_WRITE	1U
define _IOC_READ	2U
#define _IOC(dir,type,nr,size) \
	(
	((nr)   << _0) | \
	 ((type) << _8) | \
	 ((size) << _16))
	((dir)  << _30) | \
#define _IOR(type,nr,size)	_IOC(_IOC_READ,(type),(nr),(_IOC_TYPECHECK(size)))


#define EVIOCGVERSION		_IOR('E', 0x01, int)			
#define EVIOCGID		_IOR('E', 0x02, struct input_id)	
#define EVIOCGREP		_IOR('E', 0x03, unsigned int[2])	
#define EVIOCSREP		_IOW('E', 0x03, unsigned int[2])	

#define EVIOCGNAME(len)		_IOC(_IOC_READ, 'E', 0x06, len)		

#define EVIOCGBIT(ev,len)	_IOC(_IOC_READ, 'E', 0x20 + ev, len)	

170417:195118 [62186.216867] cmd = 0x80044501 -- EVIOCGVERSION
170417:195118 [62186.221055] cmd = 0x80084502 -- EVIOCGID
170417:195118 [62186.226812] cmd = 0x81004506 -- READ, 0100, E, 06 - EVIOCGNAME(len) _IOC(_IOC_READ, 'E', 0x06, x0100
170417:195118 [62186.230545] cmd = 0x801F4520 -- READ, 001F, E, 20 - EVIOCGBIT(ev,len)	_IOC(_IOC_READ, 'E', 0x20 + ev, x001F

*/
/*
170417:201150 [63418.095894] EVIOCGVERSION = 0x80044501
170417:201150 [63418.099645] EVIOCGID = 0x80084502
170417:201150 [63418.102960] EVIOCGREP = 0x80084503
170417:201150 [63418.106880] EVIOCSREP = 0x40084503
170417:201150 [63418.110284] EVIOCRMFF = 0x40044581
170417:201150 [63418.113685] EVIOCGEFFECTS = 0x80044584
170417:201150 [63418.117932] EVIOCGRAB = 0x40044590
170417:201150 [63418.121336] EVIOCGKEYCODE = 0x80084504
170417:201150 [63418.125460] EVIOCSKEYCODE = 0x40084504
170417:201150 [63418.129212] EVIOCGKEYCODE_V2 = 0x80284504
170417:201150 [63418.133221] EVIOCSKEYCODE_V2 = 0x40284504


170417:201524 [63632.557117] EVIOCGPROP(0) = 0x80004509
170417:201524 [63632.560868] EVIOCGKEY(0) = 0x80004518
170417:201524 [63632.564530] EVIOCGLED(0) = 0x80004519
170417:201524 [63632.568694] EVIOCGSND(0) = 0x8000451A
170417:201524 [63632.572358] EVIOCGSW(0) = 0x8000451B
170417:201524 [63632.576316] EVIOCGNAME(0) = 0x80004506
170417:201524 [63632.580067] EVIOCGPHYS(0) = 0x80004507
170417:201524 [63632.583816] EVIOCGUNIQ(0) = 0x80004508
170417:201524 [63632.588049] EVIOC_MASK_SIZE(EVIOCSFF) = 0x40004580


*/



	// First we check for fixed-length commands 
	switch (cmd) {

	case EVIOCGVERSION:
		return put_user(EV_VERSION, ip);
/*
	case EVIOCGID:
		if (copy_to_user(p, &dev->id, sizeof(struct input_id)))
			return -EFAULT;
		return 0;

	case EVIOCGREP:
		if (!test_bit(EV_REP, dev->evbit))
			return -ENOSYS;
		if (put_user(dev->rep[REP_DELAY], ip))
			return -EFAULT;
		if (put_user(dev->rep[REP_PERIOD], ip + 1))
			return -EFAULT;
		return 0;

	case EVIOCSREP:
		if (!test_bit(EV_REP, dev->evbit))
			return -ENOSYS;
		if (get_user(u, ip))
			return -EFAULT;
		if (get_user(v, ip + 1))
			return -EFAULT;

		input_inject_event(&evdev->handle, EV_REP, REP_DELAY, u);
		input_inject_event(&evdev->handle, EV_REP, REP_PERIOD, v);

		return 0;

	case EVIOCRMFF:
		return input_ff_erase(dev, (int)(unsigned long) p, file);

	case EVIOCGEFFECTS:
		i = test_bit(EV_FF, dev->evbit) ?
				dev->ff->max_effects : 0;
		if (put_user(i, ip))
			return -EFAULT;
		return 0;

	case EVIOCGRAB:
		if (p)
			return evdev_grab(evdev, client);
		else
			return evdev_ungrab(evdev, client);

	case EVIOCGKEYCODE:
		return evdev_handle_get_keycode(dev, p);

	case EVIOCSKEYCODE:
		return evdev_handle_set_keycode(dev, p);

	case EVIOCGKEYCODE_V2:
		return evdev_handle_get_keycode_v2(dev, p);

	case EVIOCSKEYCODE_V2:
		return evdev_handle_set_keycode_v2(dev, p);
	}
*/

/*
	size = _IOC_SIZE(cmd);

	// Now check variable-length commands 
#define EVIOC_MASK_SIZE(nr)	((nr) & ~(_IOC_SIZEMASK << _IOC_SIZESHIFT))
	switch (EVIOC_MASK_SIZE(cmd)) {

	case EVIOCGPROP(0):
		return bits_to_user(dev->propbit, INPUT_PROP_MAX,
				    size, p, compat_mode);

	case EVIOCGKEY(0):
		return bits_to_user(dev->key, KEY_MAX, size, p, compat_mode);

	case EVIOCGLED(0):
		return bits_to_user(dev->led, LED_MAX, size, p, compat_mode);

	case EVIOCGSND(0):
		return bits_to_user(dev->snd, SND_MAX, size, p, compat_mode);

	case EVIOCGSW(0):
		return bits_to_user(dev->sw, SW_MAX, size, p, compat_mode);

	case EVIOCGNAME(0):
		return str_to_user(dev->name, size, p);

	case EVIOCGPHYS(0):
		return str_to_user(dev->phys, size, p);

	case EVIOCGUNIQ(0):
		return str_to_user(dev->uniq, size, p);

	case EVIOC_MASK_SIZE(EVIOCSFF):
		if (input_ff_effect_from_user(p, size, &effect))
			return -EFAULT;

		error = input_ff_upload(dev, &effect, file);

		if (put_user(effect.id, &(((struct ff_effect __user *)p)->id)))
			return -EFAULT;

		return error;
	}

	// Multi-number variable-length handlers 
	if (_IOC_TYPE(cmd) != 'E')
		return -EINVAL;

	if (_IOC_DIR(cmd) == _IOC_READ) {

		if ((_IOC_NR(cmd) & ~EV_MAX) == _IOC_NR(EVIOCGBIT(0, 0)))
			return handle_eviocgbit(dev,
						_IOC_NR(cmd) & EV_MAX, size,
						p, compat_mode);

		if ((_IOC_NR(cmd) & ~ABS_MAX) == _IOC_NR(EVIOCGABS(0))) {

			if (!dev->absinfo)
				return -EINVAL;

			t = _IOC_NR(cmd) & ABS_MAX;
			abs = dev->absinfo[t];

			if (copy_to_user(p, &abs, min_t(size_t,
					size, sizeof(struct input_absinfo))))
				return -EFAULT;

			return 0;
		}
	}

	if (_IOC_DIR(cmd) == _IOC_WRITE) {

		if ((_IOC_NR(cmd) & ~ABS_MAX) == _IOC_NR(EVIOCSABS(0))) {

			if (!dev->absinfo)
				return -EINVAL;

			t = _IOC_NR(cmd) & ABS_MAX;

			if (copy_from_user(&abs, p, min_t(size_t,
					size, sizeof(struct input_absinfo))))
				return -EFAULT;

			if (size < sizeof(struct input_absinfo))
				abs.resolution = 0;

			// We can't change number of reserved MT slots 
			if (t == ABS_MT_SLOT)
				return -EINVAL;

			//
			// Take event lock to ensure that we are not
			// changing device parameters in the middle
			// of event.
			//
			spin_lock_irq(&dev->event_lock);
			dev->absinfo[t] = abs;
			spin_unlock_irq(&dev->event_lock);

			return 0;
		}
*/
	}

	return -EINVAL;
}


static long evdev_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	return evdev_do_ioctl(file, cmd, (void __user *)arg, 0);
}


/* 
 * Called when a process tries to open the device file, like
 * "cat /dev/mycharfile"
 */
static int device_open(struct inode *inode, struct file *file)
{
	


	if (Device_Open)
		return -EBUSY;

	Device_Open++;
	try_module_get(THIS_MODULE);

	
	event_head = NULL;
	event_tail = NULL;

	return 0;
}

/* 
 * Called when a process closes the device file.
 */
static int device_release(struct inode *inode, struct file *file)
{

	Device_Open--;		/* We're now ready for our next caller */

	/* 
	 * Decrement the usage count, or else once you opened the file, you'll
	 * never get get rid of the module. 
	 */
	module_put(THIS_MODULE);

	printk(KERN_ALERT "Freeing data_list of size %d.\n", event_list_size);
	
	
	event_head = NULL;
	event_tail = NULL;

return 0;
}

/* 
 * Called when a process, which already opened the dev file, attempts to
 * read from it.
 */
static ssize_t device_read(struct file *filp,	/* see include/linux/fs.h   */
			   char *buffer,	/* buffer to fill with data */
			   size_t length,	/* length of the buffer     */
			   loff_t * offset)
{

	
	

	/*
	 * Number of bytes actually written to the buffer 
	 */
	int bytes_read = 0;

	/*
	 * If we're at the end of the message, 
	 * return 0 signifying end of file 
	 */
	if (event_list_size == 0)
		return 0;


	if (length < input_event_size()){
		printk(KERN_ALERT "111\n");
		return -EINVAL;
	}


	while (bytes_read + input_event_size() <= length &&
	       event_list_size >0 ) {

		
		if (input_event_to_user(buffer + bytes_read, event_head)){
			printk(KERN_ALERT "222\n");
			return -EFAULT;
}

		bytes_read += input_event_size();
		if( event_head == &(event_list[EVENT_LIST_MAX-1]) ){
			event_head= event_list ; // nees to go to 0
		}else{
			event_head= event_head+1;
		}
		event_list_size--;
	}

	

	/* 
	 * Most read functions return the number of bytes put into the buffer
	 */
	return bytes_read;

	

	
}

/*  
 * Called when a process writes to dev file: echo "hi" > /dev/hello 
 */
static ssize_t
device_write(struct file *filp, const char *buff, size_t len, loff_t * off)
{
	printk(KERN_ALERT "Sorry, this operation isn't supported.\n");
	return -EINVAL;
}



















static void evbug_event(struct input_handle *handle, unsigned int type, unsigned int code, int value)
{

	struct input_event event;
	



	if( Device_Open == 1 ){
		
		do_gettimeofday(&event.time);
		event.type = type;
		event.code = code;
		event.value = value;

		if( event_list_size == 0 ){
			event_head= event_list;
			event_tail= event_list;
			*event_tail = event;
			event_list_size++;

		}else if( event_list_size == EVENT_LIST_MAX ){
			// lets say size = 1024, head = 513, tail = 512

			if( event_head == &(event_list[EVENT_LIST_MAX-1]) ){
				event_head= event_list ; // nees to go to 0
			}else{
				event_head= event_head+1;
			}
			event_tail= event_tail+1;
			*event_tail = event;
			// event_list_size+= 0;
		}else{
			// lets say size = 1023, head = 1, tail = 1023
			//event_head= event_list; // stays 1
			if( event_tail  == &(event_list[EVENT_LIST_MAX-1]) ){
				event_tail= event_list ; // nees to go to 0
			}
			else{
				event_tail = event_tail+1;
			}

			*event_tail = event; 
			event_list_size++;
		}
		

	}
	//printk(KERN_DEBUG pr_fmt("Event. Dev: %s, Type: %d, Code: %d, Value: %d\n"),
	       //dev_name(&handle->dev->dev), type, code, value);
}

static int evbug_connect(struct input_handler *handler, struct input_dev *dev,
			 const struct input_device_id *id)
{
	struct input_handle *handle;
	int error;

	handle = kzalloc(sizeof(struct input_handle), GFP_KERNEL);
	if (!handle)
		return -ENOMEM;

	handle->dev = dev;
	handle->handler = handler;
	handle->name = "evbug";

	error = input_register_handle(handle);
	if (error)
		goto err_free_handle;

	error = input_open_device(handle);
	if (error)
		goto err_unregister_handle;

	printk(KERN_DEBUG pr_fmt("Connected device: %s (%s at %s)\n"),
	       dev_name(&dev->dev),
	       dev->name ?: "unknown",
	       dev->phys ?: "unknown");

	return 0;

 err_unregister_handle:
	input_unregister_handle(handle);
 err_free_handle:
	kfree(handle);
	return error;
}

static void evbug_disconnect(struct input_handle *handle)
{
	printk(KERN_DEBUG pr_fmt("Disconnected device: %s\n"),
	       dev_name(&handle->dev->dev));

	input_close_device(handle);
	input_unregister_handle(handle);
	kfree(handle);
}

static const struct input_device_id evbug_ids[] = {
	{
                 .flags = INPUT_DEVICE_ID_MATCH_EVBIT |
                                 INPUT_DEVICE_ID_MATCH_KEYBIT |
                                 INPUT_DEVICE_ID_MATCH_RELBIT,
                 .evbit = { BIT_MASK(EV_KEY) | BIT_MASK(EV_REL) },
                 .keybit = { [BIT_WORD(BTN_LEFT)] = BIT_MASK(BTN_LEFT) },
                 .relbit = { BIT_MASK(REL_X) | BIT_MASK(REL_Y) },
         },      /* A mouse like device, at least one button,
                    two relative axes */
	{
                 .flags = INPUT_DEVICE_ID_MATCH_EVBIT |
                                 INPUT_DEVICE_ID_MATCH_KEYBIT,
                 .evbit = { BIT_MASK(EV_KEY)  },
                 .keybit = { [BIT_WORD(KEY_ENTER)] = BIT_MASK(KEY_ENTER) },
         },      /* A key like device,that has the enter key of  */
	{ },			/* Terminating zero entry */
};

MODULE_DEVICE_TABLE(input, evbug_ids);

static struct input_handler evbug_handler = {
	.event =	evbug_event,
	.connect =	evbug_connect,
	.disconnect =	evbug_disconnect,
	.name =		"mdcbug",
	.id_table =	evbug_ids,
	.fops =		&fops,
	.minor		= 253,
	
};

static int __init evbug_init(void)
{
	int ret = 0;
	

	Major = register_chrdev(0, DEVICE_NAME, &fops);

	if (Major < 0) {
	  printk(KERN_ALERT "Registering char device failed with %d\n", Major);
	  return Major;
	}

	printk(KERN_INFO "MDCBUG: registered correctly with major number %d\n", Major);


// Register the device class
   mdccharClass = class_create(THIS_MODULE, CLASS_NAME);
   if (IS_ERR(mdccharClass)){                // Check for error and clean up if there is
      unregister_chrdev(Major, DEVICE_NAME);
      printk(KERN_ALERT "Failed to register device class\n");
      return PTR_ERR(mdccharClass);          // Correct way to return an error on a pointer
   }
   printk(KERN_INFO "MDCBUG: device class registered correctly\n");


// Register the device driver
   mdccharDevice = device_create(mdccharClass, NULL, MKDEV(Major, 0), NULL, DEVICE_NAME);
   if (IS_ERR(mdccharDevice)){               // Clean up if there is an error
      class_destroy(mdccharClass);           // Repeated code but the alternative is goto statements
      unregister_chrdev(Major, DEVICE_NAME);
      printk(KERN_ALERT "Failed to create the device\n");
      return PTR_ERR(mdccharDevice);
   }
   printk(KERN_INFO "MDCBUG: device class created correctly\n"); // Made it! device was initialized


ret = input_register_handler(&evbug_handler);

Device_Open = 0;
	return ret;
}

static void __exit evbug_exit(void)
{
	input_unregister_handler(&evbug_handler);
	

	device_destroy(mdccharClass, MKDEV(Major, 0));     // remove the device
   class_unregister(mdccharClass);                          // unregister the device class
   class_destroy(mdccharClass);                             // remove the device class
   unregister_chrdev(Major, DEVICE_NAME);             // unregister the major number
   printk(KERN_INFO "MDCBUG: Goodbye from the LKM!\n");

}

module_init(evbug_init);
module_exit(evbug_exit);
